/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.Sound;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;

public class ShipSprite
extends Sprite {
    static int[] BDx = new int[]{0, 0, 1, 1, 1, 0, -1, -1, -1};
    static int[] BDy = new int[]{0, -1, -1, 0, 1, 1, 1, 0, -1};
    static int[] BPx = new int[]{0, 0, 2, 2, 2, 0, -2, -2, -2};
    static int[] BPy = new int[]{0, -2, -2, 0, 2, 2, 2, 0, -2};
    static int[] BtClrTab = new int[]{2, 4, 208, 209, 224, 225, 79, 95};
    int newDir;
    int count;
    int soundCount;
    public static final int NORTH_EDGE = 5;
    public static final int EAST_EDGE = 7;
    public static final int SOUTH_EDGE = 1;
    public static final int WEST_EDGE = 3;

    public ShipSprite(Micropolis engine, int xpos, int ypos, int edge) {
        super(engine, SpriteKind.SHI);
        this.x = xpos * 16 + 8;
        this.y = ypos * 16 + 8;
        this.width = 48;
        this.height = 48;
        this.offx = -24;
        this.offy = -24;
        this.frame = edge;
        this.newDir = edge;
        this.dir = 10;
        this.count = 1;
    }

    @Override
    public void moveImpl() {
        int t = 2;
        --this.soundCount;
        if (this.soundCount <= 0) {
            if (this.city.PRNG.nextInt(4) == 0) {
                this.city.makeSound(this.x / 16, this.y / 16, Sound.HONKHONK_LOW);
            }
            this.soundCount = 200;
        }
        --this.count;
        if (this.count <= 0) {
            int tem;
            int pem;
            this.count = 9;
            if (this.newDir != this.frame) {
                this.frame = ShipSprite.turnTo(this.frame, this.newDir);
                return;
            }
            for (pem = tem = this.city.PRNG.nextInt(8); pem < tem + 8; ++pem) {
                int ypos;
                int xpos;
                int z = pem % 8 + 1;
                if (z == this.dir || !this.city.testBounds(xpos = this.x / 16 + BDx[z], ypos = this.y / 16 + BDy[z]) || (t = (int)this.city.getTile(xpos, ypos)) != 4 && t != 79 && t != 95 && !this.tryOther(t, this.dir, z)) continue;
                this.newDir = z;
                this.frame = ShipSprite.turnTo(this.frame, this.newDir);
                this.dir = z + 4;
                if (this.dir <= 8) break;
                this.dir -= 8;
                break;
            }
            if (pem == tem + 8) {
                this.dir = 10;
                this.newDir = this.city.PRNG.nextInt(8) + 1;
            }
        } else {
            int z = this.frame;
            if (z == this.newDir) {
                this.x += BPx[z];
                this.y += BPy[z];
            }
        }
        if (!this.spriteInBounds()) {
            this.frame = 0;
            return;
        }
        boolean found = false;
        for (int z : BtClrTab) {
            if (t != z) continue;
            found = true;
        }
        if (!found && !this.city.noDisasters) {
            this.explodeSprite();
            this.destroyTile(this.x / 16, this.y / 16);
        }
    }

    boolean tryOther(int tile, int oldDir, int newDir) {
        int z = oldDir + 4;
        if (z > 8) {
            z -= 8;
        }
        if (newDir != z) {
            return false;
        }
        return tile == 208 || tile == 209 || tile == 224 || tile == 225;
    }

    boolean spriteInBounds() {
        int xpos = this.x / 16;
        int ypos = this.y / 16;
        return this.city.testBounds(xpos, ypos);
    }
}

