/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityDimension;
import micropolisj.engine.TileSpec;
import micropolisj.engine.Tiles;

public class TileConstants {
    public static final short CLEAR = -1;
    public static final char DIRT = '\u0000';
    static final char RIVER = '\u0002';
    static final char REDGE = '\u0003';
    static final char CHANNEL = '\u0004';
    static final char RIVEDGE = '\u0005';
    static final char FIRSTRIVEDGE = '\u0005';
    static final char LASTRIVEDGE = '\u0014';
    static final char TREEBASE = '\u0015';
    static final char WOODS_LOW = '\u0015';
    static final char WOODS = '%';
    static final char WOODS_HIGH = '\'';
    static final char WOODS2 = '(';
    static final char WOODS5 = '+';
    static final char RUBBLE = ',';
    static final char LASTRUBBLE = '/';
    static final char FLOOD = '0';
    static final char LASTFLOOD = '3';
    static final char RADTILE = '4';
    static final char FIRE = '8';
    static final char ROADBASE = '@';
    static final char HBRIDGE = '@';
    static final char VBRIDGE = 'A';
    static final char ROADS = 'B';
    static final char ROADS2 = 'C';
    private static final char ROADS3 = 'D';
    private static final char ROADS4 = 'E';
    private static final char ROADS5 = 'F';
    private static final char ROADS6 = 'G';
    private static final char ROADS7 = 'H';
    private static final char ROADS8 = 'I';
    private static final char ROADS9 = 'J';
    private static final char ROADS10 = 'K';
    static final char INTERSECTION = 'L';
    static final char HROADPOWER = 'M';
    static final char VROADPOWER = 'N';
    static final char BRWH = 'O';
    static final char LTRFBASE = 'P';
    static final char BRWV = '_';
    static final char HTRFBASE = '\u0090';
    private static final char LASTROAD = '\u00ce';
    static final char POWERBASE = '\u00d0';
    static final char HPOWER = '\u00d0';
    static final char VPOWER = '\u00d1';
    static final char LHPOWER = '\u00d2';
    static final char LVPOWER = '\u00d3';
    static final char LVPOWER2 = '\u00d4';
    private static final char LVPOWER3 = '\u00d5';
    private static final char LVPOWER4 = '\u00d6';
    private static final char LVPOWER5 = '\u00d7';
    private static final char LVPOWER6 = '\u00d8';
    private static final char LVPOWER7 = '\u00d9';
    private static final char LVPOWER8 = '\u00da';
    private static final char LVPOWER9 = '\u00db';
    private static final char LVPOWER10 = '\u00dc';
    static final char RAILHPOWERV = '\u00dd';
    static final char RAILVPOWERH = '\u00de';
    static final char LASTPOWER = '\u00de';
    static final char RAILBASE = '\u00e0';
    static final char HRAIL = '\u00e0';
    static final char VRAIL = '\u00e1';
    static final char LHRAIL = '\u00e2';
    static final char LVRAIL = '\u00e3';
    static final char LVRAIL2 = '\u00e4';
    private static final char LVRAIL3 = '\u00e5';
    private static final char LVRAIL4 = '\u00e6';
    private static final char LVRAIL5 = '\u00e7';
    private static final char LVRAIL6 = '\u00e8';
    private static final char LVRAIL7 = '\u00e9';
    private static final char LVRAIL8 = '\u00ea';
    private static final char LVRAIL9 = '\u00eb';
    private static final char LVRAIL10 = '\u00ec';
    static final char HRAILROAD = '\u00ed';
    static final char VRAILROAD = '\u00ee';
    static final char LASTRAIL = '\u00ee';
    static final char RESBASE = '\u00f0';
    static final char RESCLR = '\u00f4';
    static final char HOUSE = '\u00f9';
    static final char LHTHR = '\u00f9';
    static final char HHTHR = '\u0104';
    static final char RZB = '\u0109';
    static final char HOSPITAL = '\u0199';
    static final char CHURCH = '\u01a2';
    static final char COMBASE = '\u01a7';
    static final char COMCLR = '\u01ab';
    static final char CZB = '\u01b4';
    static final char INDBASE = '\u0264';
    static final char INDCLR = '\u0268';
    static final char IZB = '\u0271';
    static final char PORTBASE = '\u02b5';
    static final char PORT = '\u02ba';
    static final char AIRPORT = '\u02cc';
    static final char POWERPLANT = '\u02ee';
    static final char FIRESTATION = '\u02fd';
    static final char POLICESTATION = '\u0306';
    static final char STADIUM = '\u0310';
    static final char FULLSTADIUM = '\u0320';
    static final char NUCLEAR = '\u0330';
    static final char LASTZONE = '\u033a';
    public static final char LIGHTNINGBOLT = '\u033b';
    static final char HBRDG0 = '\u033c';
    static final char HBRDG1 = '\u033d';
    static final char HBRDG2 = '\u033e';
    static final char HBRDG3 = '\u033f';
    static final char FOUNTAIN = '\u0348';
    static final char TINYEXP = '\u035c';
    private static final char LASTTINYEXP = '\u0363';
    static final char FOOTBALLGAME1 = '\u03a4';
    static final char FOOTBALLGAME2 = '\u03ac';
    static final char VBRDG0 = '\u03b4';
    static final char VBRDG1 = '\u03b5';
    static final char VBRDG2 = '\u03b6';
    static final char VBRDG3 = '\u03b7';
    public static final char LAST_TILE = '\u03bc';
    static final char[] RoadTable = new char[]{'B', 'C', 'B', 'D', 'C', 'C', 'E', 'I', 'B', 'G', 'B', 'H', 'F', 'K', 'J', 'L'};
    static final char[] RailTable = new char[]{'\u00e2', '\u00e3', '\u00e2', '\u00e4', '\u00e3', '\u00e3', '\u00e5', '\u00e9', '\u00e2', '\u00e7', '\u00e2', '\u00e8', '\u00e6', '\u00eb', '\u00ea', '\u00ec'};
    static final char[] WireTable = new char[]{'\u00d2', '\u00d3', '\u00d2', '\u00d4', '\u00d3', '\u00d3', '\u00d5', '\u00d9', '\u00d2', '\u00d7', '\u00d2', '\u00d8', '\u00d6', '\u00db', '\u00da', '\u00dc'};
    public static final char PWRBIT = '\u8000';
    public static final char ALLBITS = '\ufc00';
    public static final char LOMASK = '\u03ff';

    private TileConstants() {
    }

    public static boolean canAutoBulldozeRRW(int tileValue) {
        return tileValue >= 5 && tileValue <= 47 || tileValue >= 860 && tileValue <= 867;
    }

    public static boolean canAutoBulldozeZ(char tileValue) {
        return tileValue >= '\u0005' && tileValue <= '/' || tileValue >= '\u00d2' && tileValue <= '\u00dc' || tileValue >= '\u035c' && tileValue <= '\u0363';
    }

    public static String getTileBehavior(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        return ts != null ? ts.getAttribute("behavior") : null;
    }

    public static int getDescriptionNumber(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        if (ts != null) {
            return ts.getDescriptionNumber();
        }
        return -1;
    }

    public static int getPollutionValue(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null ? spec.getPollutionValue() : 0;
    }

    public static boolean isAnimated(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.animNext != null;
    }

    public static boolean isArsonable(int tile) {
        assert ((tile & 0x3FF) == tile);
        return !TileConstants.isZoneCenter(tile) && tile >= 249 && tile <= 826;
    }

    public static boolean isBridge(int tile) {
        return TileConstants.isRoad(tile) && !TileConstants.isCombustible(tile);
    }

    public static boolean isCombustible(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.canBurn;
    }

    public static boolean isConductive(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.canConduct;
    }

    public static boolean isIndestructible(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 44 && tile < 64;
    }

    public static boolean isIndestructible2(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 48 && tile < 64;
    }

    public static boolean isOverWater(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.overWater;
    }

    public static boolean isRubble(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 44 && tile <= 47;
    }

    public static boolean isTree(char tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= '\u0015' && tile <= '\'';
    }

    public static boolean isVulnerable(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 240 && tile <= 826 && !TileConstants.isZoneCenter(tile);
    }

    public static boolean checkWet(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile == 208 || tile == 209 || tile == 224 || tile == 225 || tile == 79 || tile == 95;
    }

    public static CityDimension getZoneSizeFor(int tile) {
        assert (TileConstants.isZoneCenter(tile));
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null ? spec.getBuildingSize() : null;
    }

    public static boolean isConstructed(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 0 && tile >= 64;
    }

    static boolean isRiverEdge(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 5 && tile <= 20;
    }

    public static boolean isDozeable(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.canBulldoze;
    }

    static boolean isFloodable(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile == 0 || TileConstants.isDozeable(tile) && TileConstants.isCombustible(tile);
    }

    public static boolean isRoad(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 64 && tile < 208;
    }

    public static boolean isRoadAny(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 64 && tile < 208 || tile == 237 || tile == 238;
    }

    public static boolean isRoadDynamic(int tile) {
        char tmp = TileConstants.neutralizeRoad(tile);
        return tmp >= 'B' && tmp <= 'L';
    }

    public static boolean roadConnectsEast(int tile) {
        return ((tile = (int)TileConstants.neutralizeRoad(tile)) == 238 || tile >= 64 && tile <= 78) && tile != 78 && tile != 237 && tile != 65;
    }

    public static boolean roadConnectsNorth(int tile) {
        return ((tile = (int)TileConstants.neutralizeRoad(tile)) == 237 || tile >= 64 && tile <= 78) && tile != 77 && tile != 238 && tile != 64;
    }

    public static boolean roadConnectsSouth(int tile) {
        return ((tile = (int)TileConstants.neutralizeRoad(tile)) == 237 || tile >= 64 && tile <= 78) && tile != 77 && tile != 238 && tile != 64;
    }

    public static boolean roadConnectsWest(int tile) {
        return ((tile = (int)TileConstants.neutralizeRoad(tile)) == 238 || tile >= 64 && tile <= 78) && tile != 78 && tile != 237 && tile != 65;
    }

    public static boolean isRail(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 224 && tile < 240;
    }

    public static boolean isRailAny(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 224 && tile < 240 || tile == 221 || tile == 222;
    }

    public static boolean isRailDynamic(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 226 && tile <= 236;
    }

    public static boolean railConnectsEast(int tile) {
        return (tile = (int)TileConstants.neutralizeRoad(tile)) >= 221 && tile <= 238 && tile != 222 && tile != 238 && tile != 225;
    }

    public static boolean railConnectsNorth(int tile) {
        return (tile = (int)TileConstants.neutralizeRoad(tile)) >= 221 && tile <= 238 && tile != 221 && tile != 237 && tile != 224;
    }

    public static boolean railConnectsSouth(int tile) {
        return (tile = (int)TileConstants.neutralizeRoad(tile)) >= 221 && tile <= 238 && tile != 221 && tile != 237 && tile != 224;
    }

    public static boolean railConnectsWest(int tile) {
        return (tile = (int)TileConstants.neutralizeRoad(tile)) >= 221 && tile <= 238 && tile != 222 && tile != 238 && tile != 225;
    }

    public static boolean isWireDynamic(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 210 && tile <= 220;
    }

    public static boolean wireConnectsEast(int tile) {
        char ntile = TileConstants.neutralizeRoad(tile);
        return TileConstants.isConductive(tile) && ntile != '\u00d0' && ntile != 'M' && ntile != '\u00dd';
    }

    public static boolean wireConnectsNorth(int tile) {
        char ntile = TileConstants.neutralizeRoad(tile);
        return TileConstants.isConductive(tile) && ntile != '\u00d1' && ntile != 'N' && ntile != '\u00de';
    }

    public static boolean wireConnectsSouth(int tile) {
        char ntile = TileConstants.neutralizeRoad(tile);
        return TileConstants.isConductive(tile) && ntile != '\u00d1' && ntile != 'N' && ntile != '\u00de';
    }

    public static boolean wireConnectsWest(int tile) {
        char ntile = TileConstants.neutralizeRoad(tile);
        return TileConstants.isConductive(tile) && ntile != '\u00d0' && ntile != 'M' && ntile != '\u00dd';
    }

    public static boolean isCommercialZone(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        if (ts != null) {
            if (ts.owner != null) {
                ts = ts.owner;
            }
            return ts.getBooleanAttribute("commercial-zone");
        }
        return false;
    }

    public static boolean isHospitalOrChurch(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 409 && tile < 423;
    }

    public static boolean isIndustrialZone(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        if (ts != null) {
            if (ts.owner != null) {
                ts = ts.owner;
            }
            return ts.getBooleanAttribute("industrial-zone");
        }
        return false;
    }

    public static boolean isResidentialClear(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 240 && tile <= 248;
    }

    public static boolean isResidentialZone(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 240 && tile < 409;
    }

    public static boolean isResidentialZoneAny(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        if (ts != null) {
            if (ts.owner != null) {
                ts = ts.owner;
            }
            return ts.getBooleanAttribute("residential-zone");
        }
        return false;
    }

    public static boolean isZoneAny(int tile) {
        assert ((tile & 0x3FF) == tile);
        return tile >= 240;
    }

    public static boolean isZoneCenter(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec spec = Tiles.get(tile);
        return spec != null && spec.zone;
    }

    public static char neutralizeRoad(int tile) {
        assert ((tile & 0x3FF) == tile);
        if (tile >= 64 && tile <= 206) {
            tile = (tile - 64 & 0xF) + 64;
        }
        return (char)tile;
    }

    public static int residentialZonePop(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        return ts.getPopulation();
    }

    public static int commercialZonePop(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        return ts.getPopulation() / 8;
    }

    public static int industrialZonePop(int tile) {
        assert ((tile & 0x3FF) == tile);
        TileSpec ts = Tiles.get(tile);
        return ts.getPopulation() / 8;
    }
}

