/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import micropolisj.engine.CityDimension;

public class TileSpec {
    int tileNumber;
    String name;
    TileSpec animNext;
    TileSpec onPower;
    TileSpec onShutdown;
    boolean canBulldoze;
    boolean canBurn;
    boolean canConduct;
    boolean overWater;
    boolean zone;
    public TileSpec owner;
    public int ownerOffsetX;
    public int ownerOffsetY;
    BuildingInfo buildingInfo;
    Map<String, String> attributes;
    List<String> images;

    protected TileSpec(int tileNumber, String tileName) {
        this.tileNumber = tileNumber;
        this.name = tileName;
        this.attributes = new HashMap<String, String>();
        this.images = new ArrayList<String>();
    }

    public static TileSpec parse(int tileNumber, String tileName, String inStr, Properties tilesRc) {
        TileSpec ts = new TileSpec(tileNumber, tileName);
        ts.load(inStr, tilesRc);
        return ts;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public boolean getBooleanAttribute(String key) {
        String v = this.getAttribute(key);
        return v != null && v.equals("true");
    }

    public BuildingInfo getBuildingInfo() {
        return this.buildingInfo;
    }

    private void resolveBuildingInfo(Map<String, TileSpec> tileMap) {
        String tmp = this.getAttribute("building");
        if (tmp == null) {
            return;
        }
        BuildingInfo bi = new BuildingInfo();
        String[] p2 = tmp.split("x");
        bi.width = Integer.parseInt(p2[0]);
        bi.height = Integer.parseInt(p2[1]);
        bi.members = new short[bi.width * bi.height];
        int startTile = this.tileNumber;
        if (bi.width >= 3) {
            --startTile;
        }
        if (bi.height >= 3) {
            startTile -= bi.width;
        }
        for (int row = 0; row < bi.height; ++row) {
            for (int col = 0; col < bi.width; ++col) {
                bi.members[row * bi.width + col] = (short)startTile;
                ++startTile;
            }
        }
        this.buildingInfo = bi;
    }

    public CityDimension getBuildingSize() {
        if (this.buildingInfo != null) {
            return new CityDimension(this.buildingInfo.width, this.buildingInfo.height);
        }
        return null;
    }

    public int getDescriptionNumber() {
        String v = this.getAttribute("description");
        if (v != null && v.startsWith("#")) {
            return Integer.parseInt(v.substring(1));
        }
        if (this.owner != null) {
            return this.owner.getDescriptionNumber();
        }
        return -1;
    }

    public String[] getImages() {
        return this.images.toArray(new String[0]);
    }

    public int getPollutionValue() {
        String v = this.getAttribute("pollution");
        if (v != null) {
            return Integer.parseInt(v);
        }
        if (this.owner != null) {
            return this.owner.getPollutionValue();
        }
        return 0;
    }

    public int getPopulation() {
        String v = this.getAttribute("population");
        if (v != null) {
            return Integer.parseInt(v);
        }
        return 0;
    }

    protected void load(String inStr, Properties tilesRc) {
        Scanner in = new Scanner(inStr);
        while (in.hasMore()) {
            if (in.peekChar() == 40) {
                in.eatChar(40);
                String k = in.readAttributeKey();
                String v = "true";
                if (in.peekChar() == 61) {
                    in.eatChar(61);
                    v = in.readAttributeValue();
                }
                in.eatChar(41);
                if (!this.attributes.containsKey(k)) {
                    this.attributes.put(k, v);
                    String sup = tilesRc.getProperty(k);
                    if (sup == null) continue;
                    this.load(sup, tilesRc);
                    continue;
                }
                this.attributes.put(k, v);
                continue;
            }
            if (in.peekChar() == 124 || in.peekChar() == 44) {
                in.eatChar(in.peekChar());
                continue;
            }
            String v = in.readImageSpec();
            this.images.add(v);
        }
        this.canBulldoze = this.getBooleanAttribute("bulldozable");
        this.canBurn = !this.getBooleanAttribute("noburn");
        this.canConduct = this.getBooleanAttribute("conducts");
        this.overWater = this.getBooleanAttribute("overwater");
        this.zone = this.getBooleanAttribute("zone");
    }

    public String toString() {
        return "{tile:" + this.name + "}";
    }

    boolean isNumberedTile() {
        return this.name.matches("^\\d+$");
    }

    void resolveReferences(Map<String, TileSpec> tileMap) {
        String tmp = this.getAttribute("becomes");
        if (tmp != null) {
            this.animNext = tileMap.get(tmp);
        }
        if ((tmp = this.getAttribute("onpower")) != null) {
            this.onPower = tileMap.get(tmp);
        }
        if ((tmp = this.getAttribute("onshutdown")) != null) {
            this.onShutdown = tileMap.get(tmp);
        }
        if ((tmp = this.getAttribute("building-part")) != null) {
            this.handleBuildingPart(tmp, tileMap);
        }
        this.resolveBuildingInfo(tileMap);
    }

    private void handleBuildingPart(String text, Map<String, TileSpec> tileMap) {
        String[] parts = text.split(",");
        if (parts.length != 3) {
            throw new Error("Invalid building-part specification");
        }
        this.owner = tileMap.get(parts[0]);
        this.ownerOffsetX = Integer.parseInt(parts[1]);
        this.ownerOffsetY = Integer.parseInt(parts[2]);
        assert (this.owner != null);
        assert (this.ownerOffsetX != 0 || this.ownerOffsetY != 0);
    }

    public static String[] generateTileNames(Properties recipe) {
        int ntiles = recipe.size();
        String[] tileNames = new String[ntiles];
        ntiles = 0;
        int i = 0;
        while (recipe.containsKey(Integer.toString(i))) {
            tileNames[ntiles++] = Integer.toString(i);
            ++i;
        }
        int naturalNumberTiles = ntiles;
        for (Object n_obj : recipe.keySet()) {
            int x;
            String n = (String)n_obj;
            if (n.matches("^\\d+$") && (x = Integer.parseInt(n)) >= 0 && x < naturalNumberTiles) {
                assert (tileNames[x].equals(n));
                continue;
            }
            assert (ntiles < tileNames.length);
            tileNames[ntiles++] = n;
        }
        assert (ntiles == tileNames.length);
        return tileNames;
    }

    static class Scanner {
        String str;
        int off = 0;

        Scanner(String str) {
            this.str = str;
        }

        private void skipWhitespace() {
            while (this.off < this.str.length() && Character.isWhitespace(this.str.charAt(this.off))) {
                ++this.off;
            }
        }

        public int peekChar() {
            this.skipWhitespace();
            if (this.off < this.str.length()) {
                return this.str.charAt(this.off);
            }
            return -1;
        }

        public void eatChar(int ch) {
            this.skipWhitespace();
            assert (this.str.charAt(this.off) == ch);
            ++this.off;
        }

        public String readAttributeKey() {
            this.skipWhitespace();
            int start = this.off;
            while (this.off < this.str.length() && (this.str.charAt(this.off) == '-' || Character.isLetterOrDigit(this.str.charAt(this.off)))) {
                ++this.off;
            }
            if (this.off != start) {
                return this.str.substring(start, this.off);
            }
            return null;
        }

        public String readAttributeValue() {
            return this.readString();
        }

        public String readImageSpec() {
            return this.readString();
        }

        protected String readString() {
            this.skipWhitespace();
            char endQuote = '\u0000';
            if (this.peekChar() == 34) {
                ++this.off;
                endQuote = '\"';
            }
            int start = this.off;
            while (this.off < this.str.length()) {
                char c = this.str.charAt(this.off);
                if (c == endQuote) {
                    int end = this.off++;
                    return this.str.substring(start, end);
                }
                if (endQuote == '\u0000' && (Character.isWhitespace((int)c) || c == ')' || c == '|')) {
                    int end = this.off;
                    return this.str.substring(start, end);
                }
                ++this.off;
            }
            return this.str.substring(start);
        }

        public boolean hasMore() {
            return this.peekChar() != -1;
        }
    }

    public static class BuildingInfo {
        int width;
        int height;
        short[] members;
    }
}

