/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import micropolisj.engine.TileSpec;

public class Tiles {
    static final Charset UTF8 = Charset.forName("UTF-8");
    static TileSpec[] tiles;
    static Map<String, TileSpec> tilesByName;

    static void readTiles() throws IOException {
        String tileName;
        String rawSpec;
        int i;
        ArrayList tilesList = new ArrayList();
        Properties tilesRc = new Properties();
        tilesRc.load(new InputStreamReader(Tiles.class.getResourceAsStream("/tiles.rc"), UTF8));
        String[] tileNames = TileSpec.generateTileNames(tilesRc);
        tiles = new TileSpec[tileNames.length];
        for (i = 0; i < tileNames.length && (rawSpec = tilesRc.getProperty(tileName = tileNames[i])) != null; ++i) {
            TileSpec ts = TileSpec.parse(i, tileName, rawSpec, tilesRc);
            tilesByName.put(tileName, ts);
            Tiles.tiles[i] = ts;
        }
        for (i = 0; i < tiles.length; ++i) {
            tiles[i].resolveReferences(tilesByName);
            TileSpec.BuildingInfo bi = tiles[i].getBuildingInfo();
            if (bi == null) continue;
            for (int j = 0; j < bi.members.length; ++j) {
                short tid = bi.members[j];
                int offx = (bi.width >= 3 ? -1 : 0) + j % bi.width;
                int offy = (bi.height >= 3 ? -1 : 0) + j / bi.width;
                if (Tiles.tiles[tid].owner != null || offx == 0 && offy == 0) continue;
                Tiles.tiles[tid].owner = tiles[i];
                Tiles.tiles[tid].ownerOffsetX = offx;
                Tiles.tiles[tid].ownerOffsetY = offy;
            }
        }
    }

    public static TileSpec load(String tileName) {
        return tilesByName.get(tileName);
    }

    public static TileSpec get(int tileNumber) {
        if (tileNumber >= 0 && tileNumber < tiles.length) {
            return tiles[tileNumber];
        }
        return null;
    }

    static void checkTiles() {
        for (int i = 0; i < tiles.length; ++i) {
        }
    }

    static {
        tilesByName = new HashMap<String, TileSpec>();
        try {
            Tiles.readTiles();
            Tiles.checkTiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

