/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.Sound;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.ToolPreview;
import micropolisj.engine.ToolResult;

class ToolEffect
implements ToolEffectIfc {
    final Micropolis city;
    final ToolPreview preview;
    final int originX;
    final int originY;

    ToolEffect(Micropolis city) {
        this(city, 0, 0);
    }

    ToolEffect(Micropolis city, int xpos, int ypos) {
        this.city = city;
        this.preview = new ToolPreview();
        this.originX = xpos;
        this.originY = ypos;
    }

    @Override
    public int getTile(int dx, int dy) {
        int c = this.preview.getTile(dx, dy);
        if (c != -1) {
            return c;
        }
        if (this.city.testBounds(this.originX + dx, this.originY + dy)) {
            return this.city.getTile(this.originX + dx, this.originY + dy);
        }
        return 0;
    }

    @Override
    public void makeSound(int dx, int dy, Sound sound) {
        this.preview.makeSound(dx, dy, sound);
    }

    @Override
    public void setTile(int dx, int dy, int tileValue) {
        this.preview.setTile(dx, dy, tileValue);
    }

    @Override
    public void spend(int amount) {
        this.preview.spend(amount);
    }

    @Override
    public void toolResult(ToolResult tr) {
        this.preview.toolResult(tr);
    }

    ToolResult apply() {
        if (this.originX - this.preview.offsetX < 0 || this.originX - this.preview.offsetX + this.preview.getWidth() > this.city.getWidth() || this.originY - this.preview.offsetY < 0 || this.originY - this.preview.offsetY + this.preview.getHeight() > this.city.getHeight()) {
            return ToolResult.UH_OH;
        }
        if (this.city.budget.totalFunds < this.preview.cost) {
            return ToolResult.INSUFFICIENT_FUNDS;
        }
        boolean anyFound = false;
        for (int y = 0; y < this.preview.tiles.length; ++y) {
            for (int x = 0; x < this.preview.tiles[y].length; ++x) {
                short c = this.preview.tiles[y][x];
                if (c == -1) continue;
                this.city.setTile(this.originX + x - this.preview.offsetX, this.originY + y - this.preview.offsetY, (char)c);
                anyFound = true;
            }
        }
        for (ToolPreview.SoundInfo si : this.preview.sounds) {
            this.city.makeSound(si.x, si.y, si.sound);
        }
        if (anyFound && this.preview.cost != 0) {
            this.city.spend(this.preview.cost);
            return ToolResult.SUCCESS;
        }
        return this.preview.toolResult;
    }
}

