/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import micropolisj.engine.CityLocation;
import micropolisj.engine.CityRect;
import micropolisj.engine.Disaster;
import micropolisj.engine.EarthquakeListener;
import micropolisj.engine.MapState;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.MicropolisTool;
import micropolisj.engine.Sound;
import micropolisj.engine.Speed;
import micropolisj.engine.ToolResult;
import micropolisj.engine.ToolStroke;
import micropolisj.engine.ZoneStatus;
import micropolisj.gui.BudgetDialog;
import micropolisj.gui.DemandIndicator;
import micropolisj.gui.EvaluationPane;
import micropolisj.gui.GraphsPane;
import micropolisj.gui.MessagesPane;
import micropolisj.gui.MicropolisDrawingArea;
import micropolisj.gui.NewCityDialog;
import micropolisj.gui.NotificationPane;
import micropolisj.gui.OverlayMapView;
import micropolisj.util.TranslationTool;

public class MainWindow
extends JFrame
implements Micropolis.Listener,
EarthquakeListener {
    Micropolis engine;
    MicropolisDrawingArea drawingArea;
    JScrollPane drawingAreaScroll;
    DemandIndicator demandInd;
    MessagesPane messagesPane;
    JLabel mapLegendLbl;
    OverlayMapView mapView;
    NotificationPane notificationPane;
    EvaluationPane evaluationPane;
    GraphsPane graphsPane;
    JLabel dateLbl;
    JLabel fundsLbl;
    JLabel popLbl;
    JLabel currentToolLbl;
    JLabel currentToolCostLbl;
    Map<MicropolisTool, JToggleButton> toolBtns;
    EnumMap<MapState, JMenuItem> mapStateMenuItems = new EnumMap(MapState.class);
    MicropolisTool currentTool;
    File currentFile;
    boolean doSounds = true;
    boolean dirty1 = false;
    boolean dirty2 = false;
    long lastSavedTime = 0L;
    boolean autoBudgetPending;
    static ImageIcon appIcon = new ImageIcon(MainWindow.class.getResource("/micropolism.png"));
    static ResourceBundle strings = ResourceBundle.getBundle("micropolisj.GuiStrings");
    static final String PRODUCT_NAME = strings.getString("PRODUCT");
    JMenuItem autoBudgetMenuItem;
    JMenuItem autoBulldozeMenuItem;
    JMenuItem disastersMenuItem;
    JMenuItem soundsMenuItem;
    Map<Speed, JMenuItem> priorityMenuItems;
    Map<Integer, JMenuItem> difficultyMenuItems;
    static final String SOUNDS_PREF = "enable_sounds";
    static final String EXTENSION = "cty";
    ToolStroke toolStroke;
    int lastX;
    int lastY;
    Timer simTimer;
    Timer shakeTimer;
    EarthquakeStepper currentEarthquake;

    public MainWindow() {
        this(new Micropolis());
    }

    public MainWindow(Micropolis engine) {
        this.setIconImage(appIcon.getImage());
        this.engine = engine;
        JPanel mainArea = new JPanel(new BorderLayout());
        this.add((Component)mainArea, "Center");
        this.drawingArea = new MicropolisDrawingArea(engine);
        this.drawingAreaScroll = new JScrollPane(this.drawingArea);
        mainArea.add(this.drawingAreaScroll);
        this.makeMenu();
        JToolBar tb = this.makeToolbar();
        mainArea.add((Component)tb, "West");
        Box evalGraphsBox = new Box(1);
        mainArea.add((Component)evalGraphsBox, "South");
        this.graphsPane = new GraphsPane(engine);
        this.graphsPane.setVisible(false);
        evalGraphsBox.add(this.graphsPane);
        this.evaluationPane = new EvaluationPane(engine);
        this.evaluationPane.setVisible(false);
        evalGraphsBox.add((Component)this.evaluationPane, "South");
        JPanel leftPane = new JPanel(new GridBagLayout());
        this.add((Component)leftPane, "West");
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 16;
        c.insets = new Insets(4, 4, 4, 4);
        c.weightx = 1.0;
        this.demandInd = new DemandIndicator();
        leftPane.add((Component)this.demandInd, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 1;
        c.insets = new Insets(4, 20, 4, 4);
        leftPane.add((Component)this.makeDateFunds(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel mapViewContainer = new JPanel(new BorderLayout());
        mapViewContainer.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        leftPane.add((Component)mapViewContainer, c);
        JMenuBar mapMenu = new JMenuBar();
        mapViewContainer.add((Component)mapMenu, "North");
        JMenu zonesMenu = new JMenu(strings.getString("menu.zones"));
        this.setupKeys(zonesMenu, "menu.zones");
        mapMenu.add(zonesMenu);
        zonesMenu.add(this.makeMapStateMenuItem("menu.zones.ALL", MapState.ALL));
        zonesMenu.add(this.makeMapStateMenuItem("menu.zones.RESIDENTIAL", MapState.RESIDENTIAL));
        zonesMenu.add(this.makeMapStateMenuItem("menu.zones.COMMERCIAL", MapState.COMMERCIAL));
        zonesMenu.add(this.makeMapStateMenuItem("menu.zones.INDUSTRIAL", MapState.INDUSTRIAL));
        zonesMenu.add(this.makeMapStateMenuItem("menu.zones.TRANSPORT", MapState.TRANSPORT));
        JMenu overlaysMenu = new JMenu(strings.getString("menu.overlays"));
        this.setupKeys(overlaysMenu, "menu.overlays");
        mapMenu.add(overlaysMenu);
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.POPDEN_OVERLAY", MapState.POPDEN_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.GROWTHRATE_OVERLAY", MapState.GROWTHRATE_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.LANDVALUE_OVERLAY", MapState.LANDVALUE_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.CRIME_OVERLAY", MapState.CRIME_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.POLLUTE_OVERLAY", MapState.POLLUTE_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.TRAFFIC_OVERLAY", MapState.TRAFFIC_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.POWER_OVERLAY", MapState.POWER_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.FIRE_OVERLAY", MapState.FIRE_OVERLAY));
        overlaysMenu.add(this.makeMapStateMenuItem("menu.overlays.POLICE_OVERLAY", MapState.POLICE_OVERLAY));
        mapMenu.add(Box.createHorizontalGlue());
        this.mapLegendLbl = new JLabel();
        mapMenu.add(this.mapLegendLbl);
        this.mapView = new OverlayMapView(engine);
        this.mapView.connectView(this.drawingArea, this.drawingAreaScroll);
        mapViewContainer.add((Component)this.mapView, "Center");
        this.setMapState(MapState.ALL);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.messagesPane = new MessagesPane();
        JScrollPane scroll2 = new JScrollPane(this.messagesPane);
        scroll2.setVerticalScrollBarPolicy(22);
        scroll2.setPreferredSize(new Dimension(0, 0));
        scroll2.setMinimumSize(new Dimension(0, 0));
        leftPane.add((Component)scroll2, c);
        c.gridy = 3;
        c.weighty = 0.0;
        this.notificationPane = new NotificationPane(engine);
        leftPane.add((Component)this.notificationPane, c);
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ADD"), "zoomIn");
        inputMap.put(KeyStroke.getKeyStroke("shift EQUALS"), "zoomIn");
        inputMap.put(KeyStroke.getKeyStroke("SUBTRACT"), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke("MINUS"), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        actionMap.put("zoomIn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.doZoom(1);
            }
        });
        actionMap.put("zoomOut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.doZoom(-1);
            }
        });
        actionMap.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onEscapePressed();
            }
        });
        MouseAdapter mouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                try {
                    MainWindow.this.onToolDown(ev);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                try {
                    MainWindow.this.onToolUp(ev);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                try {
                    MainWindow.this.onToolDrag(ev);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent ev) {
                try {
                    MainWindow.this.onToolHover(ev);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                try {
                    MainWindow.this.onToolExited(ev);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                try {
                    MainWindow.this.onMouseWheelMoved(evt);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }
        };
        this.drawingArea.addMouseListener(mouse);
        this.drawingArea.addMouseMotionListener(mouse);
        this.drawingArea.addMouseWheelListener(mouse);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                MainWindow.this.closeWindow();
            }

            @Override
            public void windowClosed(WindowEvent ev) {
                MainWindow.this.onWindowClosed(ev);
            }
        });
        Preferences prefs = Preferences.userNodeForPackage(MainWindow.class);
        this.doSounds = prefs.getBoolean(SOUNDS_PREF, true);
        this.mapView.setEngine(engine);
        engine.addListener(this);
        engine.addEarthquakeListener(this);
        this.reloadFunds();
        this.reloadOptions();
        this.startTimer();
        this.makeClean();
    }

    public void setEngine(Micropolis newEngine) {
        boolean timerEnabled;
        if (this.engine != null) {
            this.engine.removeListener(this);
            this.engine.removeEarthquakeListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addListener(this);
            this.engine.addEarthquakeListener(this);
        }
        if (timerEnabled = this.isTimerActive()) {
            this.stopTimer();
        }
        this.stopEarthquake();
        this.drawingArea.setEngine(this.engine);
        this.mapView.setEngine(this.engine);
        this.evaluationPane.setEngine(this.engine);
        this.demandInd.setEngine(this.engine);
        this.graphsPane.setEngine(this.engine);
        this.reloadFunds();
        this.reloadOptions();
        this.notificationPane.setVisible(false);
        if (timerEnabled) {
            this.startTimer();
        }
    }

    boolean needsSaved() {
        if (this.dirty1) {
            return true;
        }
        if (!this.dirty2) {
            return false;
        }
        return System.currentTimeMillis() - this.lastSavedTime > 30000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeSaveCity() {
        if (this.needsSaved()) {
            boolean timerEnabled = this.isTimerActive();
            if (timerEnabled) {
                this.stopTimer();
            }
            try {
                int rv = JOptionPane.showConfirmDialog(this, strings.getString("main.save_query"), PRODUCT_NAME, 1, 2);
                if (rv == 2) {
                    boolean bl = false;
                    return bl;
                }
                if (rv == 0 && !this.onSaveCityClicked()) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (timerEnabled) {
                    this.startTimer();
                }
            }
        }
        return true;
    }

    void closeWindow() {
        if (this.maybeSaveCity()) {
            this.dispose();
        }
    }

    JComponent makeDateFunds() {
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c0 = new GridBagConstraints();
        GridBagConstraints c1 = new GridBagConstraints();
        c0.gridx = 0;
        c1.gridx = 1;
        c1.gridy = 0;
        c0.gridy = 0;
        c0.weightx = 1.0;
        c1.weighty = 1.0;
        c0.weighty = 1.0;
        c0.anchor = 17;
        c1.anchor = 13;
        pane.add((Component)new JLabel(strings.getString("main.date_label")), c0);
        this.dateLbl = new JLabel();
        pane.add((Component)this.dateLbl, c1);
        c1.gridy = 1;
        c0.gridy = 1;
        pane.add((Component)new JLabel(strings.getString("main.funds_label")), c0);
        this.fundsLbl = new JLabel();
        pane.add((Component)this.fundsLbl, c1);
        c1.gridy = 2;
        c0.gridy = 2;
        pane.add((Component)new JLabel(strings.getString("main.population_label")), c0);
        this.popLbl = new JLabel();
        pane.add((Component)this.popLbl, c1);
        return pane;
    }

    private void setupKeys(JMenu menu, String prefix) {
        if (strings.containsKey(prefix + ".key")) {
            String mnemonic = strings.getString(prefix + ".key");
            menu.setMnemonic(KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        }
    }

    private void setupKeys(JMenuItem menuItem, String prefix) {
        if (strings.containsKey(prefix + ".key")) {
            String mnemonic = strings.getString(prefix + ".key");
            menuItem.setMnemonic(KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        }
        if (strings.containsKey(prefix + ".shortcut")) {
            String shortcut = strings.getString(prefix + ".shortcut");
            menuItem.setAccelerator(KeyStroke.getKeyStroke(shortcut));
        }
    }

    private void makeMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu gameMenu = new JMenu(strings.getString("menu.game"));
        this.setupKeys(gameMenu, "menu.game");
        menuBar.add(gameMenu);
        JMenuItem menuItem = new JMenuItem(strings.getString("menu.game.new"));
        this.setupKeys(menuItem, "menu.game.new");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onNewCityClicked();
            }
        }));
        gameMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.game.load"));
        this.setupKeys(menuItem, "menu.game.load");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onLoadGameClicked();
            }
        }));
        gameMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.game.save"));
        this.setupKeys(menuItem, "menu.game.save");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onSaveCityClicked();
            }
        }));
        gameMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.game.save_as"));
        this.setupKeys(menuItem, "menu.game.save_as");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onSaveCityAsClicked();
            }
        }));
        gameMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.game.exit"));
        this.setupKeys(menuItem, "menu.game.exit");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.closeWindow();
            }
        }));
        gameMenu.add(menuItem);
        JMenu optionsMenu = new JMenu(strings.getString("menu.options"));
        this.setupKeys(optionsMenu, "menu.options");
        menuBar.add(optionsMenu);
        JMenu levelMenu = new JMenu(strings.getString("menu.difficulty"));
        this.setupKeys(levelMenu, "menu.difficulty");
        optionsMenu.add(levelMenu);
        this.difficultyMenuItems = new HashMap<Integer, JMenuItem>();
        int i = 0;
        while (i <= 2) {
            final int level = i++;
            menuItem = new JRadioButtonMenuItem(strings.getString("menu.difficulty." + level));
            this.setupKeys(menuItem, "menu.difficulty." + level);
            menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.onDifficultyClicked(level);
                }
            }));
            levelMenu.add(menuItem);
            this.difficultyMenuItems.put(level, menuItem);
        }
        this.autoBudgetMenuItem = new JCheckBoxMenuItem(strings.getString("menu.options.auto_budget"));
        this.setupKeys(this.autoBudgetMenuItem, "menu.options.auto_budget");
        this.autoBudgetMenuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onAutoBudgetClicked();
            }
        }));
        optionsMenu.add(this.autoBudgetMenuItem);
        this.autoBulldozeMenuItem = new JCheckBoxMenuItem(strings.getString("menu.options.auto_bulldoze"));
        this.setupKeys(this.autoBulldozeMenuItem, "menu.options.auto_bulldoze");
        this.autoBulldozeMenuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onAutoBulldozeClicked();
            }
        }));
        optionsMenu.add(this.autoBulldozeMenuItem);
        this.disastersMenuItem = new JCheckBoxMenuItem(strings.getString("menu.options.disasters"));
        this.setupKeys(this.disastersMenuItem, "menu.options.disasters");
        this.disastersMenuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onDisastersClicked();
            }
        }));
        optionsMenu.add(this.disastersMenuItem);
        this.soundsMenuItem = new JCheckBoxMenuItem(strings.getString("menu.options.sound"));
        this.setupKeys(this.soundsMenuItem, "menu.options.sound");
        this.soundsMenuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onSoundClicked();
            }
        }));
        optionsMenu.add(this.soundsMenuItem);
        menuItem = new JMenuItem(strings.getString("menu.options.zoom_in"));
        this.setupKeys(menuItem, "menu.options.zoom_in");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.doZoom(1);
            }
        }));
        optionsMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.options.zoom_out"));
        this.setupKeys(menuItem, "menu.options.zoom_out");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.doZoom(-1);
            }
        }));
        optionsMenu.add(menuItem);
        JMenu disastersMenu = new JMenu(strings.getString("menu.disasters"));
        this.setupKeys(disastersMenu, "menu.disasters");
        menuBar.add(disastersMenu);
        menuItem = new JMenuItem(strings.getString("menu.disasters.MONSTER"));
        this.setupKeys(menuItem, "menu.disasters.MONSTER");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.MONSTER);
            }
        }));
        disastersMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.disasters.FIRE"));
        this.setupKeys(menuItem, "menu.disasters.FIRE");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.FIRE);
            }
        }));
        disastersMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.disasters.FLOOD"));
        this.setupKeys(menuItem, "menu.disasters.FLOOD");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.FLOOD);
            }
        }));
        disastersMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.disasters.MELTDOWN"));
        this.setupKeys(menuItem, "menu.disasters.MELTDOWN");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.MELTDOWN);
            }
        }));
        disastersMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.disasters.TORNADO"));
        this.setupKeys(menuItem, "menu.disasters.TORNADO");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.TORNADO);
            }
        }));
        disastersMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.disasters.EARTHQUAKE"));
        this.setupKeys(menuItem, "menu.disasters.EARTHQUAKE");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onInvokeDisasterClicked(Disaster.EARTHQUAKE);
            }
        }));
        disastersMenu.add(menuItem);
        JMenu priorityMenu = new JMenu(strings.getString("menu.speed"));
        this.setupKeys(priorityMenu, "menu.speed");
        menuBar.add(priorityMenu);
        this.priorityMenuItems = new EnumMap<Speed, JMenuItem>(Speed.class);
        menuItem = new JRadioButtonMenuItem(strings.getString("menu.speed.SUPER_FAST"));
        this.setupKeys(menuItem, "menu.speed.SUPER_FAST");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onPriorityClicked(Speed.SUPER_FAST);
            }
        }));
        priorityMenu.add(menuItem);
        this.priorityMenuItems.put(Speed.SUPER_FAST, menuItem);
        menuItem = new JRadioButtonMenuItem(strings.getString("menu.speed.FAST"));
        this.setupKeys(menuItem, "menu.speed.FAST");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onPriorityClicked(Speed.FAST);
            }
        }));
        priorityMenu.add(menuItem);
        this.priorityMenuItems.put(Speed.FAST, menuItem);
        menuItem = new JRadioButtonMenuItem(strings.getString("menu.speed.NORMAL"));
        this.setupKeys(menuItem, "menu.speed.NORMAL");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onPriorityClicked(Speed.NORMAL);
            }
        }));
        priorityMenu.add(menuItem);
        this.priorityMenuItems.put(Speed.NORMAL, menuItem);
        menuItem = new JRadioButtonMenuItem(strings.getString("menu.speed.SLOW"));
        this.setupKeys(menuItem, "menu.speed.SLOW");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onPriorityClicked(Speed.SLOW);
            }
        }));
        priorityMenu.add(menuItem);
        this.priorityMenuItems.put(Speed.SLOW, menuItem);
        menuItem = new JRadioButtonMenuItem(strings.getString("menu.speed.PAUSED"));
        this.setupKeys(menuItem, "menu.speed.PAUSED");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onPriorityClicked(Speed.PAUSED);
            }
        }));
        priorityMenu.add(menuItem);
        this.priorityMenuItems.put(Speed.PAUSED, menuItem);
        JMenu windowsMenu = new JMenu(strings.getString("menu.windows"));
        this.setupKeys(windowsMenu, "menu.windows");
        menuBar.add(windowsMenu);
        menuItem = new JMenuItem(strings.getString("menu.windows.budget"));
        this.setupKeys(menuItem, "menu.windows.budget");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onViewBudgetClicked();
            }
        }));
        windowsMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.windows.evaluation"));
        this.setupKeys(menuItem, "menu.windows.evaluation");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onViewEvaluationClicked();
            }
        }));
        windowsMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.windows.graph"));
        this.setupKeys(menuItem, "menu.windows.graph");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onViewGraphClicked();
            }
        }));
        windowsMenu.add(menuItem);
        JMenu helpMenu = new JMenu(strings.getString("menu.help"));
        this.setupKeys(helpMenu, "menu.help");
        menuBar.add(helpMenu);
        menuItem = new JMenuItem(strings.getString("menu.help.launch-translation-tool"));
        this.setupKeys(menuItem, "menu.help.launch-translation-tool");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onLaunchTranslationToolClicked();
            }
        });
        helpMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("menu.help.about"));
        this.setupKeys(menuItem, "menu.help.about");
        menuItem.addActionListener(this.wrapActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.onAboutClicked();
            }
        }));
        helpMenu.add(menuItem);
        this.setJMenuBar(menuBar);
    }

    private Micropolis getEngine() {
        return this.engine;
    }

    private void onAutoBudgetClicked() {
        this.dirty1 = true;
        this.getEngine().toggleAutoBudget();
    }

    private void onAutoBulldozeClicked() {
        this.dirty1 = true;
        this.getEngine().toggleAutoBulldoze();
    }

    private void onDisastersClicked() {
        this.dirty1 = true;
        this.getEngine().toggleDisasters();
    }

    private void onSoundClicked() {
        this.doSounds = !this.doSounds;
        Preferences prefs = Preferences.userNodeForPackage(MainWindow.class);
        prefs.putBoolean(SOUNDS_PREF, this.doSounds);
        this.reloadOptions();
    }

    void makeClean() {
        this.dirty1 = false;
        this.dirty2 = false;
        this.lastSavedTime = System.currentTimeMillis();
        if (this.currentFile != null) {
            String fileName = this.currentFile.getName();
            if (fileName.endsWith(".cty")) {
                fileName = fileName.substring(0, fileName.length() - 1 - EXTENSION.length());
            }
            this.setTitle(MessageFormat.format(strings.getString("main.caption_named_city"), fileName));
        } else {
            this.setTitle(strings.getString("main.caption_unnamed_city"));
        }
    }

    private boolean onSaveCityClicked() {
        if (this.currentFile == null) {
            return this.onSaveCityAsClicked();
        }
        try {
            this.getEngine().save(this.currentFile);
            this.makeClean();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, e, strings.getString("main.error_caption"), 0);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onSaveCityAsClicked() {
        boolean timerEnabled = this.isTimerActive();
        if (timerEnabled) {
            this.stopTimer();
        }
        try {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter(strings.getString("cty_file"), EXTENSION);
            fc.setFileFilter(filter1);
            int rv = fc.showSaveDialog(this);
            if (rv == 0) {
                this.currentFile = fc.getSelectedFile();
                if (!this.currentFile.getName().endsWith(".cty")) {
                    this.currentFile = new File(this.currentFile.getPath() + "." + EXTENSION);
                }
                this.getEngine().save(this.currentFile);
                this.makeClean();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, e, strings.getString("main.error_caption"), 0);
        }
        finally {
            if (timerEnabled) {
                this.startTimer();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadGameClicked() {
        if (!this.maybeSaveCity()) {
            return;
        }
        boolean timerEnabled = this.isTimerActive();
        if (timerEnabled) {
            this.stopTimer();
        }
        try {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter(strings.getString("cty_file"), EXTENSION);
            fc.setFileFilter(filter1);
            assert (!this.isTimerActive());
            int rv = fc.showOpenDialog(this);
            if (rv == 0) {
                File file = fc.getSelectedFile();
                Micropolis newEngine = new Micropolis();
                newEngine.load(file);
                this.setEngine(newEngine);
                this.currentFile = file;
                this.makeClean();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, e, strings.getString("main.error_caption"), 0);
        }
        finally {
            if (timerEnabled) {
                this.startTimer();
            }
        }
    }

    private JToggleButton makeToolBtn(final MicropolisTool tool) {
        String iconName = strings.containsKey("tool." + tool.name() + ".icon") ? strings.getString("tool." + tool.name() + ".icon") : "/graphics/tools/" + tool.name().toLowerCase() + ".png";
        String iconSelectedName = strings.containsKey("tool." + tool.name() + ".selected_icon") ? strings.getString("tool." + tool.name() + ".selected_icon") : iconName;
        String tipText = strings.containsKey("tool." + tool.name() + ".tip") ? strings.getString("tool." + tool.name() + ".tip") : tool.name();
        JToggleButton btn = new JToggleButton();
        btn.setIcon(new ImageIcon(MainWindow.class.getResource(iconName)));
        btn.setSelectedIcon(new ImageIcon(MainWindow.class.getResource(iconSelectedName)));
        btn.setToolTipText(tipText);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setBorderPainted(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainWindow.this.selectTool(tool);
            }
        });
        this.toolBtns.put(tool, btn);
        return btn;
    }

    private JToolBar makeToolbar() {
        this.toolBtns = new EnumMap<MicropolisTool, JToggleButton>(MicropolisTool.class);
        JToolBar toolBar = new JToolBar(strings.getString("main.tools_caption"), 1);
        toolBar.setFloatable(false);
        toolBar.setRollover(false);
        JPanel gridBox = new JPanel(new GridBagLayout());
        toolBar.add(gridBox);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 11;
        c.insets = new Insets(8, 0, 0, 0);
        this.currentToolLbl = new JLabel(" ");
        gridBox.add((Component)this.currentToolLbl, c);
        c.gridy = 1;
        c.insets = new Insets(0, 0, 12, 0);
        this.currentToolCostLbl = new JLabel(" ");
        gridBox.add((Component)this.currentToolCostLbl, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        Box b0 = new Box(0);
        gridBox.add((Component)b0, c);
        b0.add(this.makeToolBtn(MicropolisTool.BULLDOZER));
        b0.add(this.makeToolBtn(MicropolisTool.WIRE));
        b0.add(this.makeToolBtn(MicropolisTool.PARK));
        ++c.gridy;
        Box b1 = new Box(0);
        gridBox.add((Component)b1, c);
        b1.add(this.makeToolBtn(MicropolisTool.ROADS));
        b1.add(this.makeToolBtn(MicropolisTool.RAIL));
        ++c.gridy;
        Box b2 = new Box(0);
        gridBox.add((Component)b2, c);
        b2.add(this.makeToolBtn(MicropolisTool.RESIDENTIAL));
        b2.add(this.makeToolBtn(MicropolisTool.COMMERCIAL));
        b2.add(this.makeToolBtn(MicropolisTool.INDUSTRIAL));
        ++c.gridy;
        Box b3 = new Box(0);
        gridBox.add((Component)b3, c);
        b3.add(this.makeToolBtn(MicropolisTool.FIRE));
        b3.add(this.makeToolBtn(MicropolisTool.QUERY));
        b3.add(this.makeToolBtn(MicropolisTool.POLICE));
        ++c.gridy;
        Box b4 = new Box(0);
        gridBox.add((Component)b4, c);
        b4.add(this.makeToolBtn(MicropolisTool.POWERPLANT));
        b4.add(this.makeToolBtn(MicropolisTool.NUCLEAR));
        ++c.gridy;
        Box b5 = new Box(0);
        gridBox.add((Component)b5, c);
        b5.add(this.makeToolBtn(MicropolisTool.STADIUM));
        b5.add(this.makeToolBtn(MicropolisTool.SEAPORT));
        ++c.gridy;
        Box b6 = new Box(0);
        gridBox.add((Component)b6, c);
        b6.add(this.makeToolBtn(MicropolisTool.AIRPORT));
        ++c.gridy;
        c.weighty = 1.0;
        gridBox.add((Component)new JLabel(), c);
        return toolBar;
    }

    private void selectTool(MicropolisTool newTool) {
        this.toolBtns.get((Object)newTool).setSelected(true);
        if (newTool == this.currentTool) {
            return;
        }
        if (this.currentTool != null) {
            this.toolBtns.get((Object)this.currentTool).setSelected(false);
        }
        this.currentTool = newTool;
        this.currentToolLbl.setText(strings.containsKey("tool." + this.currentTool.name() + ".name") ? strings.getString("tool." + this.currentTool.name() + ".name") : this.currentTool.name());
        int cost = this.currentTool.getToolCost();
        this.currentToolCostLbl.setText(cost != 0 ? MainWindow.formatFunds(cost) : " ");
    }

    private void onNewCityClicked() {
        if (this.maybeSaveCity()) {
            this.doNewCity(false);
        }
    }

    public void doNewCity(boolean firstTime) {
        boolean timerEnabled = this.isTimerActive();
        if (timerEnabled) {
            this.stopTimer();
        }
        new NewCityDialog(this, !firstTime).setVisible(true);
        if (timerEnabled) {
            this.startTimer();
        }
    }

    void doQueryTool(int xpos, int ypos) {
        if (!this.engine.testBounds(xpos, ypos)) {
            return;
        }
        ZoneStatus z = this.engine.queryZoneStatus(xpos, ypos);
        this.notificationPane.showZoneStatus(this.engine, xpos, ypos, z);
    }

    private void doZoom(int dir, Point mousePt) {
        int newZoom;
        int oldZoom = this.drawingArea.getTileSize();
        int n = newZoom = dir < 0 ? oldZoom / 2 : oldZoom * 2;
        if (newZoom < 8) {
            newZoom = 8;
        }
        if (newZoom > 32) {
            newZoom = 32;
        }
        if (oldZoom != newZoom) {
            double f = (double)newZoom / (double)oldZoom;
            Point pos = this.drawingAreaScroll.getViewport().getViewPosition();
            int newX = (int)Math.round((double)mousePt.x * f - (double)(mousePt.x - pos.x));
            int newY = (int)Math.round((double)mousePt.y * f - (double)(mousePt.y - pos.y));
            this.drawingArea.selectTileSize(newZoom);
            this.drawingAreaScroll.validate();
            this.drawingAreaScroll.getViewport().setViewPosition(new Point(newX, newY));
        }
    }

    private void doZoom(int dir) {
        Rectangle rect = this.drawingAreaScroll.getViewport().getViewRect();
        this.doZoom(dir, new Point(rect.x + rect.width / 2, rect.y + rect.height / 2));
    }

    private void onMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            this.doZoom(1, evt.getPoint());
        } else {
            this.doZoom(-1, evt.getPoint());
        }
    }

    private void onToolDown(MouseEvent ev) {
        if (ev.getButton() == 3) {
            CityLocation loc = this.drawingArea.getCityLocation(ev.getX(), ev.getY());
            this.doQueryTool(loc.x, loc.y);
            return;
        }
        if (ev.getButton() != 1) {
            return;
        }
        if (this.currentTool == null) {
            return;
        }
        CityLocation loc = this.drawingArea.getCityLocation(ev.getX(), ev.getY());
        int x = loc.x;
        int y = loc.y;
        if (this.currentTool == MicropolisTool.QUERY) {
            this.doQueryTool(x, y);
            this.toolStroke = null;
        } else {
            this.toolStroke = this.currentTool.beginStroke(this.engine, x, y);
            this.previewTool();
        }
        this.lastX = x;
        this.lastY = y;
    }

    private void onEscapePressed() {
        if (this.toolStroke != null) {
            this.toolStroke = null;
            this.drawingArea.setToolPreview(null);
            this.drawingArea.setToolCursor(null);
        } else {
            this.notificationPane.setVisible(false);
        }
    }

    private void onToolUp(MouseEvent ev) {
        if (this.toolStroke != null) {
            this.drawingArea.setToolPreview(null);
            CityLocation loc = this.toolStroke.getLocation();
            ToolResult tr = this.toolStroke.apply();
            this.showToolResult(loc, tr);
            this.toolStroke = null;
        }
        this.onToolHover(ev);
        if (this.autoBudgetPending) {
            this.autoBudgetPending = false;
            this.showBudgetWindow(true);
        }
    }

    void previewTool() {
        assert (this.toolStroke != null);
        assert (this.currentTool != null);
        this.drawingArea.setToolCursor(this.toolStroke.getBounds(), this.currentTool);
        this.drawingArea.setToolPreview(this.toolStroke.getPreview());
    }

    private void onToolDrag(MouseEvent ev) {
        if (this.currentTool == null) {
            return;
        }
        if ((ev.getModifiersEx() & 0x400) == 0) {
            return;
        }
        CityLocation loc = this.drawingArea.getCityLocation(ev.getX(), ev.getY());
        int x = loc.x;
        int y = loc.y;
        if (x == this.lastX && y == this.lastY) {
            return;
        }
        if (this.toolStroke != null) {
            this.toolStroke.dragTo(x, y);
            this.previewTool();
        } else if (this.currentTool == MicropolisTool.QUERY) {
            this.doQueryTool(x, y);
        }
        this.lastX = x;
        this.lastY = y;
    }

    private void onToolHover(MouseEvent ev) {
        if (this.currentTool == null || this.currentTool == MicropolisTool.QUERY) {
            this.drawingArea.setToolCursor(null);
            return;
        }
        CityLocation loc = this.drawingArea.getCityLocation(ev.getX(), ev.getY());
        int x = loc.x;
        int y = loc.y;
        int w = this.currentTool.getWidth();
        int h = this.currentTool.getHeight();
        if (w >= 3) {
            --x;
        }
        if (h >= 3) {
            --y;
        }
        this.drawingArea.setToolCursor(new CityRect(x, y, w, h), this.currentTool);
    }

    private void onToolExited(MouseEvent ev) {
        this.drawingArea.setToolCursor(null);
    }

    private void showToolResult(CityLocation loc, ToolResult result) {
        switch (result) {
            case SUCCESS: {
                this.citySound(this.currentTool == MicropolisTool.BULLDOZER ? Sound.BULLDOZE : Sound.BUILD, loc);
                this.dirty1 = true;
                break;
            }
            case NONE: {
                break;
            }
            case UH_OH: {
                this.messagesPane.appendCityMessage(MicropolisMessage.BULLDOZE_FIRST);
                this.citySound(Sound.UHUH, loc);
                break;
            }
            case INSUFFICIENT_FUNDS: {
                this.messagesPane.appendCityMessage(MicropolisMessage.INSUFFICIENT_FUNDS);
                this.citySound(Sound.SORRY, loc);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static String formatFunds(int funds) {
        return MessageFormat.format(strings.getString("funds"), funds);
    }

    public static String formatGameDate(int cityTime) {
        Calendar c = Calendar.getInstance();
        c.set(1900 + cityTime / 48, cityTime % 48 / 4, cityTime % 4 * 7 + 1);
        return MessageFormat.format(strings.getString("citytime"), c.getTime());
    }

    private void updateDateLabel() {
        this.dateLbl.setText(MainWindow.formatGameDate(this.engine.cityTime));
        NumberFormat nf = NumberFormat.getInstance();
        this.popLbl.setText(nf.format(this.getEngine().getCityPopulation()));
    }

    private void startTimer() {
        final Micropolis engine = this.getEngine();
        final int count = engine.simSpeed.simStepsPerUpdate;
        assert (!this.isTimerActive());
        if (engine.simSpeed == Speed.PAUSED) {
            return;
        }
        if (this.currentEarthquake != null) {
            int interval = 75;
            this.shakeTimer = new Timer(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.currentEarthquake.oneStep();
                    if (MainWindow.this.currentEarthquake.count == 0) {
                        MainWindow.this.stopTimer();
                        MainWindow.this.currentEarthquake = null;
                        MainWindow.this.startTimer();
                    }
                }
            });
            this.shakeTimer.start();
            return;
        }
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < count; ++i) {
                    engine.animate();
                    if (engine.autoBudget || !engine.isBudgetTime()) continue;
                    MainWindow.this.showAutoBudget();
                    return;
                }
                MainWindow.this.updateDateLabel();
                MainWindow.this.dirty2 = true;
            }
        };
        taskPerformer = this.wrapActionListener(taskPerformer);
        assert (this.simTimer == null);
        this.simTimer = new Timer(engine.simSpeed.animationDelay, taskPerformer);
        this.simTimer.start();
    }

    ActionListener wrapActionListener(final ActionListener l) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    l.actionPerformed(evt);
                }
                catch (Throwable e) {
                    MainWindow.this.showErrorMessage(e);
                }
            }
        };
    }

    private void showErrorMessage(Throwable e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        JTextPane stackTracePane = new JTextPane();
        stackTracePane.setEditable(false);
        stackTracePane.setText(w.toString());
        JScrollPane detailsPane = new JScrollPane(stackTracePane);
        detailsPane.setVerticalScrollBarPolicy(22);
        detailsPane.setPreferredSize(new Dimension(480, 240));
        detailsPane.setMinimumSize(new Dimension(0, 0));
        int rv = JOptionPane.showOptionDialog(this, e, strings.getString("main.error_unexpected"), -1, 0, null, new String[]{strings.getString("main.error_show_stacktrace"), strings.getString("main.error_close"), strings.getString("main.error_shutdown")}, 1);
        if (rv == 0) {
            JOptionPane.showMessageDialog(this, detailsPane, strings.getString("main.error_unexpected"), 0);
        }
        if (rv == 2 && (rv = JOptionPane.showConfirmDialog(this, strings.getString("error.shutdown_query"), strings.getString("main.error_unexpected"), 2, 2)) == 0) {
            System.exit(1);
        }
    }

    @Override
    public void earthquakeStarted() {
        if (this.isTimerActive()) {
            this.stopTimer();
        }
        this.currentEarthquake = new EarthquakeStepper();
        this.currentEarthquake.oneStep();
        this.startTimer();
    }

    void stopEarthquake() {
        this.drawingArea.shake(0);
        this.currentEarthquake = null;
    }

    private void stopTimer() {
        assert (this.isTimerActive());
        if (this.simTimer != null) {
            this.simTimer.stop();
            this.simTimer = null;
        }
        if (this.shakeTimer != null) {
            this.shakeTimer.stop();
            this.shakeTimer = null;
        }
    }

    boolean isTimerActive() {
        return this.simTimer != null || this.shakeTimer != null;
    }

    private void onWindowClosed(WindowEvent ev) {
        if (this.isTimerActive()) {
            this.stopTimer();
        }
    }

    private void onDifficultyClicked(int newDifficulty) {
        this.getEngine().setGameLevel(newDifficulty);
    }

    private void onPriorityClicked(Speed newSpeed) {
        if (this.isTimerActive()) {
            this.stopTimer();
        }
        this.getEngine().setSpeed(newSpeed);
        this.startTimer();
    }

    private void onInvokeDisasterClicked(Disaster disaster) {
        this.dirty1 = true;
        switch (disaster) {
            case FIRE: {
                this.getEngine().makeFire();
                break;
            }
            case FLOOD: {
                this.getEngine().makeFlood();
                break;
            }
            case MONSTER: {
                this.getEngine().makeMonster();
                break;
            }
            case MELTDOWN: {
                if (this.getEngine().makeMeltdown()) break;
                this.messagesPane.appendCityMessage(MicropolisMessage.NO_NUCLEAR_PLANTS);
                break;
            }
            case TORNADO: {
                this.getEngine().makeTornado();
                break;
            }
            case EARTHQUAKE: {
                this.getEngine().makeEarthquake();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void reloadFunds() {
        this.fundsLbl.setText(MainWindow.formatFunds(this.getEngine().budget.totalFunds));
    }

    @Override
    public void cityMessage(MicropolisMessage m, CityLocation p) {
        this.messagesPane.appendCityMessage(m);
        if (m.useNotificationPane && p != null) {
            this.notificationPane.showMessage(this.engine, m, p.x, p.y);
        }
    }

    @Override
    public void fundsChanged() {
        this.reloadFunds();
    }

    @Override
    public void optionsChanged() {
        this.reloadOptions();
    }

    private void reloadOptions() {
        this.autoBudgetMenuItem.setSelected(this.getEngine().autoBudget);
        this.autoBulldozeMenuItem.setSelected(this.getEngine().autoBulldoze);
        this.disastersMenuItem.setSelected(!this.getEngine().noDisasters);
        this.soundsMenuItem.setSelected(this.doSounds);
        for (Speed spd : this.priorityMenuItems.keySet()) {
            this.priorityMenuItems.get((Object)spd).setSelected(this.getEngine().simSpeed == spd);
        }
        for (int i = 0; i <= 2; ++i) {
            this.difficultyMenuItems.get(i).setSelected(this.getEngine().gameLevel == i);
        }
    }

    @Override
    public void citySound(Sound sound, CityLocation loc) {
        if (!this.doSounds) {
            return;
        }
        URL afile = sound.getAudioFile();
        if (afile == null) {
            return;
        }
        boolean isOnScreen = this.drawingAreaScroll.getViewport().getViewRect().contains(this.drawingArea.getTileBounds(loc.x, loc.y));
        if (sound == Sound.HONKHONK_LOW && !isOnScreen) {
            return;
        }
        try {
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(afile));
            clip.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void censusChanged() {
    }

    @Override
    public void demandChanged() {
    }

    @Override
    public void evaluationChanged() {
    }

    void onViewBudgetClicked() {
        this.dirty1 = true;
        this.showBudgetWindow(false);
    }

    void onViewEvaluationClicked() {
        this.evaluationPane.setVisible(true);
    }

    void onViewGraphClicked() {
        this.graphsPane.setVisible(true);
    }

    private void showAutoBudget() {
        if (this.toolStroke == null) {
            this.showBudgetWindow(true);
        } else {
            this.autoBudgetPending = true;
        }
    }

    private void showBudgetWindow(boolean isEndOfYear) {
        boolean timerEnabled = this.isTimerActive();
        if (timerEnabled) {
            this.stopTimer();
        }
        BudgetDialog dlg = new BudgetDialog((Window)this, this.getEngine());
        dlg.setModal(true);
        dlg.setVisible(true);
        if (timerEnabled) {
            this.startTimer();
        }
    }

    private JMenuItem makeMapStateMenuItem(String stringPrefix, final MapState state) {
        String caption = strings.getString(stringPrefix);
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(caption);
        this.setupKeys(menuItem, stringPrefix);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.setMapState(state);
            }
        });
        this.mapStateMenuItems.put(state, menuItem);
        return menuItem;
    }

    private void setMapState(MapState state) {
        this.mapStateMenuItems.get((Object)this.mapView.getMapState()).setSelected(false);
        this.mapStateMenuItems.get((Object)state).setSelected(true);
        this.mapView.setMapState(state);
        this.setMapLegend(state);
    }

    private void setMapLegend(MapState state) {
        String k = "legend_image." + state.name();
        URL iconUrl = null;
        if (strings.containsKey(k)) {
            String iconName = strings.getString(k);
            iconUrl = MainWindow.class.getResource(iconName);
        }
        if (iconUrl != null) {
            this.mapLegendLbl.setIcon(new ImageIcon(iconUrl));
        } else {
            this.mapLegendLbl.setIcon(null);
        }
    }

    private void onLaunchTranslationToolClicked() {
        if (this.maybeSaveCity()) {
            this.dispose();
            TranslationTool tt = new TranslationTool();
            tt.setVisible(true);
        }
    }

    private void onAboutClicked() {
        String version = this.getClass().getPackage().getImplementationVersion();
        String versionStr = MessageFormat.format(strings.getString("main.version_string"), version);
        versionStr = versionStr.replace("%java.version%", System.getProperty("java.version"));
        versionStr = versionStr.replace("%java.vendor%", System.getProperty("java.vendor"));
        JLabel appNameLbl = new JLabel(versionStr);
        JLabel appDetailsLbl = new JLabel(strings.getString("main.about_text"));
        JComponent[] inputs = new JComponent[]{appNameLbl, appDetailsLbl};
        JOptionPane.showMessageDialog(this, inputs, strings.getString("main.about_caption"), -1, appIcon);
    }

    class EarthquakeStepper {
        int count = 0;

        EarthquakeStepper() {
        }

        void oneStep() {
            this.count = (this.count + 1) % 40;
            MainWindow.this.drawingArea.shake(this.count);
        }
    }
}

