/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import micropolisj.engine.CityLocation;
import micropolisj.engine.CityRect;
import micropolisj.engine.MapListener;
import micropolisj.engine.MapState;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisTool;
import micropolisj.engine.Sprite;
import micropolisj.engine.TileConstants;
import micropolisj.engine.ToolPreview;
import micropolisj.gui.ColorParser;
import micropolisj.gui.MainWindow;
import micropolisj.gui.TileImages;

public class MicropolisDrawingArea
extends JComponent
implements Scrollable,
MapListener {
    Micropolis m;
    boolean blinkUnpoweredZones = true;
    HashSet<Point> unpoweredZones = new HashSet();
    boolean blink;
    Timer blinkTimer;
    ToolCursor toolCursor;
    ToolPreview toolPreview;
    int shakeStep;
    static final Dimension PREFERRED_VIEWPORT_SIZE = new Dimension(640, 640);
    static final ResourceBundle strings = MainWindow.strings;
    static final int DEFAULT_TILE_SIZE = 16;
    TileImages tileImages;
    int TILE_WIDTH;
    int TILE_HEIGHT;
    int dragX;
    int dragY;
    boolean dragging;
    static final int SHAKE_STEPS = 40;

    public MicropolisDrawingArea(Micropolis engine) {
        this.m = engine;
        this.selectTileSize(16);
        this.m.addMapListener(this);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                MicropolisDrawingArea.this.startBlinkTimer();
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
                MicropolisDrawingArea.this.stopBlinkTimer();
            }

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 2) {
                    MicropolisDrawingArea.this.startDrag(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2) {
                    MicropolisDrawingArea.this.endDrag(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MicropolisDrawingArea.this.dragging) {
                    MicropolisDrawingArea.this.continueDrag(e.getX(), e.getY());
                }
            }
        });
    }

    public void selectTileSize(int newTileSize) {
        this.tileImages = TileImages.getInstance(newTileSize);
        this.TILE_WIDTH = this.tileImages.TILE_WIDTH;
        this.TILE_HEIGHT = this.tileImages.TILE_HEIGHT;
        this.revalidate();
    }

    public int getTileSize() {
        return this.TILE_WIDTH;
    }

    public CityLocation getCityLocation(int x, int y) {
        return new CityLocation(x / this.TILE_WIDTH, y / this.TILE_HEIGHT);
    }

    @Override
    public Dimension getPreferredSize() {
        assert (this.m != null);
        return new Dimension(this.TILE_WIDTH * this.m.getWidth(), this.TILE_HEIGHT * this.m.getHeight());
    }

    public void setEngine(Micropolis newEngine) {
        assert (newEngine != null);
        if (this.m != null) {
            this.m.removeMapListener(this);
        }
        this.m = newEngine;
        if (this.m != null) {
            this.m.addMapListener(this);
        }
        this.invalidate();
        this.repaint();
    }

    void drawSprite(Graphics gr, Sprite sprite) {
        assert (sprite.isVisible());
        Point p = new Point((sprite.x + sprite.offx) * this.TILE_WIDTH / 16, (sprite.y + sprite.offy) * this.TILE_HEIGHT / 16);
        Image img = this.tileImages.getSpriteImage(sprite.kind, sprite.frame - 1);
        if (img != null) {
            gr.drawImage(img, p.x, p.y, null);
        } else {
            gr.setColor(Color.RED);
            gr.fillRect(p.x, p.y, 16, 16);
            gr.setColor(Color.WHITE);
            gr.drawString(Integer.toString(sprite.frame - 1), p.x, p.y);
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        int width = this.m.getWidth();
        int height = this.m.getHeight();
        Rectangle clipRect = gr.getClipBounds();
        int minX = Math.max(0, clipRect.x / this.TILE_WIDTH);
        int minY = Math.max(0, clipRect.y / this.TILE_HEIGHT);
        int maxX = Math.min(width, 1 + (clipRect.x + clipRect.width - 1) / this.TILE_WIDTH);
        int maxY = Math.min(height, 1 + (clipRect.y + clipRect.height - 1) / this.TILE_HEIGHT);
        for (int y = minY; y < maxY; ++y) {
            for (int x = maxX - 1; x >= minX; --x) {
                int c;
                int cell = this.m.getTile(x, y);
                if (this.blinkUnpoweredZones && TileConstants.isZoneCenter(cell) && !this.m.isTilePowered(x, y)) {
                    this.unpoweredZones.add(new Point(x, y));
                    if (this.blink) {
                        cell = 827;
                    }
                }
                if (this.toolPreview != null && (c = this.toolPreview.getTile(x, y)) != -1) {
                    cell = c;
                }
                gr.drawImage(this.tileImages.getTileImage(cell), x * this.TILE_WIDTH + (this.shakeStep != 0 ? this.getShakeModifier(y) : 0), y * this.TILE_HEIGHT, null);
            }
        }
        for (Sprite sprite : this.m.allSprites()) {
            if (!sprite.isVisible()) continue;
            this.drawSprite(gr, sprite);
        }
        if (this.toolCursor != null) {
            int x0 = this.toolCursor.rect.x * this.TILE_WIDTH;
            int x1 = (this.toolCursor.rect.x + this.toolCursor.rect.width) * this.TILE_WIDTH;
            int y0 = this.toolCursor.rect.y * this.TILE_HEIGHT;
            int y1 = (this.toolCursor.rect.y + this.toolCursor.rect.height) * this.TILE_HEIGHT;
            gr.setColor(Color.BLACK);
            gr.fillRect(x0 - 1, y0 - 1, x1 - (x0 - 1), 1);
            gr.fillRect(x0 - 1, y0, 1, y1 - y0);
            gr.fillRect(x0 - 3, y1 + 3, x1 + 4 - (x0 - 3), 1);
            gr.fillRect(x1 + 3, y0 - 3, 1, y1 + 3 - (y0 - 3));
            gr.setColor(Color.WHITE);
            gr.fillRect(x0 - 4, y0 - 4, x1 + 4 - (x0 - 4), 1);
            gr.fillRect(x0 - 4, y0 - 3, 1, y1 + 4 - (y0 - 3));
            gr.fillRect(x0 - 1, y1, x1 + 1 - (x0 - 1), 1);
            gr.fillRect(x1, y0 - 1, 1, y1 - (y0 - 1));
            gr.setColor(this.toolCursor.borderColor);
            gr.fillRect(x0 - 3, y0 - 3, x1 + 1 - (x0 - 3), 2);
            gr.fillRect(x1 + 1, y0 - 3, 2, y1 + 1 - (y0 - 3));
            gr.fillRect(x0 - 1, y1 + 1, x1 + 3 - (x0 - 1), 2);
            gr.fillRect(x0 - 3, y0 - 1, 2, y1 + 3 - (y0 - 1));
            if (this.toolCursor.fillColor != null) {
                gr.setColor(this.toolCursor.fillColor);
                gr.fillRect(x0, y0, x1 - x0, y1 - y0);
            }
        }
    }

    public void setToolCursor(CityRect newRect, MicropolisTool tool) {
        ToolCursor tp = new ToolCursor();
        tp.rect = newRect;
        tp.borderColor = ColorParser.parseColor(strings.containsKey("tool." + tool.name() + ".border") ? strings.getString("tool." + tool.name() + ".border") : strings.getString("tool.*.border"));
        tp.fillColor = ColorParser.parseColor(strings.containsKey("tool." + tool.name() + ".bgcolor") ? strings.getString("tool." + tool.name() + ".bgcolor") : strings.getString("tool.*.bgcolor"));
        this.setToolCursor(tp);
    }

    public void setToolCursor(ToolCursor newCursor) {
        if (this.toolCursor == newCursor) {
            return;
        }
        if (this.toolCursor != null && this.toolCursor.equals(newCursor)) {
            return;
        }
        if (this.toolCursor != null) {
            this.repaint(new Rectangle(this.toolCursor.rect.x * this.TILE_WIDTH - 4, this.toolCursor.rect.y * this.TILE_HEIGHT - 4, this.toolCursor.rect.width * this.TILE_WIDTH + 8, this.toolCursor.rect.height * this.TILE_HEIGHT + 8));
        }
        this.toolCursor = newCursor;
        if (this.toolCursor != null) {
            this.repaint(new Rectangle(this.toolCursor.rect.x * this.TILE_WIDTH - 4, this.toolCursor.rect.y * this.TILE_HEIGHT - 4, this.toolCursor.rect.width * this.TILE_WIDTH + 8, this.toolCursor.rect.height * this.TILE_HEIGHT + 8));
        }
    }

    public void setToolPreview(ToolPreview newPreview) {
        Rectangle r;
        CityRect b;
        if (this.toolPreview != null) {
            b = this.toolPreview.getBounds();
            r = new Rectangle(b.x * this.TILE_WIDTH, b.y * this.TILE_HEIGHT, b.width * this.TILE_WIDTH, b.height * this.TILE_HEIGHT);
            this.repaint(r);
        }
        this.toolPreview = newPreview;
        if (this.toolPreview != null) {
            b = this.toolPreview.getBounds();
            r = new Rectangle(b.x * this.TILE_WIDTH, b.y * this.TILE_HEIGHT, b.width * this.TILE_WIDTH, b.height * this.TILE_HEIGHT);
            this.repaint(r);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.TILE_HEIGHT * 3;
        }
        return this.TILE_WIDTH * 3;
    }

    private Rectangle getSpriteBounds(Sprite sprite, int x, int y) {
        return new Rectangle((x + sprite.offx) * this.TILE_WIDTH / 16, (y + sprite.offy) * this.TILE_HEIGHT / 16, sprite.width * this.TILE_WIDTH / 16, sprite.height * this.TILE_HEIGHT / 16);
    }

    public Rectangle getTileBounds(int xpos, int ypos) {
        return new Rectangle(xpos * this.TILE_WIDTH, ypos * this.TILE_HEIGHT, this.TILE_WIDTH, this.TILE_HEIGHT);
    }

    @Override
    public void mapOverlayDataChanged(MapState overlayDataType) {
    }

    @Override
    public void spriteMoved(Sprite sprite) {
        this.repaint(this.getSpriteBounds(sprite, sprite.lastX, sprite.lastY));
        this.repaint(this.getSpriteBounds(sprite, sprite.x, sprite.y));
    }

    @Override
    public void tileChanged(int xpos, int ypos) {
        this.repaint(this.getTileBounds(xpos, ypos));
    }

    @Override
    public void wholeMapChanged() {
        this.repaint();
    }

    protected void startDrag(int x, int y) {
        this.dragging = true;
        this.dragX = x;
        this.dragY = y;
    }

    protected void endDrag(int x, int y) {
        this.dragging = false;
    }

    protected void continueDrag(int x, int y) {
        int dx = x - this.dragX;
        int dy = y - this.dragY;
        JScrollPane js = (JScrollPane)this.getParent().getParent();
        js.getHorizontalScrollBar().setValue(js.getHorizontalScrollBar().getValue() - dx);
        js.getVerticalScrollBar().setValue(js.getVerticalScrollBar().getValue() - dy);
    }

    void doBlink() {
        if (!this.unpoweredZones.isEmpty()) {
            this.blink = !this.blink;
            for (Point loc : this.unpoweredZones) {
                this.repaint(this.getTileBounds(loc.x, loc.y));
            }
            this.unpoweredZones.clear();
        }
    }

    void startBlinkTimer() {
        assert (this.blinkTimer == null);
        ActionListener callback = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MicropolisDrawingArea.this.doBlink();
            }
        };
        this.blinkTimer = new Timer(500, callback);
        this.blinkTimer.start();
    }

    void stopBlinkTimer() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
        }
    }

    void shake(int i) {
        this.shakeStep = i;
        this.repaint();
    }

    int getShakeModifier(int row) {
        return (int)Math.round(4.0 * Math.sin((double)(this.shakeStep + row / 2) / 2.0));
    }

    static class ToolCursor {
        CityRect rect;
        Color borderColor;
        Color fillColor;

        ToolCursor() {
        }
    }
}

