/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import micropolisj.engine.GameLevel;
import micropolisj.engine.MapGenerator;
import micropolisj.engine.Micropolis;
import micropolisj.gui.MainWindow;
import micropolisj.gui.OverlayMapView;

public class NewCityDialog
extends JDialog {
    Micropolis engine;
    JButton previousMapBtn;
    Stack<Micropolis> previousMaps = new Stack();
    Stack<Micropolis> nextMaps = new Stack();
    OverlayMapView mapPane;
    HashMap<Integer, JRadioButton> levelBtns = new HashMap();
    static final ResourceBundle strings = MainWindow.strings;

    public NewCityDialog(MainWindow owner, boolean showCancelOption) {
        super(owner);
        this.setTitle(strings.getString("welcome.caption"));
        this.setModal(true);
        assert (owner != null);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.getContentPane().add((Component)p1, "Center");
        this.engine = new Micropolis();
        new MapGenerator(this.engine).generateNewCity();
        this.mapPane = new OverlayMapView(this.engine);
        this.mapPane.setBorder(BorderFactory.createLoweredBevelBorder());
        p1.add((Component)this.mapPane, "West");
        JPanel p2 = new JPanel(new BorderLayout());
        p1.add((Component)p2, "Center");
        Box levelBox = new Box(1);
        levelBox.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        p2.add((Component)levelBox, "Center");
        levelBox.add(Box.createVerticalGlue());
        for (int lev = 0; lev <= 2; ++lev) {
            final int x = lev;
            JRadioButton radioBtn = new JRadioButton(strings.getString("menu.difficulty." + lev));
            radioBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCityDialog.this.setGameLevel(x);
                }
            });
            levelBox.add(radioBtn);
            this.levelBtns.put(lev, radioBtn);
        }
        levelBox.add(Box.createVerticalGlue());
        this.setGameLevel(0);
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btn = new JButton(strings.getString("welcome.previous_map"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCityDialog.this.onPreviousMapClicked();
            }
        });
        btn.setEnabled(false);
        buttonPane.add(btn);
        this.previousMapBtn = btn;
        btn = new JButton(strings.getString("welcome.play_this_map"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCityDialog.this.onPlayClicked();
            }
        });
        buttonPane.add(btn);
        this.getRootPane().setDefaultButton(btn);
        btn = new JButton(strings.getString("welcome.next_map"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCityDialog.this.onNextMapClicked();
            }
        });
        buttonPane.add(btn);
        btn = new JButton(strings.getString("welcome.load_city"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCityDialog.this.onLoadCityClicked();
            }
        });
        buttonPane.add(btn);
        if (showCancelOption) {
            btn = new JButton(strings.getString("welcome.cancel"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCityDialog.this.onCancelClicked();
                }
            });
            buttonPane.add(btn);
        } else {
            btn = new JButton(strings.getString("welcome.quit"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCityDialog.this.onQuitClicked();
                }
            });
            buttonPane.add(btn);
        }
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCityDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void onPreviousMapClicked() {
        if (this.previousMaps.isEmpty()) {
            return;
        }
        this.nextMaps.push(this.engine);
        this.engine = this.previousMaps.pop();
        this.mapPane.setEngine(this.engine);
        this.previousMapBtn.setEnabled(!this.previousMaps.isEmpty());
    }

    private void onNextMapClicked() {
        if (this.nextMaps.isEmpty()) {
            Micropolis m = new Micropolis();
            new MapGenerator(m).generateNewCity();
            this.nextMaps.add(m);
        }
        this.previousMaps.push(this.engine);
        this.engine = this.nextMaps.pop();
        this.mapPane.setEngine(this.engine);
        this.previousMapBtn.setEnabled(true);
    }

    private void onLoadCityClicked() {
        try {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter(strings.getString("cty_file"), "cty");
            fc.setFileFilter(filter1);
            int rv = fc.showOpenDialog(this);
            if (rv == 0) {
                File file = fc.getSelectedFile();
                Micropolis newEngine = new Micropolis();
                newEngine.load(file);
                this.startPlaying(newEngine, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, e, strings.getString("main.error_caption"), 0);
        }
    }

    void startPlaying(Micropolis newEngine, File file) {
        MainWindow win = (MainWindow)this.getOwner();
        win.setEngine(newEngine);
        win.currentFile = file;
        win.makeClean();
        this.dispose();
    }

    private void onPlayClicked() {
        this.engine.setGameLevel(this.getSelectedGameLevel());
        this.engine.setFunds(GameLevel.getStartingFunds(this.engine.gameLevel));
        this.startPlaying(this.engine, null);
    }

    private void onCancelClicked() {
        this.dispose();
    }

    private void onQuitClicked() {
        System.exit(0);
    }

    private int getSelectedGameLevel() {
        for (int lev : this.levelBtns.keySet()) {
            if (!this.levelBtns.get(lev).isSelected()) continue;
            return lev;
        }
        return 0;
    }

    private void setGameLevel(int level) {
        Iterator<Integer> iterator = this.levelBtns.keySet().iterator();
        while (iterator.hasNext()) {
            int lev;
            this.levelBtns.get(lev).setSelected((lev = iterator.next().intValue()) == level);
        }
    }
}

