/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import micropolisj.engine.MapListener;
import micropolisj.engine.MapState;
import micropolisj.engine.Micropolis;
import micropolisj.engine.Sprite;
import micropolisj.engine.TileConstants;
import micropolisj.gui.MicropolisDrawingArea;

public class OverlayMapView
extends JComponent
implements Scrollable,
MapListener {
    Micropolis engine;
    ArrayList<ConnectedView> views = new ArrayList();
    MapState mapState = MapState.ALL;
    static BufferedImage tileArrayImage = OverlayMapView.loadImage("/sm/tiles.png");
    static final int TILE_WIDTH = 3;
    static final int TILE_HEIGHT = 3;
    static final int TILE_OFFSET_Y = 3;
    static final Color VAL_LOW = new Color(0xBFBFBF);
    static final Color VAL_MEDIUM = new Color(0xFFFF00);
    static final Color VAL_HIGH = new Color(0xFF7F00);
    static final Color VAL_VERYHIGH = new Color(0xFF0000);
    static final Color VAL_PLUS = new Color(32512);
    static final Color VAL_VERYPLUS = new Color(58880);
    static final Color VAL_MINUS = new Color(0xFF7F00);
    static final Color VAL_VERYMINUS = new Color(0xFFFF00);
    static final int UNPOWERED = 0x6666E6;
    static final int POWERED = 0xFF0000;
    static final int CONDUCTIVE = 0xBFBFBF;

    public OverlayMapView(Micropolis _engine) {
        assert (_engine != null);
        MouseAdapter mouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                OverlayMapView.this.onMousePressed(ev);
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                OverlayMapView.this.onMouseDragged(ev);
            }
        };
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.setEngine(_engine);
    }

    public Micropolis getEngine() {
        return this.engine;
    }

    public void setEngine(Micropolis newEngine) {
        assert (newEngine != null);
        if (this.engine != null) {
            this.engine.removeMapListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addMapListener(this);
        }
        this.invalidate();
        this.repaint();
        this.engine.calculateCenterMass();
        this.dragViewToCityCenter();
    }

    public MapState getMapState() {
        return this.mapState;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getInsets().left + this.getInsets().right + 3 * this.engine.getWidth(), this.getInsets().top + this.getInsets().bottom + 3 * this.engine.getHeight());
    }

    public void setMapState(MapState newState) {
        if (this.mapState == newState) {
            return;
        }
        this.mapState = newState;
        this.repaint();
    }

    static BufferedImage loadImage(String resourceName) {
        URL iconUrl = MicropolisDrawingArea.class.getResource(resourceName);
        Image refImage = new ImageIcon(iconUrl).getImage();
        BufferedImage bi = new BufferedImage(refImage.getWidth(null), refImage.getHeight(null), 1);
        Graphics2D gr = bi.createGraphics();
        gr.drawImage(refImage, 0, 0, null);
        return bi;
    }

    private Color getCI(int x) {
        if (x < 50) {
            return null;
        }
        if (x < 100) {
            return VAL_LOW;
        }
        if (x < 150) {
            return VAL_MEDIUM;
        }
        if (x < 200) {
            return VAL_HIGH;
        }
        return VAL_VERYHIGH;
    }

    private Color getCI_rog(int x) {
        if (x > 100) {
            return VAL_VERYPLUS;
        }
        if (x > 20) {
            return VAL_PLUS;
        }
        if (x < -100) {
            return VAL_VERYMINUS;
        }
        if (x < -20) {
            return VAL_MINUS;
        }
        return null;
    }

    private void drawPollutionMap(Graphics gr) {
        int[][] A = this.engine.pollutionMem;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI(10 + A[y][x]), x * 6, y * 6, 6, 6);
            }
        }
    }

    private void drawCrimeMap(Graphics gr) {
        int[][] A = this.engine.crimeMem;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI(A[y][x]), x * 6, y * 6, 6, 6);
            }
        }
    }

    private void drawPopDensity(Graphics gr) {
        int[][] A = this.engine.popDensity;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI(A[y][x]), x * 6, y * 6, 6, 6);
            }
        }
    }

    private void drawRateOfGrowth(Graphics gr) {
        int[][] A = this.engine.rateOGMem;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI_rog(A[y][x]), x * 24, y * 24, 24, 24);
            }
        }
    }

    private void drawFireRadius(Graphics gr) {
        int[][] A = this.engine.fireRate;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI(A[y][x]), x * 24, y * 24, 24, 24);
            }
        }
    }

    private void drawPoliceRadius(Graphics gr) {
        int[][] A = this.engine.policeMapEffect;
        for (int y = 0; y < A.length; ++y) {
            for (int x = 0; x < A[y].length; ++x) {
                this.maybeDrawRect(gr, this.getCI(A[y][x]), x * 24, y * 24, 24, 24);
            }
        }
    }

    private void maybeDrawRect(Graphics gr, Color col, int x, int y, int width, int height) {
        if (col != null) {
            gr.setColor(col);
            gr.fillRect(x, y, width, height);
        }
    }

    private int checkPower(BufferedImage img, int x, int y, int rawTile) {
        int pix;
        if ((rawTile & 0x3FF) <= 63) {
            return rawTile & 0x3FF;
        }
        if (TileConstants.isZoneCenter(rawTile)) {
            pix = (rawTile & 0x8000) != 0 ? 0xFF0000 : 0x6666E6;
        } else if (TileConstants.isConductive(rawTile)) {
            pix = 0xBFBFBF;
        } else {
            return 0;
        }
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                img.setRGB(x * 3 + xx, y * 3 + yy, pix);
            }
        }
        return -1;
    }

    private int checkLandValueOverlay(BufferedImage img, int xpos, int ypos, int tile) {
        int v = this.engine.getLandValue(xpos, ypos);
        Color c = this.getCI(v);
        if (c == null) {
            return tile;
        }
        int pix = c.getRGB();
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                img.setRGB(xpos * 3 + xx, ypos * 3 + yy, pix);
            }
        }
        return -1;
    }

    private int checkTrafficOverlay(BufferedImage img, int xpos, int ypos, int tile) {
        int d = this.engine.getTrafficDensity(xpos, ypos);
        Color c = this.getCI(d);
        if (c == null) {
            return tile;
        }
        int pix = c.getRGB();
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                img.setRGB(xpos * 3 + xx, ypos * 3 + yy, pix);
            }
        }
        return -1;
    }

    @Override
    public void paintComponent(Graphics gr) {
        int width = this.engine.getWidth();
        int height = this.engine.getHeight();
        BufferedImage img = new BufferedImage(width * 3, height * 3, 1);
        Insets INSETS = this.getInsets();
        Rectangle clipRect = gr.getClipBounds();
        int minX = Math.max(0, (clipRect.x - INSETS.left) / 3);
        int minY = Math.max(0, (clipRect.y - INSETS.top) / 3);
        int maxX = Math.min(width, 1 + (clipRect.x - INSETS.left + clipRect.width - 1) / 3);
        int maxY = Math.min(height, 1 + (clipRect.y - INSETS.top + clipRect.height - 1) / 3);
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                int tile = this.engine.getTile(x, y);
                switch (this.mapState) {
                    case RESIDENTIAL: {
                        if (!TileConstants.isZoneAny(tile) || TileConstants.isResidentialZoneAny(tile)) break;
                        tile = 0;
                        break;
                    }
                    case COMMERCIAL: {
                        if (!TileConstants.isZoneAny(tile) || TileConstants.isCommercialZone(tile)) break;
                        tile = 0;
                        break;
                    }
                    case INDUSTRIAL: {
                        if (!TileConstants.isZoneAny(tile) || TileConstants.isIndustrialZone(tile)) break;
                        tile = 0;
                        break;
                    }
                    case POWER_OVERLAY: {
                        tile = this.checkPower(img, x, y, this.engine.getTile(x, y));
                        break;
                    }
                    case TRANSPORT: 
                    case TRAFFIC_OVERLAY: {
                        if (TileConstants.isConstructed(tile) && !TileConstants.isRoadAny(tile) && !TileConstants.isRailAny(tile)) {
                            tile = 0;
                        }
                        if (this.mapState != MapState.TRAFFIC_OVERLAY) break;
                        tile = this.checkTrafficOverlay(img, x, y, tile);
                        break;
                    }
                    case LANDVALUE_OVERLAY: {
                        tile = this.checkLandValueOverlay(img, x, y, tile);
                        break;
                    }
                }
                if (tile == -1) continue;
                this.paintTile(img, x, y, tile);
            }
        }
        gr.drawImage(img, INSETS.left, INSETS.top, null);
        gr = gr.create();
        gr.translate(INSETS.left, INSETS.top);
        switch (this.mapState) {
            case POLICE_OVERLAY: {
                this.drawPoliceRadius(gr);
                break;
            }
            case FIRE_OVERLAY: {
                this.drawFireRadius(gr);
                break;
            }
            case CRIME_OVERLAY: {
                this.drawCrimeMap(gr);
                break;
            }
            case POLLUTE_OVERLAY: {
                this.drawPollutionMap(gr);
                break;
            }
            case GROWTHRATE_OVERLAY: {
                this.drawRateOfGrowth(gr);
                break;
            }
            case POPDEN_OVERLAY: {
                this.drawPopDensity(gr);
                break;
            }
        }
        for (ConnectedView cv : this.views) {
            Rectangle rect = this.getViewRect(cv);
            gr.setColor(Color.WHITE);
            gr.drawRect(rect.x - 2, rect.y - 2, rect.width + 2, rect.height + 2);
            gr.setColor(Color.BLACK);
            gr.drawRect(rect.x - 0, rect.y - 0, rect.width + 2, rect.height + 2);
            gr.setColor(Color.YELLOW);
            gr.drawRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
        }
    }

    void paintTile(BufferedImage img, int x, int y, int tile) {
        assert (tile >= 0);
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                img.setRGB(x * 3 + xx, y * 3 + yy, tileArrayImage.getRGB(xx, tile * 3 + yy));
            }
        }
    }

    Rectangle getViewRect(ConnectedView cv) {
        Rectangle rawRect = cv.scrollPane.getViewport().getViewRect();
        return new Rectangle(rawRect.x * 3 / cv.view.getTileSize(), rawRect.y * 3 / cv.view.getTileSize(), rawRect.width * 3 / cv.view.getTileSize(), rawRect.height * 3 / cv.view.getTileSize());
    }

    private void dragViewTo(Point p) {
        if (this.views.isEmpty()) {
            return;
        }
        ConnectedView cv = this.views.get(0);
        Dimension d = cv.scrollPane.getViewport().getExtentSize();
        Dimension mapSize = cv.scrollPane.getViewport().getViewSize();
        Point np = new Point(p.x * cv.view.getTileSize() / 3 - d.width / 2, p.y * cv.view.getTileSize() / 3 - d.height / 2);
        np.x = Math.max(0, Math.min(np.x, mapSize.width - d.width));
        np.y = Math.max(0, Math.min(np.y, mapSize.height - d.height));
        cv.scrollPane.getViewport().setViewPosition(np);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(120, 120);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 3;
        }
        return 3;
    }

    @Override
    public void mapOverlayDataChanged(MapState overlayDataType) {
        this.repaint();
    }

    @Override
    public void spriteMoved(Sprite sprite) {
    }

    @Override
    public void tileChanged(int xpos, int ypos) {
        Rectangle r = new Rectangle(xpos * 3, ypos * 3, 3, 3);
        this.repaint(r);
    }

    @Override
    public void wholeMapChanged() {
        this.repaint();
        this.engine.calculateCenterMass();
        this.dragViewToCityCenter();
    }

    public void dragViewToCityCenter() {
        this.dragViewTo(new Point(3 * this.engine.centerMassX + 1, 3 * this.engine.centerMassY + 1));
    }

    public void connectView(MicropolisDrawingArea view, JScrollPane scrollPane) {
        ConnectedView cv = new ConnectedView(view, scrollPane);
        this.views.add(cv);
        this.repaint();
    }

    private void onMousePressed(MouseEvent ev) {
        if (ev.getButton() == 1) {
            this.dragViewTo(ev.getPoint());
        }
    }

    private void onMouseDragged(MouseEvent ev) {
        if ((ev.getModifiersEx() & 0x400) == 0) {
            return;
        }
        this.dragViewTo(ev.getPoint());
    }

    class ConnectedView
    implements ChangeListener {
        MicropolisDrawingArea view;
        JScrollPane scrollPane;

        ConnectedView(MicropolisDrawingArea view, JScrollPane scrollPane) {
            this.view = view;
            this.scrollPane = scrollPane;
            scrollPane.getViewport().addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            OverlayMapView.this.repaint();
        }
    }
}

