/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import rescue.RescueIO;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Wormhole;

public class MissionObject {
    private String type;
    private String name;
    private int number;
    public static final int infoImageSize = 150;
    private Vector myObjects;
    private Vector names;
    private Hashtable URLs;
    private Hashtable images;
    private Hashtable icons;
    private Vector types;
    private Vector amounts;
    private int min;
    private int max;
    private int presetCadet;
    private int presetLieutenant;
    private int presetCaptain;
    private int presetAdmiral;
    private int INFOwarp;
    private double INFOimpulse;
    private int INFOjump;
    private int INFOturn;
    private int INFOphaser;
    private int INFOtorpedos;
    private int INFOtractor;
    private int INFOcloak;
    private int INFOmaxtotalenergy;
    private int INFOmaxphaserbanks;
    private int INFOmaxtorpedosleft;
    private int INFOmaxshieldpower;
    private URL bigImageURL;
    private URL smallImageURL;
    private URL infoImageURL;
    private BufferedImage imageA;
    private BufferedImage imageB;
    private BufferedImage imageC;
    private BufferedImage imageD;

    public MissionObject(String n, URL i, URL ismall, URL info, String num, String t) {
        this.name = n;
        this.number = Integer.parseInt(num);
        this.type = t;
        this.names = new Vector();
        this.types = new Vector();
        this.amounts = new Vector();
        this.images = new Hashtable();
        this.icons = new Hashtable();
        this.URLs = new Hashtable();
        this.bigImageURL = i;
        this.smallImageURL = ismall;
        this.infoImageURL = info;
        this.INFOwarp = 0;
        this.INFOimpulse = 0.0;
        this.INFOjump = 1;
        this.INFOturn = 1;
        this.INFOphaser = 0;
        this.INFOtorpedos = 0;
        this.INFOtractor = 0;
        this.INFOcloak = 0;
        this.INFOmaxtotalenergy = 0;
        this.INFOmaxphaserbanks = 0;
        this.INFOmaxtorpedosleft = 0;
        this.INFOmaxshieldpower = 0;
    }

    public void loadImagesForSetup() throws IOException {
        if (this.imageA == null) {
            this.imageA = ImageIO.read(RescueIO.getInputStream(this.bigImageURL));
            this.imageB = ImageIO.read(RescueIO.getInputStream(this.smallImageURL));
            this.imageC = new BufferedImage(20, 20, 2);
            Graphics g = this.imageC.getGraphics();
            g.drawImage(this.imageA, 0, 0, 20, 20, null);
            g.drawImage(this.imageB, 20 - this.imageB.getWidth(), 20 - this.imageB.getHeight(), null);
        }
    }

    public void loadImagesForGame() throws IOException {
        for (int c = 0; c < this.names.size(); ++c) {
            String a = (String)this.names.get(c);
            URL url = (URL)this.URLs.get(a);
            if (url == null) continue;
            BufferedImage iA = ImageIO.read(RescueIO.getInputStream(url));
            BufferedImage iC = new BufferedImage(20, 20, 2);
            Graphics g = iC.getGraphics();
            g.drawImage(iA, 0, 0, 20, 20, null);
            g.drawImage(this.imageB, 20 - this.imageB.getWidth(), 20 - this.imageB.getHeight(), null);
            this.images.put(a, iA);
            this.icons.put(a, iC);
        }
        if (this.infoImageURL != null) {
            this.imageD = ImageIO.read(RescueIO.getInputStream(this.infoImageURL));
        } else {
            this.imageD = new BufferedImage(150, 150, 4);
            Graphics g = this.imageD.getGraphics();
            g.drawImage(this.imageA, 0, 0, 150, 150, null);
        }
    }

    public BufferedImage getIcon() {
        return this.imageC;
    }

    public void setMinMax(String n, String m) {
        this.min = Integer.parseInt(n);
        this.max = Integer.parseInt(m);
    }

    public void setPreset(String n, String v) {
        if (n.equals("cadet")) {
            this.presetCadet = Integer.parseInt(v);
        } else if (n.equals("lieutenant")) {
            this.presetLieutenant = Integer.parseInt(v);
        } else if (n.equals("captain")) {
            this.presetCaptain = Integer.parseInt(v);
        } else if (n.equals("admiral")) {
            this.presetAdmiral = Integer.parseInt(v);
        }
    }

    public int getCurrentPreset(int a) {
        if (a == 1) {
            return this.presetCadet;
        }
        if (a == 2) {
            return this.presetLieutenant;
        }
        if (a == 3) {
            return this.presetCaptain;
        }
        return this.presetAdmiral;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    public void addLike(String a, String b) {
        this.types.add(a);
        this.amounts.add(new Integer(b));
    }

    public void addName(String a, URL b) throws Exception {
        this.names.add(a);
        if (b != null) {
            this.URLs.put(a, b);
        }
    }

    public void setInfoWarp(String a) {
        this.INFOwarp = Integer.parseInt(a);
    }

    public void setInfoImpulse(String a) {
        this.INFOimpulse = Double.parseDouble(a);
    }

    public void setInfoJump(String a) {
        this.INFOjump = Integer.parseInt(a);
    }

    public void setInfoTurn(String a) {
        this.INFOturn = Integer.parseInt(a);
    }

    public void setInfoPhaser(String a) {
        this.INFOphaser = Integer.parseInt(a);
    }

    public void setInfoTorpedos(String a) {
        this.INFOtorpedos = Integer.parseInt(a);
    }

    public void setInfoTractor(String a) {
        this.INFOtractor = Integer.parseInt(a);
    }

    public void setInfoCloak(String a) {
        this.INFOcloak = Integer.parseInt(a);
    }

    public void setInfoMaxTotalEnergy(String a) {
        this.INFOmaxtotalenergy = Integer.parseInt(a);
    }

    public void setInfoMaxPhaserBanks(String a) {
        this.INFOmaxphaserbanks = Integer.parseInt(a);
    }

    public void setInfoMaxTorpedosLeft(String a) {
        this.INFOmaxtorpedosleft = Integer.parseInt(a);
    }

    public void setInfoMaxShieldPower(String a) {
        this.INFOmaxshieldpower = Integer.parseInt(a);
    }

    public int makeSpaceObjects(ImageObject[] v, boolean cluster, int position, Vector t) {
        this.myObjects = new Vector();
        Enumeration e = this.names.elements();
        String n = "";
        int x = (int)(Math.random() * 1000000.0);
        int y = (int)(Math.random() * 1000000.0);
        for (int i = 0; i < this.number; ++i) {
            ImageObject so = null;
            if (cluster && this.type.equals("ship")) {
                x = x + (int)(Math.random() * 1000000.0 / 10.0) - 50000;
                y = y + (int)(Math.random() * 1000000.0 / 10.0) - 50000;
            } else {
                x = (int)(Math.random() * 1000000.0);
                y = (int)(Math.random() * 1000000.0);
            }
            BufferedImage iA = this.imageA;
            BufferedImage iB = this.imageB;
            BufferedImage iC = this.imageC;
            BufferedImage iD = this.imageD;
            if (this.number == 1) {
                n = this.name;
            } else if (e.hasMoreElements()) {
                n = (String)e.nextElement();
                BufferedImage newImage = (BufferedImage)this.images.get(n);
                if (newImage != null) {
                    iA = newImage;
                    iC = (BufferedImage)this.icons.get(n);
                    iD = new BufferedImage(150, 150, 4);
                    Graphics g = iD.getGraphics();
                    g.drawImage(iA, 0, 0, 150, 150, null);
                }
            } else {
                n = this.name + " " + (i + 1);
            }
            if (this.type.equals("ship")) {
                so = new Ship(position, this.name, n, x, y, v, iA, iB, iC, iD, t);
                so.setInfo(this.INFOwarp, this.INFOimpulse, this.INFOjump, this.INFOturn);
            } else if (this.type.equals("base")) {
                so = new Base(position, this.name, n, x, y, v, iA, iB, iC, iD, t);
            } else if (this.type.equals("planet")) {
                so = new Planet(position, this.name, n, x, y, v, iA, iB, iC, iD, t);
            } else if (this.type.equals("wormhole")) {
                so = new Wormhole(position, this.name, n, x, y, v, iA, iB, iC, iD, t);
            }
            if (so instanceof MannedObject) {
                ((MannedObject)so).setInfo(this.INFOphaser, this.INFOtorpedos, this.INFOtractor, this.INFOcloak, this.INFOmaxtotalenergy, this.INFOmaxphaserbanks, this.INFOmaxtorpedosleft, this.INFOmaxshieldpower);
            }
            v[position] = so;
            ++position;
            this.myObjects.add(so);
        }
        return position;
    }

    public void setLikes(ImageObject[] v) {
        int i;
        int[] tmp = new int[v.length];
        for (i = 0; i < this.types.size(); ++i) {
            String who = (String)this.types.elementAt(i);
            int amount = (Integer)this.amounts.elementAt(i);
            for (int c = 0; c < v.length; ++c) {
                if (!(v[c] instanceof MannedObject) || !((MannedObject)v[c]).getType().equals(who)) continue;
                tmp[c] = amount;
            }
        }
        for (i = 0; i < this.myObjects.size(); ++i) {
            if (!(this.myObjects.elementAt(i) instanceof MannedObject)) continue;
            ((MannedObject)this.myObjects.elementAt(i)).setLikes(tmp);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllies(String p) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!((String)this.types.elementAt(i)).equals(p)) continue;
            return (Integer)this.amounts.elementAt(i) > 0;
        }
        return false;
    }

    public boolean isEnemies(String p) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!((String)this.types.elementAt(i)).equals(p)) continue;
            return (Integer)this.amounts.elementAt(i) < 0;
        }
        return false;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getCurrentRank(String p, int a) {
        if (this.isEnemies(p)) {
            if (this.presetAdmiral == 0 && a > 0) {
                return 8;
            }
            if (this.presetAdmiral == 0 && a == 0) {
                return -1;
            }
            if (a >= this.presetAdmiral) {
                return 4;
            }
            if (a >= this.presetCaptain) {
                return 3;
            }
            if (a >= this.presetLieutenant) {
                return 2;
            }
            if (a >= this.presetCadet) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

