/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class Keymap
implements KeyEventDispatcher {
    private final List actions;
    public Action setupAction;
    public String setupName;

    public Keymap(List a) {
        this.actions = a;
    }

    public List getActions() {
        return this.actions;
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (this.setupAction != null || id == 401) {
            int keycode = e.getKeyCode();
            int modifiers = e.getModifiers();
            if (keycode == 17 || keycode == 16 || keycode == 18 || keycode == 65406 || keycode == 157) {
                if ((modifiers & 8) != 0) {
                    keycode = 18;
                }
                modifiers = 0;
            }
            KeyStroke ks = KeyStroke.getKeyStroke(keycode, modifiers);
            if (this.setupAction != null) {
                if (id == 402) {
                    this.setupAction.putValue(this.setupName, ks);
                    this.setupAction = null;
                    this.setupName = null;
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                }
                return true;
            }
            if (id == 401) {
                for (int c = 0; c < this.actions.size(); ++c) {
                    Action action = (Action)this.actions.get(c);
                    KeyStroke akey = (KeyStroke)action.getValue("AcceleratorKey");
                    if (!ks.equals(akey)) continue;
                    action.actionPerformed(null);
                    return true;
                }
            }
        }
        return false;
    }

    public void setupKeyForAction(Action action, String name) {
        this.setupAction = action;
        this.setupName = name;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public static void loadKeys(List actions, InputStream file) throws Exception {
        Properties keysconfig = new Properties();
        keysconfig.load(file);
        for (int c = 0; c < actions.size(); ++c) {
            Action action = (Action)actions.get(c);
            String keys = keysconfig.getProperty((String)action.getValue("ActionCommandKey"));
            KeyStroke ks = keys != null && !"".equals(keys) ? KeyStroke.getKeyStroke((int)keys.charAt(0), (int)keys.charAt(1)) : null;
            action.putValue("AcceleratorKey", ks);
        }
    }

    public static void saveKeys(List actions, OutputStream file) throws Exception {
        Properties keysconfig = new Properties();
        for (int c = 0; c < actions.size(); ++c) {
            Action action = (Action)actions.get(c);
            String name = (String)action.getValue("ActionCommandKey");
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke != null) {
                keysconfig.setProperty(name, (char)keyStroke.getKeyCode() + "" + (char)keyStroke.getModifiers());
                continue;
            }
            keysconfig.setProperty(name, "");
        }
        keysconfig.store(file, "keys");
    }
}

