/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import rescue.JukeBox;
import rescue.RescueIO;
import rescue.RunRescue;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.Ship;

public class InterfacePanel
extends JPanel
implements MouseInputListener {
    private RunRescue rescue;
    private MapButton[] buttonImages;
    private Vector infoTexts;
    private Vector infoBars;
    private int width;
    private int height;
    private int[][] map;
    private BufferedImage img;
    private BufferedImage imgON;
    private int cc;
    private int pp;
    private int tt;
    private infoText INFOTEXT_MAN_IMPULSE;
    private infoText INFOTEXT_MAN_WARP;
    private infoText INFOTEXT_IMPULSE_SPEED;
    private infoText INFOTEXT_IMPULSE_AUTO;
    private infoText INFOTEXT_WARP_SPEED;
    private infoText INFOTEXT_WARP_AUTO;
    private infoText INFOTEXT_PHASER;
    private infoText INFOTEXT_TORPEDO;
    private infoText INFOTEXT_SHIELDS_UP;
    private infoText INFOTEXT_SHIELDS_POWER;
    private infoText INFOTEXT_TOTAL_POWER;
    private infoText INFOTEXT_PHASER_BANKS;
    private infoText INFOTEXT_TORPEDOS_LEFT;
    private infoText INFOTEXT_SYSTEM_WARPDRIVE;
    private infoText INFOTEXT_SYSTEM_IMPULSEDRIVE;
    private infoText INFOTEXT_SYSTEM_PHASERBANKS;
    private infoText INFOTEXT_SYSTEM_TORPEDOTUBES;
    private infoText INFOTEXT_SYSTEM_LONGRANGESCAN;
    private infoText INFOTEXT_SYSTEM_SENSORSCAN;
    private infoText INFOTEXT_SYSTEM_SHIELDS;
    private infoText INFOTEXT_SYSTEM_COMPUTER;
    private infoText INFOTEXT_SYSTEM_TRANSPORTERS;
    private infoText INFOTEXT_SYSTEM_TRACTORBEAM;
    private infoText INFOTEXT_OUTPOSTS_RESCUED;
    private infoText INFOTEXT_OUTPOSTS_DESTROYED;
    private infoText INFOTEXT_OUTPOSTS_REMAINING;
    private infoText INFOTEXT_OTHERSHIPS_FRIENDLIES;
    private infoText INFOTEXT_OTHERSHIPS_ENEMIES;
    private infoText INFOTEXT_OTHERSHIPS_DESTROYED;
    private infoText INFOTEXT_COLONIES_ONBOARD;
    private infoText INFOTEXT_NUMBER_AWAY_TEAMS;
    private infoText INFOTEXT_SCAN;
    private infoText INFOTEXT_CONDITION;
    private infoBar INFOBAR_TOTAL_POWER;
    private infoBar INFOBAR_PHASER_BANKS;
    private infoBar INFOBAR_TORPEDOS_LEFT;
    private infoBar INFOBAR_TRACTOR_BEAM;
    private infoBar INFOBAR_SHIELD_POWER;

    public InterfacePanel(RunRescue rr, int w, int h) {
        this(rr);
        this.width = w;
        this.height = h;
    }

    public InterfacePanel(RunRescue rr) {
        this.rescue = rr;
        this.width = -1;
        this.height = -1;
        this.setLayout(null);
        this.cc = 255;
        this.pp = 255;
        this.tt = 255;
        this.infoTexts = new Vector();
        this.infoBars = new Vector();
        this.map = null;
    }

    public void setupImages(URL sin_on, URL sin_off, URL sin_up, URL sin_down, URL sin_map, int nob) throws Exception {
        BufferedImage in_off;
        BufferedImage in_on = ImageIO.read(RescueIO.getInputStream(sin_on));
        if (this.width != -1 && in_on.getWidth() != this.width || this.height != -1 && in_on.getHeight() != this.height) {
            throw new Exception("image \"" + sin_on + "\" does not mach panel size");
        }
        this.width = in_on.getWidth();
        this.height = in_on.getHeight();
        Dimension size = new Dimension(this.width, this.height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.img = in_off = ImageIO.read(RescueIO.getInputStream(sin_off));
        this.imgON = in_on;
        if (nob > 0) {
            int c;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            BufferedImage in_up = ImageIO.read(RescueIO.getInputStream(sin_up));
            BufferedImage in_down = ImageIO.read(RescueIO.getInputStream(sin_down));
            BufferedImage in_map = ImageIO.read(RescueIO.getInputStream(sin_map));
            int none = new Color(0, 0, 0, 0).getRGB();
            int ppX = in_map.getWidth();
            int ppY = in_map.getHeight();
            this.map = new int[ppX][ppY];
            this.buttonImages = new MapButton[nob];
            for (c = 0; c < nob; ++c) {
                this.buttonImages[c] = new MapButton(ppX, ppY);
            }
            for (int y = 0; y < ppY; ++y) {
                for (int x = 0; x < ppX; ++x) {
                    int num = in_map.getRGB(x, y) & 0xFF;
                    if (num < nob) {
                        this.map[x][y] = num;
                        if (x < this.buttonImages[num].getX1()) {
                            this.buttonImages[num].setX1(x);
                        }
                        if (x > this.buttonImages[num].getX2()) {
                            this.buttonImages[num].setX2(x);
                        }
                        if (y < this.buttonImages[num].getY1()) {
                            this.buttonImages[num].setY1(y);
                        }
                        if (y <= this.buttonImages[num].getY2()) continue;
                        this.buttonImages[num].setY2(y);
                        continue;
                    }
                    this.map[x][y] = 255;
                }
            }
            for (c = 0; c < this.buttonImages.length; ++c) {
                int x1 = this.buttonImages[c].getX1();
                int x2 = this.buttonImages[c].getX2();
                int y1 = this.buttonImages[c].getY1();
                int y2 = this.buttonImages[c].getY2();
                int w = this.buttonImages[c].getWidth();
                int h = this.buttonImages[c].getHeight();
                BufferedImage i_off = new BufferedImage(w, h, 2);
                i_off.getGraphics().drawImage(in_off.getSubimage(x1, y1, w, h), 0, 0, this);
                BufferedImage i_on = new BufferedImage(w, h, 2);
                i_on.getGraphics().drawImage(in_on.getSubimage(x1, y1, w, h), 0, 0, this);
                BufferedImage i_up = new BufferedImage(w, h, 2);
                i_up.getGraphics().drawImage(in_up.getSubimage(x1, y1, w, h), 0, 0, this);
                BufferedImage i_down = new BufferedImage(w, h, 2);
                i_down.getGraphics().drawImage(in_down.getSubimage(x1, y1, w, h), 0, 0, this);
                this.buttonImages[c].setOffImage(i_off);
                this.buttonImages[c].setOnImage(i_on);
                this.buttonImages[c].setUpImage(i_up);
                this.buttonImages[c].setDownImage(i_down);
                for (int y = y1; y <= y2; ++y) {
                    for (int x = 0; x <= w - 1; ++x) {
                        if (this.map[x + x1][y] == c) continue;
                        i_off.setRGB(x, y - y1, none);
                        i_on.setRGB(x, y - y1, none);
                        i_up.setRGB(x, y - y1, none);
                        i_down.setRGB(x, y - y1, none);
                    }
                }
            }
        }
    }

    public void setCommandValue(String c, int v, String t) throws Exception {
        Action action = this.rescue.getAction(c);
        this.buttonImages[v].setAction(action);
        this.buttonImages[v].setToolTip(t);
    }

    public void setInfoText(String c, int x, int y, int w, int h, int textX, int textY, Color z) throws Exception {
        BufferedImage back = this.img.getSubimage(x, y, w, h);
        infoText v = new infoText(back, x, y, textX, textY, z);
        this.infoTexts.add(v);
        if (c.equals("impulse_speed")) {
            this.INFOTEXT_IMPULSE_SPEED = v;
        } else if (c.equals("impulse_auto")) {
            this.INFOTEXT_IMPULSE_AUTO = v;
        } else if (c.equals("warp_speed")) {
            this.INFOTEXT_WARP_SPEED = v;
        } else if (c.equals("warp_auto")) {
            this.INFOTEXT_WARP_AUTO = v;
        } else if (c.equals("phaser")) {
            this.INFOTEXT_PHASER = v;
        } else if (c.equals("torpedo")) {
            this.INFOTEXT_TORPEDO = v;
        } else if (c.equals("shields_up")) {
            this.INFOTEXT_SHIELDS_UP = v;
        } else if (c.equals("shields_power")) {
            this.INFOTEXT_SHIELDS_POWER = v;
        } else if (c.equals("total_energy")) {
            this.INFOTEXT_TOTAL_POWER = v;
        } else if (c.equals("phaser_banks")) {
            this.INFOTEXT_PHASER_BANKS = v;
        } else if (c.equals("torpedos_left")) {
            this.INFOTEXT_TORPEDOS_LEFT = v;
        } else if (c.equals("system_warpdrive")) {
            this.INFOTEXT_SYSTEM_WARPDRIVE = v;
        } else if (c.equals("system_impulsedrive")) {
            this.INFOTEXT_SYSTEM_IMPULSEDRIVE = v;
        } else if (c.equals("system_phaserbanks")) {
            this.INFOTEXT_SYSTEM_PHASERBANKS = v;
        } else if (c.equals("system_torpedotubes")) {
            this.INFOTEXT_SYSTEM_TORPEDOTUBES = v;
        } else if (c.equals("system_longrangescan")) {
            this.INFOTEXT_SYSTEM_LONGRANGESCAN = v;
        } else if (c.equals("system_sencorscan")) {
            this.INFOTEXT_SYSTEM_SENSORSCAN = v;
        } else if (c.equals("system_shields")) {
            this.INFOTEXT_SYSTEM_SHIELDS = v;
        } else if (c.equals("system_computer")) {
            this.INFOTEXT_SYSTEM_COMPUTER = v;
        } else if (c.equals("system_transporters")) {
            this.INFOTEXT_SYSTEM_TRANSPORTERS = v;
        } else if (c.equals("system_tractorbeam")) {
            this.INFOTEXT_SYSTEM_TRACTORBEAM = v;
        } else if (c.equals("outposts_rescued")) {
            this.INFOTEXT_OUTPOSTS_RESCUED = v;
        } else if (c.equals("outposts_destroyed")) {
            this.INFOTEXT_OUTPOSTS_DESTROYED = v;
        } else if (c.equals("outposts_remaining")) {
            this.INFOTEXT_OUTPOSTS_REMAINING = v;
        } else if (c.equals("otherships_friendlies")) {
            this.INFOTEXT_OTHERSHIPS_FRIENDLIES = v;
        } else if (c.equals("otherships_enemies")) {
            this.INFOTEXT_OTHERSHIPS_ENEMIES = v;
        } else if (c.equals("otherships_destroyed")) {
            this.INFOTEXT_OTHERSHIPS_DESTROYED = v;
        } else if (c.equals("colonies_onboard")) {
            this.INFOTEXT_COLONIES_ONBOARD = v;
        } else if (c.equals("number_away_teams")) {
            this.INFOTEXT_NUMBER_AWAY_TEAMS = v;
        } else if (c.equals("scan")) {
            this.INFOTEXT_SCAN = v;
        } else if (c.equals("condition")) {
            this.INFOTEXT_CONDITION = v;
        } else if (c.equals("man_impulse")) {
            this.INFOTEXT_MAN_IMPULSE = v;
        } else if (c.equals("man_warp")) {
            this.INFOTEXT_MAN_WARP = v;
        } else {
            throw new Exception("unknown infotext " + c);
        }
    }

    public void setInfoBar(String c, int x, int y, int w, int h, String d) throws Exception {
        BufferedImage i1 = this.img.getSubimage(x, y, w, h);
        BufferedImage i2 = this.imgON.getSubimage(x, y, w, h);
        infoBar v = new infoBar(i1, i2, x, y, d);
        this.infoBars.add(v);
        if (c.equals("total_energy")) {
            this.INFOBAR_TOTAL_POWER = v;
        } else if (c.equals("phaser_banks")) {
            this.INFOBAR_PHASER_BANKS = v;
        } else if (c.equals("torpedos_left")) {
            this.INFOBAR_TORPEDOS_LEFT = v;
        } else if (c.equals("tractor_beam")) {
            this.INFOBAR_TRACTOR_BEAM = v;
        } else if (c.equals("shield_power")) {
            this.INFOBAR_SHIELD_POWER = v;
        } else {
            throw new Exception("unknown infobar " + c);
        }
    }

    public void list() {
        Ship ship = this.rescue.getShip();
        Graphics g = this.getGraphics();
        if (this.buttonImages != null) {
            for (int c = 0; c < this.buttonImages.length; ++c) {
                if (!this.buttonImages[c].checkChanged()) continue;
                g.drawImage(this.buttonImages[c].getImage(), this.buttonImages[c].getX1(), this.buttonImages[c].getY1(), this);
            }
        }
        if (this.INFOTEXT_IMPULSE_SPEED != null && this.INFOTEXT_IMPULSE_SPEED.checkOn(ship.getImpulseSpeed())) {
            this.INFOTEXT_IMPULSE_SPEED.draw(g, true);
        }
        if (this.INFOTEXT_IMPULSE_AUTO != null) {
            String impulse;
            Point i = ship.getAutoImpulse();
            if (i == null) {
                impulse = "  -- NOT SET --";
            } else if (i instanceof ImageObject) {
                impulse = ((ImageObject)i).getName();
                if (impulse.length() > 13) {
                    impulse = impulse.substring(0, 11) + "...";
                }
            } else {
                impulse = i.x + "," + i.y;
            }
            if (this.INFOTEXT_IMPULSE_AUTO.checkOn(impulse)) {
                this.INFOTEXT_IMPULSE_AUTO.draw(g, true);
            }
        }
        if (this.INFOTEXT_WARP_SPEED != null && this.INFOTEXT_WARP_SPEED.checkOn(ship.getWarpSpeed())) {
            this.INFOTEXT_WARP_SPEED.draw(g, true);
        }
        if (this.INFOTEXT_WARP_AUTO != null) {
            String warp;
            Point w = ship.getAutoWarp();
            if (w == null) {
                warp = "  -- NOT SET --";
            } else if (w instanceof ImageObject) {
                warp = ((ImageObject)w).getName();
                if (warp.length() > 13) {
                    warp = warp.substring(0, 11) + "...";
                }
            } else {
                warp = w.x + "," + w.y;
            }
            if (this.INFOTEXT_WARP_AUTO.checkOn(warp)) {
                this.INFOTEXT_WARP_AUTO.draw(g, true);
            }
        }
        if (this.INFOTEXT_PHASER != null && this.INFOTEXT_PHASER.checkOn(ship.getPhaserIntensity())) {
            this.INFOTEXT_PHASER.draw(g, true);
        }
        if (this.INFOTEXT_TORPEDO != null && this.INFOTEXT_TORPEDO.checkOn(ship.getTorpedoSalvo())) {
            this.INFOTEXT_TORPEDO.draw(g, true);
        }
        if (this.INFOTEXT_SHIELDS_UP != null && this.INFOTEXT_SHIELDS_UP.checkOn(ship.getShieldsUp() ? "ON" : "OFF")) {
            this.INFOTEXT_SHIELDS_UP.draw(g, true);
        }
        if (this.INFOTEXT_SHIELDS_POWER != null && this.INFOTEXT_SHIELDS_POWER.checkOn((int)((double)ship.getShieldPower() / (double)ship.getMaxshieldpower() * 100.0) + "")) {
            this.INFOTEXT_SHIELDS_POWER.draw(g, true);
        }
        if (this.INFOTEXT_TOTAL_POWER != null && this.INFOTEXT_TOTAL_POWER.checkOn(ship.getTotalEnergy() + "")) {
            this.INFOTEXT_TOTAL_POWER.draw(g, true);
        }
        if (this.INFOTEXT_PHASER_BANKS != null && this.INFOTEXT_PHASER_BANKS.checkOn(ship.getPhaserBanks() + "")) {
            this.INFOTEXT_PHASER_BANKS.draw(g, true);
        }
        if (this.INFOTEXT_TORPEDOS_LEFT != null && this.INFOTEXT_TORPEDOS_LEFT.checkOn(ship.getTorpedosLeft() + "")) {
            this.INFOTEXT_TORPEDOS_LEFT.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_WARPDRIVE != null && this.INFOTEXT_SYSTEM_WARPDRIVE.checkOn(ship.getSystemText(1))) {
            this.INFOTEXT_SYSTEM_WARPDRIVE.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_IMPULSEDRIVE != null && this.INFOTEXT_SYSTEM_IMPULSEDRIVE.checkOn(ship.getSystemText(2))) {
            this.INFOTEXT_SYSTEM_IMPULSEDRIVE.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_PHASERBANKS != null && this.INFOTEXT_SYSTEM_PHASERBANKS.checkOn(ship.getSystemText(3))) {
            this.INFOTEXT_SYSTEM_PHASERBANKS.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_TORPEDOTUBES != null && this.INFOTEXT_SYSTEM_TORPEDOTUBES.checkOn(ship.getSystemText(4))) {
            this.INFOTEXT_SYSTEM_TORPEDOTUBES.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_LONGRANGESCAN != null && this.INFOTEXT_SYSTEM_LONGRANGESCAN.checkOn(ship.getSystemText(5))) {
            this.INFOTEXT_SYSTEM_LONGRANGESCAN.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_SENSORSCAN != null && this.INFOTEXT_SYSTEM_SENSORSCAN.checkOn(ship.getSystemText(6))) {
            this.INFOTEXT_SYSTEM_SENSORSCAN.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_SHIELDS != null && this.INFOTEXT_SYSTEM_SHIELDS.checkOn(ship.getSystemText(7))) {
            this.INFOTEXT_SYSTEM_SHIELDS.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_COMPUTER != null && this.INFOTEXT_SYSTEM_COMPUTER.checkOn(ship.getSystemText(8))) {
            this.INFOTEXT_SYSTEM_COMPUTER.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_TRANSPORTERS != null && this.INFOTEXT_SYSTEM_TRANSPORTERS.checkOn(ship.getSystemText(9))) {
            this.INFOTEXT_SYSTEM_TRANSPORTERS.draw(g, true);
        }
        if (this.INFOTEXT_SYSTEM_TRACTORBEAM != null && this.INFOTEXT_SYSTEM_TRACTORBEAM.checkOn(ship.getSystemText(10))) {
            this.INFOTEXT_SYSTEM_TRACTORBEAM.draw(g, true);
        }
        if (this.INFOTEXT_OUTPOSTS_RESCUED != null && this.INFOTEXT_OUTPOSTS_RESCUED.checkOn(this.rescue.getBaseNumbers(1) + "")) {
            this.INFOTEXT_OUTPOSTS_RESCUED.draw(g, true);
        }
        if (this.INFOTEXT_OUTPOSTS_DESTROYED != null && this.INFOTEXT_OUTPOSTS_DESTROYED.checkOn(this.rescue.getBaseNumbers(2) + "")) {
            this.INFOTEXT_OUTPOSTS_DESTROYED.draw(g, true);
        }
        if (this.INFOTEXT_OUTPOSTS_REMAINING != null && this.INFOTEXT_OUTPOSTS_REMAINING.checkOn(this.rescue.getBaseNumbers(3) + "")) {
            this.INFOTEXT_OUTPOSTS_REMAINING.draw(g, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_FRIENDLIES != null && this.INFOTEXT_OTHERSHIPS_FRIENDLIES.checkOn(this.rescue.getShipNumbers(1) + "")) {
            this.INFOTEXT_OTHERSHIPS_FRIENDLIES.draw(g, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_ENEMIES != null && this.INFOTEXT_OTHERSHIPS_ENEMIES.checkOn(this.rescue.getShipNumbers(2) + "")) {
            this.INFOTEXT_OTHERSHIPS_ENEMIES.draw(g, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_DESTROYED != null && this.INFOTEXT_OTHERSHIPS_DESTROYED.checkOn(this.rescue.getShipNumbers(3) + "")) {
            this.INFOTEXT_OTHERSHIPS_DESTROYED.draw(g, true);
        }
        if (this.INFOTEXT_COLONIES_ONBOARD != null && this.INFOTEXT_COLONIES_ONBOARD.checkOn(ship.getNoColonies() + "")) {
            this.INFOTEXT_COLONIES_ONBOARD.draw(g, true);
        }
        if (this.INFOTEXT_NUMBER_AWAY_TEAMS != null && this.INFOTEXT_NUMBER_AWAY_TEAMS.checkOn(ship.getNoAwayTeams() + "")) {
            this.INFOTEXT_NUMBER_AWAY_TEAMS.draw(g, true);
        }
        if (this.INFOTEXT_SCAN != null && this.INFOTEXT_SCAN.checkOn(ship.getScan())) {
            this.INFOTEXT_SCAN.draw(g, true);
        }
        if (this.INFOTEXT_MAN_IMPULSE != null && this.INFOTEXT_MAN_IMPULSE.checkOn(ship.getManImpulse() + "")) {
            this.INFOTEXT_MAN_IMPULSE.draw(g, true);
        }
        if (this.INFOTEXT_MAN_WARP != null && this.INFOTEXT_MAN_WARP.checkOn(ship.getManWarp() + "")) {
            this.INFOTEXT_MAN_WARP.draw(g, true);
        }
        if (this.INFOTEXT_CONDITION != null) {
            Color conColor;
            String condition;
            int con = ship.getCondition();
            if (con == 1) {
                condition = " Green";
                conColor = Color.GREEN.darker().darker();
            } else if (con == 2) {
                condition = " Yellow";
                conColor = Color.YELLOW;
            } else {
                condition = "* RED *";
                conColor = Color.RED.darker().darker();
            }
            if (this.INFOTEXT_CONDITION.checkOn(condition)) {
                this.INFOTEXT_CONDITION.setColor(conColor);
                this.INFOTEXT_CONDITION.draw(g, true);
            }
        }
        if (this.INFOBAR_TOTAL_POWER != null && this.INFOBAR_TOTAL_POWER.checkOn(ship.getTotalEnergy(), ship.getMaxtotalenergy())) {
            this.INFOBAR_TOTAL_POWER.draw(g, true);
        }
        if (this.INFOBAR_PHASER_BANKS != null && this.INFOBAR_PHASER_BANKS.checkOn(ship.getPhaserBanks(), ship.getMaxphaserbanks())) {
            this.INFOBAR_PHASER_BANKS.draw(g, true);
        }
        if (this.INFOBAR_TORPEDOS_LEFT != null && this.INFOBAR_TORPEDOS_LEFT.checkOn(ship.getTorpedosLeft(), ship.getMaxtorpedosleft())) {
            this.INFOBAR_TORPEDOS_LEFT.draw(g, true);
        }
        if (this.INFOBAR_TRACTOR_BEAM != null && this.INFOBAR_TRACTOR_BEAM.checkOn(ship.getTractorBeamPower(), ship.getTractorBeamMaxPower())) {
            this.INFOBAR_TRACTOR_BEAM.draw(g, true);
        }
        if (this.INFOBAR_SHIELD_POWER != null && this.INFOBAR_SHIELD_POWER.checkOn(ship.getShieldPower(), ship.getMaxshieldpower())) {
            this.INFOBAR_SHIELD_POWER.draw(g, true);
        }
    }

    public void paintComponent(Graphics g) {
        int i;
        g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
        if (this.map != null) {
            if (this.pp != 255) {
                g.drawImage(this.buttonImages[this.pp].getDownImage(), this.buttonImages[this.pp].getX1(), this.buttonImages[this.pp].getY1(), this);
            } else if (this.cc != 255) {
                g.drawImage(this.buttonImages[this.cc].getUpImage(), this.buttonImages[this.cc].getX1(), this.buttonImages[this.cc].getY1(), this);
            }
            for (i = 0; i < this.buttonImages.length; ++i) {
                if (!this.buttonImages[i].getOn()) continue;
                g.drawImage(this.buttonImages[i].getImage(), this.buttonImages[i].getX1(), this.buttonImages[i].getY1(), this);
            }
        }
        for (i = 0; i < this.infoTexts.size(); ++i) {
            ((infoText)this.infoTexts.elementAt(i)).draw(g, false);
        }
        for (i = 0; i < this.infoBars.size(); ++i) {
            ((infoBar)this.infoBars.elementAt(i)).draw(g, false);
        }
    }

    public void command(int a) {
        Action action = this.buttonImages[a].getAction();
        if (action != null) {
            action.actionPerformed(null);
            JukeBox.play("mouseclick");
        } else {
            System.out.print("action not set for color " + a + "\n");
        }
    }

    public void mouseMoved(MouseEvent e) {
        int a = this.map[e.getX()][e.getY()];
        if (a != this.cc) {
            Graphics g = this.getGraphics();
            if (this.cc < this.buttonImages.length) {
                g.drawImage(this.buttonImages[this.cc].getImage(), this.buttonImages[this.cc].getX1(), this.buttonImages[this.cc].getY1(), this);
            }
            this.cc = a;
            if (this.cc < this.buttonImages.length) {
                g.drawImage(this.buttonImages[this.cc].getUpImage(), this.buttonImages[this.cc].getX1(), this.buttonImages[this.cc].getY1(), this);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        int a = this.map[e.getX()][e.getY()];
        if (a < this.buttonImages.length) {
            Graphics g = this.getGraphics();
            g.drawImage(this.buttonImages[a].getDownImage(), this.buttonImages[a].getX1(), this.buttonImages[a].getY1(), this);
            if (a < this.buttonImages.length) {
                this.pp = a;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0 || x >= this.img.getWidth() || y < 0 || y >= this.img.getHeight()) {
            return;
        }
        int a = this.map[x][y];
        if (a != this.cc && this.pp != 255) {
            Graphics g = this.getGraphics();
            if (a != this.pp) {
                g.drawImage(this.buttonImages[this.pp].getImage(), this.buttonImages[this.pp].getX1(), this.buttonImages[this.pp].getY1(), this);
            } else {
                g.drawImage(this.buttonImages[this.pp].getDownImage(), this.buttonImages[this.pp].getX1(), this.buttonImages[this.pp].getY1(), this);
            }
            this.cc = a;
        }
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0 || x >= this.img.getWidth() || y < 0 || y >= this.img.getHeight()) {
            this.pp = 255;
            return;
        }
        int a = this.map[x][y];
        if (a < this.buttonImages.length) {
            if (a == this.pp) {
                this.command(a);
            }
            if (this.rescue.getShip() != null) {
                Graphics g = this.getGraphics();
                g.drawImage(this.buttonImages[a].getUpImage(), this.buttonImages[a].getX1(), this.buttonImages[a].getY1(), this);
            }
        }
        this.pp = 255;
    }

    public void mouseExited(MouseEvent e) {
        if (this.cc != 255) {
            Graphics g = this.getGraphics();
            g.drawImage(this.buttonImages[this.cc].getImage(), this.buttonImages[this.cc].getX1(), this.buttonImages[this.cc].getY1(), this);
            this.cc = 255;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public boolean contains(int x, int y) {
        if (this.map != null) {
            if (x < 0 || x >= this.img.getWidth() || y < 0 || y >= this.img.getHeight()) {
                this.tt = 255;
                return false;
            }
            int a = this.map[x][y];
            if (a == 255) {
                this.tt = 255;
                return false;
            }
            if (a != this.tt) {
                this.setToolTipText(this.buttonImages[a].getToolTip());
                this.tt = a;
            }
            return true;
        }
        return false;
    }

    class MapButton {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private BufferedImage offImage;
        private BufferedImage onImage;
        private BufferedImage HighLightImage;
        private BufferedImage PressDownImage;
        private boolean on;
        private String tooltip;
        private Action action;

        public MapButton(int a, int b) {
            this.x1 = a;
            this.y1 = b;
            this.x2 = 0;
            this.y2 = 0;
            this.onImage = null;
            this.HighLightImage = null;
            this.PressDownImage = null;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public void setAction(Action a) {
            this.action = a;
        }

        public Action getAction() {
            return this.action;
        }

        public void setToolTip(String a) {
            this.tooltip = a;
        }

        public boolean checkChanged() {
            boolean a;
            boolean bl = this.action != null ? !this.action.isEnabled() : (a = false);
            if (a != this.on) {
                this.on = a;
                return true;
            }
            return false;
        }

        public boolean getOn() {
            return this.on;
        }

        public void setOffImage(BufferedImage a) {
            this.offImage = a;
        }

        public void setOnImage(BufferedImage a) {
            this.onImage = a;
        }

        public void setUpImage(BufferedImage a) {
            this.HighLightImage = a;
        }

        public void setDownImage(BufferedImage a) {
            this.PressDownImage = a;
        }

        public void setX1(int a) {
            this.x1 = a;
        }

        public void setY1(int a) {
            this.y1 = a;
        }

        public void setX2(int a) {
            this.x2 = a;
        }

        public void setY2(int a) {
            this.y2 = a;
        }

        public BufferedImage getImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.offImage;
        }

        public BufferedImage getUpImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.HighLightImage;
        }

        public BufferedImage getDownImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.PressDownImage;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public int getWidth() {
            return this.x2 - this.x1 + 1;
        }

        public int getHeight() {
            return this.y2 - this.y1 + 1;
        }
    }

    class infoText {
        private int x;
        private int y;
        private int textX;
        private int textY;
        private BufferedImage back;
        private String text;
        private Color color;

        public infoText(BufferedImage b, int i, int j, int ti, int tj, Color z) {
            this.back = b;
            this.text = "";
            this.x = i;
            this.y = j;
            this.textX = ti;
            this.textY = tj;
            this.color = z;
        }

        public boolean checkOn(String a) {
            if (this.text.equals(a)) {
                return false;
            }
            this.text = a;
            return true;
        }

        public void draw(Graphics g, boolean a) {
            if (a) {
                g.drawImage(this.back, this.x, this.y, InterfacePanel.this);
            }
            g.setColor(this.color);
            g.drawString(this.text, this.textX, this.textY);
        }

        public void setColor(Color a) {
            this.color = a;
        }
    }

    class infoBar {
        private int x;
        private int y;
        private int value;
        private int direction;
        private BufferedImage on;
        private BufferedImage off;
        private int nx;
        private int ny;
        private int nw;
        private int nh;

        public infoBar(BufferedImage i1, BufferedImage i2, int ix, int iy, String d) throws Exception {
            this.x = ix;
            this.y = iy;
            this.value = 0;
            if (d.equals("right")) {
                this.direction = 1;
            } else if (d.equals("left")) {
                this.direction = 2;
            } else if (d.equals("up")) {
                this.direction = 3;
            } else if (d.equals("down")) {
                this.direction = 4;
            } else {
                throw new Exception("unknows direction " + d);
            }
            this.on = i2;
            this.off = i1;
        }

        public boolean checkOn(int a, int outof) {
            if (this.value == a) {
                return false;
            }
            this.value = a;
            this.nx = 0;
            this.ny = 0;
            this.nw = this.on.getWidth();
            this.nh = this.on.getHeight();
            if (this.direction == 1) {
                this.nw = (int)((double)this.nw * ((double)this.value / (double)outof));
            } else if (this.direction == 2) {
                this.nw = (int)((double)this.nw * ((double)this.value / (double)outof));
                this.nx += this.on.getWidth() - this.nw;
            } else if (this.direction == 3) {
                this.nh = (int)((double)this.nh * ((double)this.value / (double)outof));
                this.ny += this.on.getHeight() - this.nh;
            } else if (this.direction == 4) {
                this.nh = (int)((double)this.nh * ((double)this.value / (double)outof));
            }
            return true;
        }

        public void draw(Graphics g, boolean clean) {
            if (clean) {
                g.drawImage(this.off, this.x, this.y, InterfacePanel.this);
            }
            if (this.nw != 0 && this.nh != 0) {
                g.drawImage(this.on.getSubimage(this.nx, this.ny, this.nw, this.nh), this.x + this.nx, this.y + this.ny, InterfacePanel.this);
            }
        }
    }
}

