/*
 * Decompiled with CFR 0.152.
 */
package solarex.system;

import java.util.Random;
import solarex.galaxy.SystemLocation;
import solarex.system.NameGenerator;
import solarex.system.Solar;
import solarex.util.Mathlib;

public class Society {
    public GovernmentType governmentType = GovernmentType.Anarchy;
    public Race race;
    public int population = 0;
    public static int totalPopulation;
    public int techLevel;

    private static void calculateGovernment(Solar system) {
        system.society.governmentType = GovernmentType.Anarchy;
        switch (system.society.race) {
            case Clonkniks: {
                system.society.governmentType = GovernmentType.Communism;
                break;
            }
            case Floatees: {
                system.society.governmentType = GovernmentType.Utopia;
                break;
            }
            case Rockeaters: 
            case Poisonbreathers: 
            case Terraneans: {
                int roll = system.rng.nextInt(100);
                system.society.governmentType = roll < 5 ? GovernmentType.Theocracy : (roll < 10 ? GovernmentType.Anarchy : (roll < 15 ? GovernmentType.Dictatorship : (roll < 22 ? GovernmentType.Monarchy : (roll < 30 ? GovernmentType.Oligarchy : (roll < 60 ? GovernmentType.Republic : GovernmentType.Democracy)))));
            }
        }
    }

    public static double calcProbability(SystemLocation loca) {
        double dist = Math.sqrt(loca.galacticSectorI * loca.galacticSectorI + loca.galacticSectorJ * loca.galacticSectorJ);
        double chance = Mathlib.gauss(dist, 0.0, 12.0) * 26.0;
        return chance;
    }

    public static void populate(Solar system) {
        double chance = Society.calcProbability(system.loca);
        totalPopulation = 0;
        System.err.println("Population probability: " + chance);
        Society.populateAux(system, chance);
        System.err.println("Total population: " + totalPopulation);
        int level = (int)Math.log10(totalPopulation);
        Society.setTechLevelAux(system, level += (int)(system.rng.nextDouble() * 12.0));
    }

    private static void populateAux(Solar system, double chance) {
        Random rng = system.rng;
        system.society = new Society();
        if (system.btype == Solar.BodyType.PLANET) {
            system.society.race = Race.Terraneans;
            system.society.governmentType = GovernmentType.Democracy;
            switch (system.ptype) {
                case BIG_GAS: 
                case RINGS: {
                    if (system.eet < 100 || system.eet > 200 || !(system.rng.nextDouble() < chance * 0.4)) break;
                    system.society.race = Race.Floatees;
                    system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 20;
                    Society.calculateGovernment(system);
                    break;
                }
                case SMALL_GAS: {
                    if (system.eet >= 100 && system.eet <= 200 && system.rng.nextDouble() < chance * 0.5) {
                        system.society.race = Race.Floatees;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (!(system.rng.nextDouble() < chance * 0.03)) break;
                    system.society.race = Race.Clonkniks;
                    system.society.population = system.radius + rng.nextInt(system.radius * 2);
                    Society.calculateGovernment(system);
                    break;
                }
                case ATM_ROCK: 
                case BARE_ROCK: {
                    if (system.rng.nextDouble() < chance * 0.05) {
                        system.society.race = Race.Terraneans;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (system.eet >= 0 && system.eet <= 240 && system.rng.nextDouble() < chance * 0.26) {
                        system.society.race = Race.Clonkniks;
                        system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 100;
                        Society.calculateGovernment(system);
                    }
                    if (system.eet < 400 || system.eet > 700 || !(system.rng.nextDouble() < chance * 0.5)) break;
                    system.society.race = Race.Rockeaters;
                    system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 100;
                    Society.calculateGovernment(system);
                    break;
                }
                case ICE: {
                    if (system.rng.nextDouble() < chance * 0.04) {
                        system.society.race = Race.Rockeaters;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (system.eet < 30 || system.eet > 260 || !(system.rng.nextDouble() < chance * 0.28)) break;
                    system.society.race = Race.Clonkniks;
                    system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 100;
                    Society.calculateGovernment(system);
                    break;
                }
                case EARTH: {
                    if (system.rng.nextDouble() < chance * 0.05) {
                        system.society.race = Race.Poisonbreathers;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (system.eet < 250 || system.eet > 350 || !(system.rng.nextDouble() < chance * 0.92)) break;
                    system.society.race = Race.Terraneans;
                    system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 100;
                    Society.calculateGovernment(system);
                    break;
                }
                case CLOUD: {
                    if (system.rng.nextDouble() < chance * 0.05) {
                        system.society.race = Race.Rockeaters;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (system.rng.nextDouble() < chance * 0.05) {
                        system.society.race = Race.Terraneans;
                        system.society.population = system.radius + rng.nextInt(system.radius * 2);
                        Society.calculateGovernment(system);
                    }
                    if (system.eet < 300 || system.eet > 500 || !(system.rng.nextDouble() < chance * 0.77)) break;
                    system.society.race = Race.Poisonbreathers;
                    system.society.population = (system.radius + rng.nextInt(system.radius * 4)) * 100;
                    Society.calculateGovernment(system);
                }
            }
            if (system.society.population > 10000) {
                system.name = NameGenerator.generatePlanetName(rng);
            }
            if (system.society.population > 0 || system.rng.nextDouble() < chance * 0.05) {
                Solar spaceport = new Solar(system, system.radius / 10, system.radius / 16, 0, 1, Solar.BodyType.SPACEPORT);
                spaceport.radius /= 8;
                spaceport.ptype = Solar.PlanetType.SPACEPORT;
                system.children.add(0, spaceport);
            }
        }
        if (system.btype == Solar.BodyType.STATION || system.btype == Solar.BodyType.SPACEPORT) {
            system.society.population = system.radius + rng.nextInt(system.radius * 2);
            Solar parent = system.getParent();
            if (parent != null && parent.btype == Solar.BodyType.PLANET && (parent.society.population > system.society.population * 5 || system.btype == Solar.BodyType.SPACEPORT)) {
                system.society.governmentType = parent.society.governmentType;
                system.society.race = parent.society.race;
            } else {
                system.society.race = Race.values()[rng.nextInt(Race.values().length)];
                Society.calculateGovernment(system);
            }
            if (system.btype == Solar.BodyType.STATION) {
                system.name = NameGenerator.generateStationName(rng, system.society.race);
            } else {
                system.name = NameGenerator.generateSpaceportName(rng, system.society.race);
                int rootPop = (int)(70.0 * Math.sqrt(system.getParent().society.population));
                rootPop = Math.min(rootPop, (int)(0.9 * (double)system.getParent().society.population));
                system.society.population = Math.max(rootPop, system.society.population);
            }
        }
        totalPopulation += system.society.population;
        for (int i = 0; i < system.children.size(); ++i) {
            Society.populateAux(system.children.get(i), chance);
        }
    }

    private static void setTechLevelAux(Solar system, int level) {
        system.society.techLevel = level + system.rng.nextInt(3);
        switch (system.society.governmentType) {
            case Anarchy: {
                system.society.techLevel += 0;
                break;
            }
            case Dictatorship: 
            case Communism: 
            case Theocracy: 
            case Oligarchy: {
                ++system.society.techLevel;
                break;
            }
            case Democracy: 
            case Republic: 
            case Socialism: {
                system.society.techLevel += 2;
                break;
            }
            case Utopia: {
                system.society.techLevel += 3;
            }
        }
        for (int i = 0; i < system.children.size(); ++i) {
            Society.setTechLevelAux(system.children.get(i), level);
        }
    }

    public static enum Race {
        Terraneans,
        Rockeaters,
        Poisonbreathers("Poison breathers"),
        Floatees("The ones who float"),
        Clonkniks;

        private String name;

        private Race() {
            this.name = this.name();
        }

        private Race(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum GovernmentType {
        Theocracy,
        Anarchy,
        Dictatorship,
        Monarchy,
        Democracy,
        Republic,
        Oligarchy,
        Socialism,
        Communism,
        Utopia;

    }
}

