/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import solarex.system.Society;
import solarex.system.Solar;
import solarex.ui.ImageCache;

public class PortraitPanel
extends JPanel {
    private Image upper;
    private Image mid;
    private Image lower;
    private Image full;
    private Image backdrop;

    public PortraitPanel(Solar station, Random rng, ImageCache imageCache) {
        ImageIcon[] parts = null;
        ImageIcon[] backgrounds = imageCache.portraitBackgrounds;
        if (station.society.race == Society.Race.Poisonbreathers) {
            parts = imageCache.poisonbreathers;
        } else if (station.society.race == Society.Race.Rockeaters) {
            parts = imageCache.rockeaters;
            backgrounds = imageCache.rockeaterPortraitBackgrounds;
        } else if (station.society.race == Society.Race.Clonkniks) {
            parts = imageCache.clonkniks;
            backgrounds = imageCache.clonknikPortraitBackgrounds;
        } else if (station.society.race == Society.Race.Floatees) {
            parts = imageCache.floatees;
            backgrounds = imageCache.floateePortraitBackgrounds;
        } else if (station.society.race == Society.Race.Terraneans) {
            parts = rng.nextDouble() < 0.5 ? imageCache.male : imageCache.female;
        }
        int stride = parts.length / 3;
        this.upper = parts[0 + rng.nextInt(stride)].getImage();
        this.mid = parts[stride + rng.nextInt(stride)].getImage();
        this.lower = parts[stride * 2 + rng.nextInt(stride)].getImage();
        this.full = rng.nextDouble() < 0.05 ? imageCache.transmissionError.getImage() : null;
        this.backdrop = backgrounds[(int)(rng.nextDouble() * (double)backgrounds.length)].getImage();
        this.setBackground(Color.GRAY);
    }

    @Override
    public void paint(Graphics gr) {
        super.paint(gr);
        int w = this.getWidth();
        int h = this.getHeight();
        ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        gr.drawImage(this.backdrop, 0, 0, this);
        if (this.full != null) {
            gr.drawImage(this.full, 0, 0, this);
        } else {
            int hh = h / 3;
            gr.drawImage(this.upper, 0, 0, w, hh, this);
            gr.drawImage(this.mid, 0, hh, w, hh, this);
            gr.drawImage(this.lower, 0, hh * 2 + 2, w, hh, this);
            gr.drawImage(this.lower, 0, hh * 2, w, hh, this);
        }
    }
}

