/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import solarex.util.RandomHelper;

public class StardrivePainter {
    private final ArrayList<Point2D.Double> stars;
    private final ArrayList<Point2D.Double> points;
    private final ArrayList<Color> colors;
    private boolean active = false;
    private int time;

    public boolean isActive() {
        return this.active;
    }

    public boolean isDone() {
        return this.time > 4000;
    }

    public void start() {
        this.time = 0;
        this.active = true;
    }

    public void stop() {
        this.active = false;
        this.time = 0;
    }

    public void moveJump(int deltaT) {
        this.time += deltaT;
    }

    public StardrivePainter() {
        int i;
        Random rng = RandomHelper.createRNG();
        this.points = new ArrayList();
        this.stars = new ArrayList();
        this.colors = new ArrayList();
        for (i = 0; i < 400; ++i) {
            this.stars.add(new Point2D.Double(rng.nextDouble(), rng.nextDouble()));
        }
        for (i = 0; i < 800; ++i) {
            Point2D.Double p = new Point2D.Double();
            p.x = rng.nextGaussian() * 150.0;
            p.y = rng.nextGaussian() * 100.0;
            this.points.add(p);
            int b = 220 - Math.min((int)Math.sqrt(p.x * p.x + p.y * p.y), 120);
            this.colors.add(new Color(b - rng.nextInt(90), b - rng.nextInt(90), b - rng.nextInt(90), 128));
        }
    }

    public void paint(Graphics gr, int width, int height) {
        gr.setColor(Color.BLACK);
        gr.fillRect(0, 0, width, height);
        int starCount = this.stars.size();
        for (int i = 0; i < starCount; ++i) {
            if (i < starCount / 4) {
                gr.setColor(Color.LIGHT_GRAY);
            } else if (i < starCount / 2) {
                gr.setColor(Color.GRAY);
            } else {
                gr.setColor(Color.DARK_GRAY);
            }
            Point2D.Double p = this.stars.get(i);
            gr.fillRect((int)(p.x * (double)width), (int)(p.y * (double)height), 1, 1);
        }
        double dist = (double)this.time * 0.5;
        gr.translate(width / 2, height / 2);
        for (int i = 0; i < this.points.size(); ++i) {
            Point2D.Double p = this.points.get(i);
            gr.setColor(this.colors.get(i));
            double d = Math.sqrt(p.x * p.x + p.y * p.y);
            gr.drawLine((int)(p.x + p.x * dist / d * 0.1), (int)(p.y + p.y * dist / d * 0.1), (int)(p.x + p.x * dist / d), (int)(p.y + p.y * dist / d));
        }
        gr.translate(-width / 2, -height / 2);
    }
}

