/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.fuin.utils4j.PropertiesFile;

public final class PropertiesFilePreferences
extends AbstractPreferences {
    public static final String FILENAME = "preferences.properties";
    private final File dir;
    private final PropertiesFile file;
    private boolean removed;

    public PropertiesFilePreferences(File dir) {
        this(null, dir, "");
    }

    public PropertiesFilePreferences(PropertiesFilePreferences parent, File dir) {
        this(parent, dir, dir.getName());
    }

    private PropertiesFilePreferences(PropertiesFilePreferences parent, File dir, String name) {
        super(parent, name);
        this.dir = dir;
        this.file = new PropertiesFile(new File(dir, FILENAME));
        this.removed = false;
    }

    protected final AbstractPreferences childSpi(String name) {
        File childDir = new File(this.dir, name);
        return new PropertiesFilePreferences(this, childDir, name);
    }

    protected final String[] childrenNamesSpi() throws BackingStoreException {
        try {
            ArrayList<String> childs = new ArrayList<String>();
            File[] files = this.dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) continue;
                    childs.add(files[i].getName());
                }
            }
            return childs.toArray(new String[0]);
        }
        catch (RuntimeException ex) {
            throw new BackingStoreException(ex);
        }
    }

    protected void flushSpi() throws BackingStoreException {
        try {
            if (this.removed) {
                this.file.delete();
                this.dir.delete();
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String[] comments = new String[]{"DO NOT EDIT!", "Created by " + this.getClass().getName(), sdf.format(new Date())};
                this.mkdirIfNecessary();
                this.file.save(comments, true);
            }
        }
        catch (Exception ex) {
            throw new BackingStoreException(ex);
        }
    }

    private void mkdirIfNecessary() throws BackingStoreException {
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            throw new BackingStoreException("Failed to create directory '" + this.dir + "'!");
        }
    }

    protected final String getSpi(String key) {
        this.loadIfNecessary();
        return this.file.get(key);
    }

    protected final String[] keysSpi() throws BackingStoreException {
        this.loadIfNecessary();
        return this.file.getKeyArray();
    }

    protected final void putSpi(String key, String value) {
        this.loadIfNecessary();
        this.file.put(key, value);
    }

    protected final void removeNodeSpi() throws BackingStoreException {
        this.file.clear();
        this.removed = true;
    }

    protected final void removeSpi(String key) {
        this.loadIfNecessary();
        this.file.remove(key);
    }

    private void loadIfNecessary() {
        if (!this.file.isLoaded()) {
            try {
                this.syncSpi();
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected final void syncSpi() throws BackingStoreException {
        if (this.dir.exists() && this.file.exists()) {
            try {
                this.file.load();
            }
            catch (Exception ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    public final Properties toProperties() {
        return this.file.toProperties();
    }
}

