/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.fuin.utils4j.LockingFailedException;
import org.fuin.utils4j.RandomAccessFileOutputStream;
import org.fuin.utils4j.Utils4J;

public final class RandomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile file;
    private long mark = -1L;

    public RandomAccessFileInputStream(File file, String mode) throws FileNotFoundException {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("mode", mode);
        this.file = new RandomAccessFile(file, mode);
    }

    public RandomAccessFileInputStream(RandomAccessFileInputStream in) {
        Utils4J.checkNotNull("in", in);
        this.file = in.getRandomAccessFile();
    }

    public RandomAccessFileInputStream(RandomAccessFileOutputStream out) {
        Utils4J.checkNotNull("out", out);
        this.file = out.getRandomAccessFile();
    }

    public final int read() throws IOException {
        return this.file.read();
    }

    public final int read(byte[] b) throws IOException {
        return this.file.read(b);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    public final long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            return super.skip(Integer.MAX_VALUE);
        }
        return this.file.skipBytes((int)n);
    }

    public final long fileSize() throws IOException {
        return this.file.length();
    }

    public final int available() throws IOException {
        if (this.file.getFilePointer() > this.file.length()) {
            return 0;
        }
        long avail = this.file.length() - this.file.getFilePointer();
        if (avail > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)avail;
    }

    public final void close() throws IOException {
        if (this.file.getChannel().isOpen()) {
            this.file.close();
        }
    }

    public synchronized void mark(int readlimit) {
        if (this.file.getChannel().isOpen()) {
            try {
                this.mark = this.file.getFilePointer();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public final synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("The method 'mark()' has not been called since the stream was created!");
        }
        this.file.seek(this.mark);
    }

    public final boolean markSupported() {
        return true;
    }

    public final FileChannel getChannel() {
        return this.file.getChannel();
    }

    final RandomAccessFile getRandomAccessFile() {
        return this.file;
    }

    public final void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public final FileLock lock(int tryLockMax, long tryWaitMillis) throws LockingFailedException {
        return Utils4J.lockRandomAccessFile(this.file, tryLockMax, tryWaitMillis);
    }
}

