/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.fuin.utils4j.LockingFailedException;
import org.fuin.utils4j.RandomAccessFileInputStream;
import org.fuin.utils4j.Utils4J;

public class RandomAccessFileOutputStream
extends OutputStream {
    private final RandomAccessFile file;
    private long counter = 0L;

    public RandomAccessFileOutputStream(File file, String mode) throws FileNotFoundException {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("mode", mode);
        this.file = new RandomAccessFile(file, mode);
    }

    public RandomAccessFileOutputStream(RandomAccessFileOutputStream out) {
        Utils4J.checkNotNull("out", out);
        this.file = out.getRandomAccessFile();
    }

    public RandomAccessFileOutputStream(RandomAccessFileInputStream in) {
        Utils4J.checkNotNull("in", in);
        this.file = in.getRandomAccessFile();
    }

    public final void write(int b) throws IOException {
        this.file.write(b);
        ++this.counter;
    }

    public final void write(byte[] b) throws IOException {
        this.file.write(b);
        this.counter += (long)b.length;
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        this.file.write(b, off, len);
        this.counter += (long)len;
    }

    public final void flush() throws IOException {
        this.file.getChannel().force(true);
    }

    public final void close() throws IOException {
        this.file.close();
    }

    public final FileChannel getChannel() {
        return this.file.getChannel();
    }

    final RandomAccessFile getRandomAccessFile() {
        return this.file;
    }

    public final void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public final void setLength(long newLength) throws IOException {
        this.file.setLength(newLength);
    }

    public final void resetCounter() {
        this.counter = 0L;
    }

    public final long getCounter() {
        return this.counter;
    }

    public final void truncate() throws IOException {
        this.file.setLength(this.counter);
    }

    public final FileLock lock(int tryLockMax, long tryWaitMillis) throws LockingFailedException {
        return Utils4J.lockRandomAccessFile(this.file, tryLockMax, tryWaitMillis);
    }
}

