/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.LinkedList;
import org.apache.batik.anim.values.AnimatableNumberOptionalNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSNavigableNode;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.anim.AnimationTargetListener;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.ExtendedTraitAccess;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAnimatedBoolean;
import org.apache.batik.dom.svg.SVGOMAnimatedEnumeration;
import org.apache.batik.dom.svg.SVGOMAnimatedInteger;
import org.apache.batik.dom.svg.SVGOMAnimatedLength;
import org.apache.batik.dom.svg.SVGOMAnimatedLengthList;
import org.apache.batik.dom.svg.SVGOMAnimatedMarkerOrientValue;
import org.apache.batik.dom.svg.SVGOMAnimatedNumber;
import org.apache.batik.dom.svg.SVGOMAnimatedNumberList;
import org.apache.batik.dom.svg.SVGOMAnimatedPathData;
import org.apache.batik.dom.svg.SVGOMAnimatedPoints;
import org.apache.batik.dom.svg.SVGOMAnimatedPreserveAspectRatio;
import org.apache.batik.dom.svg.SVGOMAnimatedRect;
import org.apache.batik.dom.svg.SVGOMAnimatedString;
import org.apache.batik.dom.svg.SVGOMAnimatedTransformList;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.TraitInformation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
ExtendedTraitAccess,
AnimationTarget {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected transient boolean readonly;
    protected String prefix;
    protected transient SVGContext svgContext;
    protected DoublyIndexedTable targetListeners;
    protected UnitProcessor.Context unitContext;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    protected void initializeAllLiveAttributes() {
    }

    public String getId() {
        Attr attr;
        if (((SVGOMDocument)this.ownerDocument).isSVG12 && (attr = this.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "id")) != null) {
            return attr.getNodeValue();
        }
        return this.getAttributeNS(null, "id");
    }

    public void setId(String string) {
        if (((SVGOMDocument)this.ownerDocument).isSVG12) {
            this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "id", string);
            Attr attr = this.getAttributeNodeNS(null, "id");
            if (attr != null) {
                attr.setNodeValue(string);
            }
        } else {
            this.setAttributeNS(null, "id", string);
        }
    }

    public String getXMLbase() {
        return this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }

    public void setXMLbase(String string) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", string);
    }

    public SVGSVGElement getOwnerSVGElement() {
        CSSStylableElement cSSStylableElement = CSSEngine.getParentCSSStylableElement(this);
        while (cSSStylableElement != null) {
            if (cSSStylableElement instanceof SVGSVGElement) {
                return (SVGSVGElement)cSSStylableElement;
            }
            cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        CSSStylableElement cSSStylableElement = CSSEngine.getParentCSSStylableElement(this);
        while (cSSStylableElement != null) {
            if (cSSStylableElement instanceof SVGFitToViewBox) {
                return (SVGElement)cSSStylableElement;
            }
            cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        }
        return null;
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        return this.prefix + ':' + this.getLocalName();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (string != null && !string.equals("") && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        this.prefix = string;
    }

    protected String getCascadedXMLBase(Node node) {
        Node node2;
        String string = null;
        Node node3 = node.getParentNode();
        while (node3 != null) {
            if (node3.getNodeType() == 1) {
                string = this.getCascadedXMLBase(node3);
                break;
            }
            if (node3 instanceof CSSNavigableNode) {
                node3 = ((CSSNavigableNode)((Object)node3)).getCSSParentNode();
                continue;
            }
            node3 = node3.getParentNode();
        }
        if (string == null) {
            node2 = node.getNodeType() == 9 ? (AbstractDocument)node : (AbstractDocument)node.getOwnerDocument();
            string = ((AbstractDocument)node2).getDocumentURI();
        }
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node == null) {
            return string;
        }
        node2 = (Element)node;
        Attr attr = node2.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (attr != null) {
            string = string == null ? attr.getNodeValue() : new ParsedURL(string, attr.getNodeValue()).toString();
        }
        return string;
    }

    public void setSVGContext(SVGContext sVGContext) {
        this.svgContext = sVGContext;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    public SVGException createSVGException(short s, String string, Object[] objectArray) {
        try {
            return new SVGOMException(s, this.getCurrentDocument().formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new SVGOMException(s, string);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    protected SVGOMAnimatedTransformList createLiveAnimatedTransformList(String string, String string2, String string3) {
        SVGOMAnimatedTransformList sVGOMAnimatedTransformList = new SVGOMAnimatedTransformList(this, string, string2, string3);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedTransformList);
        sVGOMAnimatedTransformList.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedTransformList;
    }

    protected SVGOMAnimatedBoolean createLiveAnimatedBoolean(String string, String string2, boolean bl) {
        SVGOMAnimatedBoolean sVGOMAnimatedBoolean = new SVGOMAnimatedBoolean(this, string, string2, bl);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedBoolean);
        sVGOMAnimatedBoolean.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedBoolean;
    }

    protected SVGOMAnimatedString createLiveAnimatedString(String string, String string2) {
        SVGOMAnimatedString sVGOMAnimatedString = new SVGOMAnimatedString(this, string, string2);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedString);
        sVGOMAnimatedString.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedString;
    }

    protected SVGOMAnimatedPreserveAspectRatio createLiveAnimatedPreserveAspectRatio() {
        SVGOMAnimatedPreserveAspectRatio sVGOMAnimatedPreserveAspectRatio = new SVGOMAnimatedPreserveAspectRatio(this);
        this.liveAttributeValues.put(null, "preserveAspectRatio", sVGOMAnimatedPreserveAspectRatio);
        sVGOMAnimatedPreserveAspectRatio.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedPreserveAspectRatio;
    }

    protected SVGOMAnimatedMarkerOrientValue createLiveAnimatedMarkerOrientValue(String string, String string2) {
        SVGOMAnimatedMarkerOrientValue sVGOMAnimatedMarkerOrientValue = new SVGOMAnimatedMarkerOrientValue(this, string, string2);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedMarkerOrientValue);
        sVGOMAnimatedMarkerOrientValue.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedMarkerOrientValue;
    }

    protected SVGOMAnimatedPathData createLiveAnimatedPathData(String string, String string2, String string3) {
        SVGOMAnimatedPathData sVGOMAnimatedPathData = new SVGOMAnimatedPathData(this, string, string2, string3);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedPathData);
        sVGOMAnimatedPathData.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedPathData;
    }

    protected SVGOMAnimatedNumber createLiveAnimatedNumber(String string, String string2, float f) {
        return this.createLiveAnimatedNumber(string, string2, f, false);
    }

    protected SVGOMAnimatedNumber createLiveAnimatedNumber(String string, String string2, float f, boolean bl) {
        SVGOMAnimatedNumber sVGOMAnimatedNumber = new SVGOMAnimatedNumber(this, string, string2, f, bl);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedNumber);
        sVGOMAnimatedNumber.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedNumber;
    }

    protected SVGOMAnimatedNumberList createLiveAnimatedNumberList(String string, String string2, String string3, boolean bl) {
        SVGOMAnimatedNumberList sVGOMAnimatedNumberList = new SVGOMAnimatedNumberList(this, string, string2, string3, bl);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedNumberList);
        sVGOMAnimatedNumberList.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedNumberList;
    }

    protected SVGOMAnimatedPoints createLiveAnimatedPoints(String string, String string2, String string3) {
        SVGOMAnimatedPoints sVGOMAnimatedPoints = new SVGOMAnimatedPoints(this, string, string2, string3);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedPoints);
        sVGOMAnimatedPoints.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedPoints;
    }

    protected SVGOMAnimatedLengthList createLiveAnimatedLengthList(String string, String string2, String string3, boolean bl, short s) {
        SVGOMAnimatedLengthList sVGOMAnimatedLengthList = new SVGOMAnimatedLengthList(this, string, string2, string3, bl, s);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedLengthList);
        sVGOMAnimatedLengthList.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedLengthList;
    }

    protected SVGOMAnimatedInteger createLiveAnimatedInteger(String string, String string2, int n) {
        SVGOMAnimatedInteger sVGOMAnimatedInteger = new SVGOMAnimatedInteger(this, string, string2, n);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedInteger);
        sVGOMAnimatedInteger.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedInteger;
    }

    protected SVGOMAnimatedEnumeration createLiveAnimatedEnumeration(String string, String string2, String[] stringArray, short s) {
        SVGOMAnimatedEnumeration sVGOMAnimatedEnumeration = new SVGOMAnimatedEnumeration(this, string, string2, stringArray, s);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedEnumeration);
        sVGOMAnimatedEnumeration.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedEnumeration;
    }

    protected SVGOMAnimatedLength createLiveAnimatedLength(String string, String string2, String string3, short s, boolean bl) {
        SVGOMAnimatedLength sVGOMAnimatedLength = new SVGOMAnimatedLength(this, string, string2, string3, s, bl);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedLength);
        sVGOMAnimatedLength.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedLength;
    }

    protected SVGOMAnimatedRect createLiveAnimatedRect(String string, String string2, String string3) {
        SVGOMAnimatedRect sVGOMAnimatedRect = new SVGOMAnimatedRect(this, string, string2, string3);
        this.liveAttributeValues.put(string, string2, sVGOMAnimatedRect);
        sVGOMAnimatedRect.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return sVGOMAnimatedRect;
    }

    public boolean hasProperty(String string) {
        AbstractStylableDocument abstractStylableDocument = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine cSSEngine = abstractStylableDocument.getCSSEngine();
        return cSSEngine.getPropertyIndex(string) != -1 || cSSEngine.getShorthandIndex(string) != -1;
    }

    public boolean hasTrait(String string, String string2) {
        return false;
    }

    public boolean isPropertyAnimatable(String string) {
        AbstractStylableDocument abstractStylableDocument = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine cSSEngine = abstractStylableDocument.getCSSEngine();
        int n = cSSEngine.getPropertyIndex(string);
        if (n != -1) {
            ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
            return valueManagerArray[n].isAnimatableProperty();
        }
        n = cSSEngine.getShorthandIndex(string);
        if (n != -1) {
            ShorthandManager[] shorthandManagerArray = cSSEngine.getShorthandManagers();
            return shorthandManagerArray[n].isAnimatableProperty();
        }
        return false;
    }

    public final boolean isAttributeAnimatable(String string, String string2) {
        DoublyIndexedTable doublyIndexedTable = this.getTraitInformationTable();
        TraitInformation traitInformation = (TraitInformation)doublyIndexedTable.get(string, string2);
        if (traitInformation != null) {
            return traitInformation.isAnimatable();
        }
        return false;
    }

    public boolean isPropertyAdditive(String string) {
        AbstractStylableDocument abstractStylableDocument = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine cSSEngine = abstractStylableDocument.getCSSEngine();
        int n = cSSEngine.getPropertyIndex(string);
        if (n != -1) {
            ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
            return valueManagerArray[n].isAdditiveProperty();
        }
        n = cSSEngine.getShorthandIndex(string);
        if (n != -1) {
            ShorthandManager[] shorthandManagerArray = cSSEngine.getShorthandManagers();
            return shorthandManagerArray[n].isAdditiveProperty();
        }
        return false;
    }

    public boolean isAttributeAdditive(String string, String string2) {
        return true;
    }

    public boolean isTraitAnimatable(String string, String string2) {
        return false;
    }

    public boolean isTraitAdditive(String string, String string2) {
        return false;
    }

    public int getPropertyType(String string) {
        AbstractStylableDocument abstractStylableDocument = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine cSSEngine = abstractStylableDocument.getCSSEngine();
        int n = cSSEngine.getPropertyIndex(string);
        if (n != -1) {
            ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
            return valueManagerArray[n].getPropertyType();
        }
        return 0;
    }

    public final int getAttributeType(String string, String string2) {
        DoublyIndexedTable doublyIndexedTable = this.getTraitInformationTable();
        TraitInformation traitInformation = (TraitInformation)doublyIndexedTable.get(string, string2);
        if (traitInformation != null) {
            return traitInformation.getType();
        }
        return 0;
    }

    public Element getElement() {
        return this;
    }

    public void updatePropertyValue(String string, AnimatableValue animatableValue) {
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        LiveAttributeValue liveAttributeValue = this.getLiveAttributeValue(string, string2);
        ((AbstractSVGAnimatedValue)liveAttributeValue).updateAnimatedValue(animatableValue);
    }

    public void updateOtherValue(String string, AnimatableValue animatableValue) {
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        LiveAttributeValue liveAttributeValue = this.getLiveAttributeValue(string, string2);
        if (!(liveAttributeValue instanceof AnimatedLiveAttributeValue)) {
            return null;
        }
        return ((AnimatedLiveAttributeValue)liveAttributeValue).getUnderlyingValue(this);
    }

    protected AnimatableValue getBaseValue(SVGAnimatedInteger sVGAnimatedInteger, SVGAnimatedInteger sVGAnimatedInteger2) {
        return new AnimatableNumberOptionalNumberValue(this, sVGAnimatedInteger.getBaseVal(), sVGAnimatedInteger2.getBaseVal());
    }

    protected AnimatableValue getBaseValue(SVGAnimatedNumber sVGAnimatedNumber, SVGAnimatedNumber sVGAnimatedNumber2) {
        return new AnimatableNumberOptionalNumberValue(this, sVGAnimatedNumber.getBaseVal(), sVGAnimatedNumber2.getBaseVal());
    }

    public short getPercentageInterpretation(String string, String string2, boolean bl) {
        if ((bl || string == null) && (string2.equals("baseline-shift") || string2.equals("font-size"))) {
            return 0;
        }
        if (!bl) {
            DoublyIndexedTable doublyIndexedTable = this.getTraitInformationTable();
            TraitInformation traitInformation = (TraitInformation)doublyIndexedTable.get(string, string2);
            if (traitInformation != null) {
                return traitInformation.getPercentageInterpretation();
            }
            return 3;
        }
        return 3;
    }

    protected final short getAttributePercentageInterpretation(String string, String string2) {
        return 3;
    }

    public boolean useLinearRGBColorInterpolation() {
        return false;
    }

    public float svgToUserSpace(float f, short s, short s2) {
        if (this.unitContext == null) {
            this.unitContext = new UnitContext();
        }
        if (s2 == 0 && s == 2) {
            return 0.0f;
        }
        return UnitProcessor.svgToUserSpace(f, s, (short)(3 - s2), this.unitContext);
    }

    public void addTargetListener(String string, String string2, boolean bl, AnimationTargetListener animationTargetListener) {
        if (!bl) {
            LinkedList<AnimationTargetListener> linkedList;
            if (this.targetListeners == null) {
                this.targetListeners = new DoublyIndexedTable();
            }
            if ((linkedList = (LinkedList<AnimationTargetListener>)this.targetListeners.get(string, string2)) == null) {
                linkedList = new LinkedList<AnimationTargetListener>();
                this.targetListeners.put(string, string2, linkedList);
            }
            linkedList.add(animationTargetListener);
        }
    }

    public void removeTargetListener(String string, String string2, boolean bl, AnimationTargetListener animationTargetListener) {
        if (!bl) {
            LinkedList linkedList = (LinkedList)this.targetListeners.get(string, string2);
            linkedList.remove(animationTargetListener);
        }
    }

    void fireBaseAttributeListeners(String string, String string2) {
        if (this.targetListeners != null) {
            LinkedList linkedList = (LinkedList)this.targetListeners.get(string, string2);
            for (AnimationTargetListener animationTargetListener : linkedList) {
                animationTargetListener.baseValueChanged(this, string, string2, false);
            }
        }
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        sVGOMElement.initializeAllLiveAttributes();
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        sVGOMElement.initializeAllLiveAttributes();
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        sVGOMElement.initializeAllLiveAttributes();
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        sVGOMElement.initializeAllLiveAttributes();
        return node;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable();
        doublyIndexedTable.put(null, "id", new TraitInformation(false, 16));
        doublyIndexedTable.put("http://www.w3.org/XML/1998/namespace", "base", new TraitInformation(false, 10));
        doublyIndexedTable.put("http://www.w3.org/XML/1998/namespace", "space", new TraitInformation(false, 15));
        doublyIndexedTable.put("http://www.w3.org/XML/1998/namespace", "id", new TraitInformation(false, 16));
        doublyIndexedTable.put("http://www.w3.org/XML/1998/namespace", "lang", new TraitInformation(false, 45));
        xmlTraitInformation = doublyIndexedTable;
    }

    protected class UnitContext
    implements UnitProcessor.Context {
        protected UnitContext() {
        }

        public Element getElement() {
            return SVGOMElement.this;
        }

        public float getPixelUnitToMillimeter() {
            return SVGOMElement.this.getSVGContext().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public float getFontSize() {
            return SVGOMElement.this.getSVGContext().getFontSize();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return SVGOMElement.this.getSVGContext().getViewportWidth();
        }

        public float getViewportHeight() {
            return SVGOMElement.this.getSVGContext().getViewportHeight();
        }
    }
}

