/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.ImageWithDetails;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.fuin.utils4j.Utils4J;

public class FileHandler {
    public static String getFileExtension(File f) {
        return FileHandler.getFileExtension(f.getName());
    }

    public static String getFileExtension(String s) {
        String[] parts = s.split("\\.");
        if (parts != null && parts.length >= 1) {
            return parts[parts.length - 1];
        }
        return "";
    }

    public static String getFilesLocation() {
        String ps = File.separator;
        if (FileHandler.class.getResource("").getFile().contains("jar!") || FileHandler.class.getResource("").getFile().contains("JAR!")) {
            String[] parts = FileHandler.class.getResource("").getFile().split("!");
            String theLocation = parts[0].replace("\\", "/");
            theLocation = theLocation.substring(0, parts[0].lastIndexOf("/"));
            theLocation = theLocation.replace("%20", " ") + ps + "files" + ps;
            try {
                URL url = new URL(theLocation);
                theLocation = url.toExternalForm();
                theLocation = theLocation.replace("file:", "");
            }
            catch (MalformedURLException murle) {
                System.err.println(murle);
                murle.printStackTrace();
            }
            theLocation = theLocation.replace("\\", File.separator);
            theLocation = theLocation.replace("/", File.separator);
            return theLocation;
        }
        String resource = ".././gamemaker/";
        String theLocation = "file:" + FileHandler.class.getResource(resource).getPath().replace("%20", " ");
        theLocation = theLocation.replace("/build/classes/gamemaker/", "/files/");
        theLocation = theLocation.replace("file:", "");
        theLocation = theLocation.replace("\\", File.separator);
        theLocation = theLocation.replace("/", File.separator);
        return theLocation;
    }

    public static ImageWithDetails imageFromFile(String location) throws IOException {
        File newFile = new File(location);
        BufferedImage theImage = ImageIO.read(newFile);
        ImageWithDetails theImageWithDetails = new ImageWithDetails(theImage);
        theImageWithDetails.setFileName(newFile.getName());
        return theImageWithDetails;
    }

    public static Image imageFromFileOnly(String location) throws IOException {
        location = location.replace("%20", " ");
        File newFile = new File(location);
        return FileHandler.imageFromFileOnly(newFile);
    }

    public static Image imageFromFileOnly(File f) throws IOException {
        BufferedImage theImage = ImageIO.read(f);
        return theImage;
    }

    public static void imageToFile(Image image, String locationAndName) throws IOException {
        BufferedImage bi = FileHandler.toBufferedImage(image);
        File outputfile = new File(locationAndName);
        ImageIO.write((RenderedImage)bi, "png", outputfile);
    }

    public static void zipDir(String fromDir, String toFile) throws IOException {
        File dirToZip = new File(fromDir);
        File zipTo = new File(toFile);
        Utils4J.zipDir((File)dirToZip, (String)"", (File)zipTo);
    }

    public static void unzipDir(String fromZip, String toDir) throws IOException {
        File zipFile = new File(fromZip);
        File targetDir = new File(toDir + File.separator);
        Utils4J.unzip((File)zipFile, (File)targetDir);
    }

    public static void createDefaultSaveDirectories() {
        String[] directories = new String[]{FileHandler.getFilesLocation() + "gamesave" + File.separator};
        for (int i = 0; i < directories.length; ++i) {
            File f = new File(directories[i]);
            f.mkdirs();
        }
    }

    public static boolean deleteDirectory(String directoryName) {
        File f = new File(directoryName);
        return FileHandler.deleteDirectory(f);
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] subdirs = directory.list();
            for (int i = 0; i < subdirs.length; ++i) {
                boolean success = FileHandler.deleteDirectory(new File(directory, subdirs[i]));
                if (success) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static BufferedImage toBufferedImage(Image image) {
        image = new ImageIcon(image).getImage();
        boolean hasTransparency = FileHandler.hasAlphaChannel(image);
        BufferedImage bufferedimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasTransparency ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bufferedimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            System.err.println(e);
        }
        Graphics2D g = bufferedimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedimage;
    }

    public static boolean hasAlphaChannel(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrab = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrab.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        return pixelGrab.getColorModel().hasAlpha();
    }
}

