/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.ImageNotSelectedException;
import gamemaker.Exceptions.PanelNotPassedException;
import gamemaker.FileHandler;
import gamemaker.GameMaps;
import gamemaker.ImageWithDetails;
import gamemaker.MapsContainer;
import gamemaker.Panels.BackgroundPanel;
import gamemaker.Panels.DialoguePanel;
import gamemaker.Panels.EventPanel;
import gamemaker.Panels.ForegroundPanel;
import gamemaker.Panels.GlassPanel;
import gamemaker.Panels.PerspectivePanel;
import gamemaker.Panels.SpritePanel;
import gamemaker.Panels.WalkableAreaPanel;
import gamemaker.Panels.XMLable;
import gamemaker.Sprite;
import gamemaker.TeleportInput;
import gamemaker.XMLSimplify;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jdom.Element;

public class GameMap
extends JLayeredPane
implements MouseListener,
MouseMotionListener,
XMLable {
    private JPanel background;
    public static final int BOTTOM_LAYER = 1;
    public static final int BACKGROUND_LAYER = 2;
    public static final int HIDE_LAYER = 3;
    public static final int EVENT_LAYER = 4;
    public static final int SPRITE_LAYER = 5;
    public static final int FOREGROUND_LAYER = 6;
    public static final int WALKABLE_LAYER = 7;
    public static final int PERSPECTIVE_LAYER = 8;
    public static final int DIALOGUE_LAYER = 9;
    public static final int GLASS_LAYER = 10;
    public static final int TASK_IDLE = 0;
    public static final int TASK_EDITWALKABLE = 1;
    public static final int TASK_ADDEVENT = 2;
    public static final int TASK_ADDFOREGROUNDITEM = 3;
    public static final int TASK_EDITFOREGROUND = 4;
    public static final int TASK_EDITPERSPECTIVE = 5;
    public static final int TASK_SETSPRITELOCATION = 6;
    public static final int TASK_PLAYING = 7;
    public static final int TASK_DIALOGUE = 8;
    public static final int TASK_SELECTTELEPORTLOCATION = 9;
    private MapsContainer containingFrame;
    private WalkableAreaPanel walkableAreaPanel;
    private BackgroundPanel backgroundPanel;
    private EventPanel eventPanel;
    private ForegroundPanel foregroundPanel;
    private GlassPanel glassPanel;
    private PerspectivePanel perspectivePanel;
    private SpritePanel spritePanel;
    private DialoguePanel dialoguePanel;
    private boolean moveForeground = false;
    private int resizeForeground = -1;
    private Coordinate resizeForgroundFrom;
    private Coordinate resizePerspectiveFrom;
    private Cursor theCursor;
    private boolean temporaryCursor = false;
    private URL musicURL;
    private Coordinate moveForegroundFrom;
    private TeleportInput teleportInput;
    private int currentTask;
    private int width;
    private int height;
    public static final int EVENT_SOUT = 1;
    public static final int EVENT_TELEPORT = 2;
    public static final int EVENT_VARIABLE = 3;
    public final int SHAPE_SQUARE = 1;
    public final int SHAPE_CIRCLE = 2;
    public final int SHAPE_AREA = 3;
    public final int EDIT_DISPLAYMODE = 0;
    public final int PLAY_DISPLAYMODE = 1;
    private int displayMode = 0;
    private GameMaps gameMaps;
    private Rectangle rect = new Rectangle(0, 0, 500, 500);

    public GameMaps getGameMaps() {
        return this.gameMaps;
    }

    public void setMapDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setMapsContainer(MapsContainer mapsc) {
        this.containingFrame = mapsc;
    }

    public GameMap(MapsContainer frame, Sprite sprite, GameMaps maps) {
        this.containingFrame = frame;
        this.currentTask = 0;
        this.gameMaps = maps;
        this.addMouseMotionListener(this);
        this.width = 800;
        this.height = 600;
        this.walkableAreaPanel = new WalkableAreaPanel();
        this.backgroundPanel = new BackgroundPanel(this);
        this.eventPanel = new EventPanel(this, maps);
        this.dialoguePanel = new DialoguePanel(this);
        try {
            this.spritePanel = new SpritePanel(sprite, this);
        }
        catch (IOException ioe) {
            System.err.println(ioe + ". Sprite panel io error.");
        }
        try {
            this.perspectivePanel = new PerspectivePanel(this.spritePanel);
        }
        catch (IOException ioe) {
            System.err.println(ioe + ". perspective panel io error.");
        }
        this.glassPanel = new GlassPanel();
        this.foregroundPanel = new ForegroundPanel(this, this.glassPanel);
        this.glassPanel.addAssociation(this.foregroundPanel);
        this.setAndAddLayers();
        this.setBackground(new Color(0, 0, 0));
        this.updateSizeOfAll();
        this.addMouseListener(this);
        this.spritePanel.setEventPanel(this.eventPanel);
        this.eventPanel.setDialoguePanel(this.dialoguePanel);
    }

    public void setFocusOnSprite(Coordinate c, MapsContainer cont) {
    }

    public void setFocusOnSprite(Point c, MapsContainer cont) {
    }

    public void superRepaint() {
        this.walkableAreaPanel.repaint();
        this.backgroundPanel.repaint();
        this.eventPanel.repaint();
        this.foregroundPanel.repaint();
        this.glassPanel.repaint();
        this.perspectivePanel.repaint();
        this.spritePanel.repaint();
        this.dialoguePanel.repaint();
        this.repaint();
    }

    public void saveImages() throws IOException {
        this.saveImages(FileHandler.getFilesLocation());
    }

    public void saveImages(String location) throws IOException {
        this.getBackgroundPanel().saveImage(location);
        this.getForegroundPanel().saveImages(location);
    }

    public void setMusic(URL musicFileURL) {
        this.musicURL = musicFileURL;
    }

    public URL getMusicURL() {
        return this.musicURL;
    }

    public ForegroundPanel getForegroundPanel() {
        return this.foregroundPanel;
    }

    public GlassPanel getGlassPanel() {
        return this.glassPanel;
    }

    public PerspectivePanel getPerspectivePanel() {
        return this.perspectivePanel;
    }

    public BackgroundPanel getBackgroundPanel() {
        return this.backgroundPanel;
    }

    public SpritePanel getSpritePanel() {
        return this.spritePanel;
    }

    public WalkableAreaPanel getWalkableAreaPanel() {
        return this.walkableAreaPanel;
    }

    public DialoguePanel getDialoguePanel() {
        return this.dialoguePanel;
    }

    public EventPanel getEventPanel() {
        return this.eventPanel;
    }

    private void setAndAddLayers() {
        this.add((Component)this.backgroundPanel, 1);
        this.add((Component)this.foregroundPanel, 1);
        this.add((Component)this.spritePanel, 1);
        if (this.displayMode == 0) {
            this.add((Component)this.walkableAreaPanel, 1);
            this.add((Component)this.eventPanel, 1);
            this.add((Component)this.glassPanel, 1);
            this.add((Component)this.perspectivePanel, 1);
        } else if (this.displayMode == 1) {
            this.add(this.dialoguePanel);
        }
        this.setLayer(this.backgroundPanel, 2);
        this.setLayer(this.spritePanel, 5);
        this.setLayer(this.foregroundPanel, 6);
        if (this.displayMode == 0) {
            this.setLayer(this.walkableAreaPanel, 7);
            this.setLayer(this.eventPanel, 4);
            this.setLayer(this.perspectivePanel, 8);
            this.setLayer(this.glassPanel, 10);
        } else if (this.displayMode == 1) {
            this.setLayer(this.dialoguePanel, 9);
        }
    }

    public void toggleDialogue() {
        if (this.currentTask == 8) {
            this.dialoguePanel.setDialogueOn(false);
            this.currentTask = 7;
        } else {
            this.currentTask = 8;
            this.dialoguePanel.setDialogueOn(true);
        }
    }

    public void setDialogue(boolean onOff) {
        if (this.currentTask == 8 && !onOff) {
            this.dialoguePanel.setDialogueOn(false);
            this.currentTask = 7;
        } else if (!onOff && this.currentTask == 7) {
            this.currentTask = 8;
            this.dialoguePanel.setDialogueOn(true);
        }
    }

    public void action() throws PanelNotPassedException {
        if (this.currentTask == 7) {
            this.eventPanel.triggerActionEventAtPoint(this.spritePanel.getSprite().getSpritePosition());
        } else if (this.currentTask == 8) {
            this.toggleDialogue();
            this.dialoguePanel.action();
        }
    }

    public void setCurrentTask(int taskCode) {
        this.currentTask = taskCode;
    }

    public void setPlayMode() {
        this.removeAll();
        this.getClass();
        this.displayMode = 1;
        this.setAndAddLayers();
        this.currentTask = 7;
        this.containingFrame.setCursorNormal();
    }

    public void setEditMode() {
        this.removeAll();
        this.displayMode = this.EDIT_DISPLAYMODE;
        this.setAndAddLayers();
        this.currentTask = 0;
        this.containingFrame.setCursorNormal();
    }

    public void setEventCreator(int eventCode) {
        if (eventCode == 1) {
            this.eventPanel.getClass();
            this.eventPanel.setEventType(1);
        } else if (eventCode == 2) {
            this.eventPanel.getClass();
            this.eventPanel.setEventType(2);
        } else if (eventCode == 3) {
            this.eventPanel.getClass();
            this.eventPanel.setEventType(3);
        }
    }

    public int getEventCreator() {
        int type = this.eventPanel.getEventType();
        this.eventPanel.getClass();
        if (type == 1) {
            type = 1;
        } else {
            this.eventPanel.getClass();
            if (type == 1) {
                type = 2;
            } else {
                this.eventPanel.getClass();
                if (type == 1) {
                    type = 3;
                }
            }
        }
        return type;
    }

    public void setTeleportLocation(TeleportInput teleportInput) {
        this.teleportInput = teleportInput;
        this.currentTask = 9;
    }

    public void unsetTeleportLocation() {
        this.currentTask = 2;
    }

    public Image getBackgroundImageThumb() {
        return this.backgroundPanel.getBackgroundImageThumb();
    }

    public int getEventCreatorShape() {
        int code = this.eventPanel.getEventShapeMode();
        this.eventPanel.getClass();
        if (code == 2) {
            code = 1;
        } else {
            this.eventPanel.getClass();
            if (code == 3) {
                code = 2;
            } else {
                this.eventPanel.getClass();
                if (code == 1) {
                    code = 3;
                }
            }
        }
        return code;
    }

    public void setEventCreatorShape(int shapeCode) {
        if (shapeCode == 1) {
            this.eventPanel.getClass();
            this.eventPanel.setDrawMode(2);
        } else if (shapeCode == 2) {
            this.eventPanel.getClass();
            this.eventPanel.setDrawMode(3);
        } else if (shapeCode == 3) {
            this.eventPanel.getClass();
            this.eventPanel.setDrawMode(1);
        }
    }

    public MapsContainer getMapContainer() {
        return this.containingFrame;
    }

    public void updateSizeOfAll() {
        this.walkableAreaPanel.setBounds(0, 0, this.width, this.height);
        Dimension newSize = new Dimension(this.width, this.height);
        this.walkableAreaPanel.setPreferredSize(newSize);
        this.backgroundPanel.setBounds(0, 0, this.width, this.height);
        this.backgroundPanel.setPreferredSize(newSize);
        this.eventPanel.setBounds(0, 0, this.width, this.height);
        this.eventPanel.setPreferredSize(newSize);
        this.foregroundPanel.setBounds(0, 0, this.width, this.height);
        this.foregroundPanel.setPreferredSize(newSize);
        this.perspectivePanel.setBounds(0, 0, this.width, this.height);
        this.perspectivePanel.setPreferredSize(newSize);
        this.spritePanel.setBounds(0, 0, this.width, this.height);
        this.spritePanel.getPerspective().setLogicalHeight(this.height);
        this.dialoguePanel.setBounds(0, 0, this.width, this.height);
        this.dialoguePanel.setPreferredSize(newSize);
        this.perspectivePanel.getPerspective().setLogicalHeight(this.height);
        this.glassPanel.setBounds(0, 0, this.width, this.height);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setBounds(new Rectangle(0, 0, this.width, this.height));
        this.containingFrame.repaint();
        this.repaint();
        this.setVisible(true);
        this.setEnabled(true);
        this.setOpaque(true);
    }

    public void setBackgroundImageDefault() {
        this.setBackgroundImage("maps/default.png");
    }

    public void setBackgroundImage(String fileLocation) {
        try {
            File f = new File(FileHandler.getFilesLocation() + fileLocation);
            ImageWithDetails theImage = new ImageWithDetails(ImageIO.read(f));
            theImage.setFileName(f.getName());
            if (theImage != null) {
                this.backgroundPanel.setImage(theImage);
                this.width = this.backgroundPanel.getWidth();
                this.height = this.backgroundPanel.getHeight();
                this.updateSizeOfAll();
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    public void setBackgroundImage() {
        this.setIdle();
        try {
            ImageWithDetails theImage = this.containingFrame.getImageChooser();
            if (theImage != null) {
                this.backgroundPanel.setImage(theImage);
                this.width = this.backgroundPanel.getWidth();
                this.height = this.backgroundPanel.getHeight();
                this.updateSizeOfAll();
            }
        }
        catch (IOException ioe) {
            System.err.println(".getNewImage() io error" + ioe);
        }
        catch (ImageNotSelectedException inse) {
            System.err.println("No image was selected" + inse);
        }
    }

    public void editPerspective() {
        if (this.currentTask == 5) {
            this.setIdle();
            this.perspectivePanel.setIsPanelOn(false);
        } else {
            this.setIdle();
            this.currentTask = 5;
            this.containingFrame.setCursorCrosshair();
            this.perspectivePanel.setIsPanelOn(true);
        }
        this.repaint();
    }

    public void setStartLocation() {
        if (this.currentTask == 0) {
            this.currentTask = 6;
            this.containingFrame.setCursorCrosshair();
        } else if (this.currentTask == 6) {
            this.setIdle();
        }
        this.repaint();
    }

    public void editWalkable() {
        if (this.currentTask == 1) {
            this.setIdle();
        } else {
            this.setIdle();
            this.currentTask = 1;
            this.containingFrame.setCursorCrosshair();
        }
    }

    public void editEvents() {
        if (this.currentTask == 2) {
            this.setIdle();
        } else {
            this.setIdle();
            this.currentTask = 2;
            this.containingFrame.setCursorCrosshair();
        }
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public void editForeground() {
        if (this.currentTask == 4) {
            this.setIdle();
        } else {
            this.setIdle();
            this.currentTask = 4;
            this.containingFrame.setCursorCrosshair();
        }
    }

    public void addForeground() {
        if (this.currentTask == 3) {
            this.setIdle();
        } else {
            this.setIdle();
            this.currentTask = 3;
            this.containingFrame.setCursorCrosshair();
        }
    }

    public void setIdle() {
        if (this.currentTask == 5) {
            this.perspectivePanel.setIsPanelOn(false);
        } else if (this.currentTask == 1) {
            this.walkableAreaPanel.setCurrentComplete();
            this.walkableAreaPanel.repaint();
        } else if (this.currentTask == 2) {
            this.eventPanel.setCurrentAreaComplete();
            this.eventPanel.repaint();
        }
        this.foregroundPanel.deSelectAll();
        this.foregroundPanel.repaint();
        this.currentTask = 0;
        this.containingFrame.setCursorNormal();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Coordinate here = new Coordinate((int)e.getPoint().getX(), (int)e.getPoint().getY());
        if (this.currentTask == 9) {
            if (e.getButton() == 1) {
                this.teleportInput.setCoordinate(here);
            }
        } else if (this.currentTask == 5) {
            if (e.getButton() == 1) {
                this.perspectivePanel.changePerspective(here.getPoint(), here.getPoint());
                this.resizePerspectiveFrom = here;
            }
            if (e.getButton() == 3) {
                this.perspectivePanel.setHorizon(e.getPoint());
            }
            if (e.getButton() == 2) {
                this.editPerspective();
            }
        } else if (this.currentTask == 6) {
            if (e.getButton() == 1) {
                this.gameMaps.setDefaultSpriteLocation(new Coordinate(e.getPoint()));
                this.spritePanel.repaint();
            }
            if (e.getButton() == 2) {
                this.setStartLocation();
            }
        } else if (this.currentTask == 3) {
            if (e.getButton() == 1) {
                try {
                    ImageWithDetails theImage = this.containingFrame.getImageChooser();
                    if (theImage != null) {
                        this.foregroundPanel.addImage(new Coordinate(e.getX(), e.getY()), theImage);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("add foreground image. " + ioe);
                }
                catch (ImageNotSelectedException inse) {
                    System.err.println("add foreground image. " + inse);
                }
            }
            if (e.getButton() == 2) {
                this.currentTask = 0;
                this.foregroundPanel.deSelectAll();
                this.containingFrame.setCursorNormal();
            }
            if (e.getButton() == 3) {
                this.foregroundPanel.removeImage(here);
                this.foregroundPanel.repaint();
            }
        } else if (this.currentTask == 4) {
            if (e.getButton() == 1) {
                boolean itemSelected = this.foregroundPanel.select(new Coordinate(e.getX(), e.getY()));
                this.repaint();
                this.moveForegroundFrom = new Coordinate(e.getX(), e.getY());
                if (itemSelected && this.foregroundPanel.checkSelectedResizer(here) == -1) {
                    this.moveForeground = true;
                }
                if (itemSelected) {
                    this.resizeForeground = this.foregroundPanel.checkSelectedResizer(here);
                    this.resizeForgroundFrom = here;
                }
                this.foregroundPanel.repaint();
            }
            if (e.getButton() == 2) {
                this.currentTask = 0;
                this.foregroundPanel.deSelectAll();
                this.glassPanel.repaint();
                this.containingFrame.setCursorNormal();
            }
            if (e.getButton() == 3) {
                this.foregroundPanel.removeImage(here);
                this.foregroundPanel.repaint();
            }
        } else if (this.currentTask == 2) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    this.eventPanel.setCurrentAreaComplete();
                } else if (this.eventPanel.isAreaComplete()) {
                    this.eventPanel.addEvent(new Coordinate(e.getX(), e.getY()));
                } else {
                    this.eventPanel.addPoint(new Coordinate(e.getX(), e.getY()));
                }
            }
            if (e.getButton() == 2) {
                this.currentTask = 0;
                this.walkableAreaPanel.setCurrentComplete();
                this.eventPanel.setCurrentAreaComplete();
                this.containingFrame.setCursorNormal();
            }
            if (e.getButton() == 3) {
                this.eventPanel.removeEvent(new Coordinate(e.getX(), e.getY()));
            }
            this.eventPanel.repaint();
        } else if (this.currentTask == 1) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    this.walkableAreaPanel.setCurrentComplete();
                } else {
                    this.walkableAreaPanel.addPoint(new Coordinate(e.getX(), e.getY()));
                }
            }
            if (e.getButton() == 3) {
                this.walkableAreaPanel.deleteShapeAtPoint(new Coordinate(e.getX(), e.getY()));
            }
            if (e.getButton() == 2) {
                this.currentTask = 0;
                this.walkableAreaPanel.setCurrentComplete();
                this.containingFrame.setCursorNormal();
            }
            this.walkableAreaPanel.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.resizeForeground > -1) {
            this.foregroundPanel.setFinishResize();
            this.resizeForeground = -1;
        }
        if (this.currentTask == 2) {
            this.eventPanel.setShapeComplete();
            this.eventPanel.repaint();
        }
        this.moveForeground = false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent me) {
        int found;
        if (this.temporaryCursor) {
            this.temporaryCursor = false;
            this.containingFrame.setCursor(this.theCursor);
        }
        if (this.currentTask == 1) {
            this.walkableAreaPanel.setLastMousePosition((int)me.getPoint().getX(), (int)me.getPoint().getY());
            if (!this.walkableAreaPanel.isShapeInProgress()) {
                this.walkableAreaPanel.repaint();
            }
        } else if (this.currentTask == 2) {
            this.eventPanel.setLastMousePosition((int)me.getPoint().getX(), (int)me.getPoint().getY());
            if (!this.eventPanel.isAreaInProgress()) {
                this.eventPanel.repaint();
            }
        } else if (this.currentTask == 4 && this.foregroundPanel.getSelectedItem() > -1 && (found = this.foregroundPanel.checkSelectedResizer(new Coordinate((int)me.getPoint().getX(), (int)me.getPoint().getY()))) > -1) {
            if (!this.temporaryCursor) {
                this.theCursor = this.containingFrame.getCursor();
            }
            if (found == 0) {
                this.containingFrame.setCursor(new Cursor(6));
            } else if (found == 1) {
                this.containingFrame.setCursor(new Cursor(7));
            } else if (found == 2) {
                this.containingFrame.setCursor(new Cursor(4));
            } else if (found == 3) {
                this.containingFrame.setCursor(new Cursor(5));
            }
            this.temporaryCursor = true;
        }
    }

    public void mouseDragged(MouseEvent me) {
        Coordinate here = new Coordinate((int)me.getPoint().getX(), (int)me.getPoint().getY());
        if (this.currentTask == 2) {
            this.eventPanel.setCurrentShapeDiameter(here);
            this.eventPanel.repaint();
        }
        if (this.currentTask == 5) {
            if (this.resizePerspectiveFrom != null) {
                this.perspectivePanel.changePerspective(this.resizePerspectiveFrom.getPoint(), here.getPoint());
                this.perspectivePanel.repaint();
            }
        } else if (this.currentTask == 4) {
            if (this.moveForeground && this.moveForegroundFrom != null) {
                this.foregroundPanel.moveSelected(this.moveForegroundFrom, here);
            }
            if (this.resizeForeground != -1 && this.resizeForeground <= 3) {
                this.foregroundPanel.resizeSelected(this.resizeForeground, this.resizeForgroundFrom, here);
                this.glassPanel.repaint();
            }
        }
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        this.getPerspectivePanel().fromXML(XMLSimplify.getStrictlySingleElement(rootElement, "perspective"));
        this.getForegroundPanel().fromXML(XMLSimplify.getStrictlySingleElement(rootElement, "foreground"));
        this.getBackgroundPanel().fromXML(XMLSimplify.getStrictlySingleElement(rootElement, "background"));
        this.getWalkableAreaPanel().fromXML(XMLSimplify.getStrictlySingleElement(rootElement, "walkover"));
        this.getEventPanel().fromXML(XMLSimplify.getStrictlySingleElement(rootElement, "events"));
    }

    public String toXML() {
        return this.toXML("<gamemap id=\"needtospecify\">", "</gamemap>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + this.perspectivePanel.toXML();
        xml = xml + this.foregroundPanel.toXML();
        xml = xml + this.backgroundPanel.toXML();
        xml = xml + this.walkableAreaPanel.toXML();
        xml = xml + this.eventPanel.toXML();
        xml = xml + closeTag + "\n";
        return xml;
    }
}

