/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.MapsContainer;
import gamemaker.PaintPanel;
import gamemaker.Panels.XMLable;
import gamemaker.Sprite;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class GameMaps
implements XMLable {
    private ArrayList<GameMap> maps = new ArrayList();
    private int currentMap;
    private MapsContainer mapContainer;
    private Sprite gameSprite;
    private boolean enableConditionalEvents = false;
    private PaintPanel paintPanel;

    public void setEventsConditional(boolean status) {
        this.enableConditionalEvents = status;
    }

    public boolean getEventsConditional() {
        return this.enableConditionalEvents;
    }

    public GameMaps(MapsContainer r) {
        this.setMapsContainer(r);
        this.gameSprite = new Sprite();
        this.currentMap = 0;
        this.addNewMap();
        this.gameSprite.setCurrentGameMap(this.getCurrentMap());
        this.paintPanel = new PaintPanel(this);
    }

    public PaintPanel getPaintPanel() {
        return this.paintPanel;
    }

    public boolean isPaintPanelSet() {
        return this.paintPanel != null;
    }

    public void setMapsContainer(MapsContainer r) {
        this.mapContainer = r;
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).setMapsContainer(r);
        }
    }

    public void removeEventReferences(int mapIndex) {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).getEventPanel().deleteEvents(mapIndex);
        }
    }

    public void removeMap(int index) {
        this.removeEventReferences(index);
        this.maps.remove(index);
        --this.currentMap;
        if (this.getSprite().getCurrentMap() == index) {
            this.getSprite().setCurrentGameMap(this.maps.get(0));
            this.getSprite().setCurrentMap(0);
            this.getSprite().setSpritePosition(new Point(200, 200));
        }
    }

    public void removeCurrentMap() {
        if (this.maps.size() >= 2 && this.currentMap >= 0) {
            this.removeMap(this.currentMap);
            this.currentMap = this.maps.size() - 1;
        }
    }

    public void saveImages() throws IOException {
        this.saveImages(FileHandler.getFilesLocation());
    }

    public void saveImages(String location) throws IOException {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).saveImages(location + "gamesave" + File.separator);
        }
    }

    public MapsContainer getMapsContainer() {
        return this.mapContainer;
    }

    public Sprite getSprite() {
        return this.gameSprite;
    }

    public void setDefaultSpriteLocation(Coordinate c) {
        this.gameSprite.setStartPosition(this.getCurrentMap(), this.getCurrentMapIndex(), c.getPoint());
    }

    public void setCurrentMap(int index) {
        if (index <= this.maps.size() - 1 && index > -1) {
            this.currentMap = index;
            this.paintPanel.setSize(this.getCurrentMap().getBackgroundPanel().getSize());
            this.paintPanel.setPreferredSize(this.getCurrentMap().getBackgroundPanel().getSize());
            this.paintPanel.updateImage();
        } else {
            System.err.println("GameMaps Error, index out of range");
        }
    }

    public int getCurrentMapIndex() {
        if (this.currentMap >= this.maps.size()) {
            this.currentMap = -1;
        }
        return this.currentMap;
    }

    public GameMap getCurrentMap() {
        if (this.maps.size() > 0) {
            return this.maps.get(this.getCurrentMapIndex());
        }
        return null;
    }

    public int size() {
        return this.maps.size();
    }

    public GameMap getMap(int i) {
        return this.maps.get(i);
    }

    public void addNewMap() {
        GameMap newMap = new GameMap(this.mapContainer, this.gameSprite, this);
        newMap.setBackgroundImageDefault();
        this.maps.add(newMap);
        this.currentMap = this.maps.size() - 1;
    }

    public void repaint() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).repaint();
        }
    }

    public void superRepaint() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).superRepaint();
        }
    }

    public void clearAllMarkers() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).getGlassPanel().clearMarker();
        }
    }

    public void repaintImmediately() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).paintImmediately(0, 0, this.maps.get(i).getWidth(), this.maps.get(i).getHeight());
        }
    }

    public void setPlayMode() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).setPlayMode();
        }
    }

    public void setEditMode() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.get(i).setEditMode();
        }
    }

    public String toXML() {
        return this.toXML("<game>", "</game>");
    }

    public void removeAllMaps() {
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.remove(i);
        }
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        this.removeAllMaps();
        List sprite = rootElement.getChildren("sprite");
        if (sprite.size() > 1) {
            throw new GameXmlIncorrectException("Game XML must define only one sprite.");
        }
        if (sprite.size() < 1) {
            throw new GameXmlIncorrectException("Game XML must define a sprite");
        }
        this.getSprite().fromXML((Element)sprite.get(0));
        List elements = rootElement.getChildren("gamemap");
        for (int i = 0; i < elements.size(); ++i) {
            this.addNewMap();
            this.maps.get(i).fromXML((Element)elements.get(i));
        }
        this.gameSprite.setCurrentGameMap(this.maps.get(this.gameSprite.getCurrentMap()));
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = xml + "\n" + openTag + "\n";
        xml = xml + this.getSprite().toXML();
        xml = xml + "\n";
        for (int i = 0; i < this.maps.size(); ++i) {
            xml = xml + this.maps.get(i).toXML("<gamemap id=\"" + i + "\">", "</gamemap>");
        }
        xml = xml + closeTag + "\n";
        return xml;
    }
}

