/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.FileHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyFileFilter
extends FileFilter {
    private ArrayList<String> acceptedExtensions;
    private String description = "";

    public MyFileFilter(String acceptedExtension, String description) {
        this.acceptedExtensions = new ArrayList(20);
        this.acceptedExtensions.add(acceptedExtension);
        this.description = description;
    }

    public MyFileFilter(String[] acceptedExtensions, String description) {
        this.acceptedExtensions = new ArrayList<String>(Arrays.asList(acceptedExtensions));
        this.description = description;
    }

    public MyFileFilter(ArrayList<String> acceptedExtensions, String description) {
        this.acceptedExtensions = acceptedExtensions;
        this.description = description;
    }

    public MyFileFilter() {
        this.acceptedExtensions = new ArrayList(20);
        this.acceptedExtensions.add("jpg");
        this.acceptedExtensions.add("jpeg");
        this.acceptedExtensions.add("png");
        this.acceptedExtensions.add("gif");
        this.description = "Images (.jpeg, .jpg, .png, .gif)";
    }

    @Override
    public boolean accept(File f) {
        boolean accept = false;
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileHandler.getFileExtension(f);
        if (!extension.equals("")) {
            for (int i = 0; i < this.acceptedExtensions.size() && !accept; ++i) {
                if (!extension.equals(this.acceptedExtensions.get(i).toLowerCase())) continue;
                accept = true;
            }
        }
        return accept;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

