/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.Panels.GlassPaneDrawer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.JPanel;

public class GlassPanel
extends JPanel {
    private ArrayList<GlassPaneDrawer> panels;
    private Image marker;
    private Coordinate markerPlace;

    public GlassPanel() {
        this.setOpaque(false);
        this.panels = new ArrayList(10);
    }

    public void addAssociation(GlassPaneDrawer panel) {
        if (!this.panels.contains(panel)) {
            this.panels.add(panel);
        }
    }

    public void setMarker(Image i) {
        this.marker = i;
    }

    public void setMarker(Image i, Coordinate c) {
        this.marker = i;
        this.markerPlace = c;
    }

    public void setMarkerPosition(Coordinate c) {
        this.markerPlace = c;
    }

    public void clearMarker() {
        this.markerPlace = null;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.marker != null && this.markerPlace != null) {
            g2.drawImage(this.marker, this.markerPlace.getX() - this.marker.getWidth(this) / 2, this.markerPlace.getY() - this.marker.getHeight(this), this);
        }
        if (this.panels.size() > 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                this.panels.get(i).drawOnGlass(g2);
            }
        }
    }
}

