/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.SpriteNotSetException;
import gamemaker.Panels.GamePanel;
import gamemaker.Panels.SpritePanel;
import gamemaker.Panels.XMLable;
import gamemaker.Perspective;
import gamemaker.Sprite;
import gamemaker.XMLSimplify;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jdom.Element;

public class PerspectivePanel
extends GamePanel
implements XMLable {
    private Image frontSpriteImage;
    private Image backSpriteImage;
    private Image middleSprite;
    private Sprite sprite;
    private double tempPercentage;
    private boolean panelOn = false;
    private Perspective perspective = new Perspective();
    private SpritePanel spritePanel;

    public PerspectivePanel(SpritePanel spritePanel) throws IOException {
        this.sprite = spritePanel.getSprite();
        this.panelOn = false;
        this.setOpaque(false);
        this.perspective = new Perspective();
        this.spritePanel = spritePanel;
        this.setSprites();
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public void setIsPanelOn(boolean state) {
        this.panelOn = state;
    }

    public void changePerspective(Point from, Point to) {
        double widthChange = from.getX() - to.getX();
        double percentageChange = Math.abs(widthChange / this.perspective.getStandardSpriteWidth());
        if (from.getY() < this.perspective.getHorizon()) {
            this.perspective.setBackPercentage(1.0 * percentageChange);
        } else {
            this.perspective.setFrontPercentage(1.0 * percentageChange);
        }
        this.spritePanel.setPerspective(this.perspective);
        this.setSprites();
    }

    public void setSprites() {
        try {
            this.backSpriteImage = this.sprite.getSpriteImage(new Point(0 + (int)this.perspective.getHorizon(), 0), this.perspective);
            int midpoint = (int)(this.perspective.getHorizon() + ((double)this.getHeight() - this.perspective.getHorizon()) / 2.0);
            this.middleSprite = this.sprite.getSpriteImage(new Point(this.getHeight(), midpoint), this.perspective);
            this.frontSpriteImage = this.sprite.getSpriteImage(new Point(this.getHeight(), this.getHeight()), this.perspective);
        }
        catch (SpriteNotSetException snse) {
            System.err.println(snse);
        }
    }

    public void setHorizon(Coordinate c) {
        this.perspective.setHorizon(c.getY());
    }

    public void setHorizon(Point p) {
        this.perspective.setHorizon((int)p.getY());
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        double front = XMLSimplify.getXMLDouble(rootElement, "front");
        double back = XMLSimplify.getXMLDouble(rootElement, "back");
        double horizon = XMLSimplify.getXMLDouble(rootElement, "horizon");
        this.getPerspective().setFrontPercentage(front);
        this.getPerspective().setBackPercentage(back);
        this.getPerspective().setHorizon((int)Math.round(horizon));
        this.spritePanel.setPerspective(this.perspective);
    }

    public String toXML() {
        return this.toXML("", "");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "";
        xml = xml + this.perspective.toXML();
        xml = xml + closeTag + "";
        return xml;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.panelOn) {
            this.getHeight();
            this.setSprites();
            Rectangle2D.Double top = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.perspective.getHorizon());
            Rectangle2D.Double bottom = new Rectangle2D.Double(0.0, 0.0 + this.perspective.getHorizon(), this.getWidth(), (double)this.getHeight() - this.perspective.getHorizon());
            g2.setColor(new Color(183, 201, 255, 100));
            g2.fill(top);
            g2.setColor(new Color(201, 255, 140, 100));
            g2.fill(bottom);
            g2.setColor(Color.red);
            g2.drawLine(0, (int)this.perspective.getHorizon() - 1, this.getWidth(), (int)(this.perspective.getHorizon() - 1.0));
            g2.setFont(new Font("Arial", 0, 20));
            g2.drawString("Horizon", 40, (int)this.perspective.getHorizon() - 3);
            int drawX = this.getWidth() / 2 - this.backSpriteImage.getWidth(this) / 2;
            int drawY = 0 - this.backSpriteImage.getHeight(this);
            g2.drawImage(this.backSpriteImage, drawX, drawY + (int)this.perspective.getHorizon(), this);
            drawX = this.getWidth() / 2 - this.middleSprite.getWidth(this) / 2;
            int midpoint = (int)(this.perspective.getHorizon() + ((double)this.getHeight() - this.perspective.getHorizon()) / 2.0);
            drawY = midpoint - this.middleSprite.getHeight(this);
            g2.drawImage(this.middleSprite, drawX, drawY, this);
            drawX = this.getWidth() / 2 - this.frontSpriteImage.getWidth(this) / 2;
            drawY = this.getHeight() - this.frontSpriteImage.getHeight(this);
            g2.drawImage(this.frontSpriteImage, drawX, drawY, this);
        }
    }
}

