/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.RightPanels;

import gamemaker.GameMaps;
import gamemaker.ImageList;
import gamemaker.events.ListActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MapList_RightPanel
extends JPanel {
    private GameMaps maps;
    private ImageList theList;
    private ListActionListener actList;

    public MapList_RightPanel(GameMaps maps, ListActionListener actList) {
        this.maps = maps;
        this.actList = actList;
        this.setUpPanel();
    }

    public ImageList getList() {
        return this.theList;
    }

    public void setUpPanel() {
        this.generateList();
        this.setLayout(new BorderLayout());
        JButton hideButton = new JButton(">>");
        hideButton.setActionCommand("hide_panel");
        hideButton.addActionListener(this.actList);
        this.add((Component)hideButton, "North");
        this.add((Component)this.theList.getListScrollPanel(), "Center");
        this.theList.addListSelectionListener(this.actList);
        this.theList.repaint();
        this.setVisible(true);
        this.repaint();
    }

    public void generateList() {
        this.removeAll();
        this.theList = new ImageList(this.maps);
        for (int i = 0; i < this.maps.size(); ++i) {
            if (this.maps.getMap(i).getBackgroundImageThumb() != null) {
                JLabel imageLabel = new JLabel(new ImageIcon(this.maps.getMap(i).getBackgroundImageThumb()));
                this.theList.addListItem(imageLabel);
                this.theList.addComponentToLastListItem(new JLabel("Map ID: " + i));
                continue;
            }
            this.theList.addListItem(new JLabel("Map ID: " + i));
        }
        if (this.maps.getCurrentMapIndex() >= 0) {
            this.theList.setSelectedIndex(this.maps.getCurrentMapIndex());
        }
    }
}

