/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.RightPanels;

import gamemaker.Ribbon;
import gamemaker.RightPanels.Hidden_RightPanel;
import gamemaker.RightPanels.MapList_RightPanel;
import gamemaker.events.ListActionListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class RightPanel
extends JScrollPane
implements ListActionListener {
    private MapList_RightPanel mapsPanel;
    private Hidden_RightPanel hiddenPanel;
    private Ribbon mainRibbon;
    private boolean hidden = false;
    private final int CONTENT_SCROLL_WIDTH = 203;
    private final int CONTENT_PANEL_WIDTH = 200;

    public RightPanel(Ribbon r) {
        this.mainRibbon = r;
        this.mapsPanel = new MapList_RightPanel(this.mainRibbon.getGameMaps(), this);
        this.add(this.mapsPanel);
        this.setPreferredSize(new Dimension(203, 200));
        this.mapsPanel.setPreferredSize(new Dimension(200, 200));
        this.setViewportView(this.mapsPanel);
        this.hiddenPanel = new Hidden_RightPanel(this);
        this.setVisible(true);
        this.repaint();
    }

    public void updatePanelData() {
        if (this.hiddenPanel != null) {
            this.hiddenPanel.repaint();
            this.hiddenPanel.updateUI();
        }
        if (this.mapsPanel != null) {
            this.mapsPanel.setUpPanel();
            this.mapsPanel.repaint();
            this.mapsPanel.updateUI();
            this.repaint();
            this.mainRibbon.repaint();
        }
        this.updateUI();
    }

    public boolean isMinimised() {
        return this.hidden;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("expand_panel")) {
            this.remove(this.hiddenPanel);
            this.add(this.mapsPanel);
            Dimension d = new Dimension((int)this.mapsPanel.getPreferredSize().getWidth() + 3, (int)this.mapsPanel.getPreferredSize().getHeight());
            this.setPreferredSize(d);
            this.setViewportView(this.mapsPanel);
            this.mapsPanel.repaint();
            this.mainRibbon.updatePreferredSizes();
            this.hidden = false;
        } else if (e.getActionCommand().equals("hide_panel")) {
            this.remove(this.mapsPanel);
            this.add(this.hiddenPanel);
            this.setViewportView(this.hiddenPanel);
            this.setPreferredSize(this.hiddenPanel.getRecommendedContainerSize());
            this.mainRibbon.repaint();
            this.hiddenPanel.updateUI();
            this.hiddenPanel.repaint();
            this.updateUI();
            this.mainRibbon.updatePreferredSizes();
            this.hidden = true;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.mapsPanel != null && this.mapsPanel.getList().getSelectedIndex() >= 0) {
            int shape = this.mainRibbon.getGameMaps().getCurrentMap().getEventCreatorShape();
            this.mainRibbon.getGameMaps().getCurrentMap().setIdle();
            this.mainRibbon.getGameMaps().setCurrentMap(this.mapsPanel.getList().getSelectedIndex());
            this.mainRibbon.repaint();
            this.mainRibbon.getGameMaps().getCurrentMap().setEventCreatorShape(shape);
            this.mainRibbon.deselectEventButtons();
        }
    }
}

