/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Exceptions.IllegalReferenceValueException;
import gamemaker.GameMaps;
import gamemaker.NumberFunctions;
import gamemaker.ScreenFunctions;
import gamemaker.events.EventCondition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VariableConditionInput
implements ActionListener {
    private JDialog theDialog = new JDialog();
    private GameMaps maps;
    private JComboBox var1;
    private JComboBox var2;
    private ButtonGroup conditionGroup;
    private ButtonGroup relianceGroup;
    private JTextField valueField;
    private EventCondition eventCondition;

    public VariableConditionInput() {
        this.theDialog.setTitle("Condition");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        int x = 220;
        int y = 200;
        this.theDialog.setSize(x, y);
        this.theDialog.setMinimumSize(new Dimension(x, y));
        this.theDialog.setMaximumSize(new Dimension(x, y));
        this.theDialog.setLocation(ScreenFunctions.getScreenCentre(this.theDialog));
        JPanel topPanel = new JPanel();
        JPanel middlePanel = new JPanel();
        JPanel signPanel = new JPanel();
        JPanel reliancePanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        FlowLayout flowCenter = new FlowLayout();
        FlowLayout flowRight = new FlowLayout();
        GridLayout gridLayout = new GridLayout(0, 3);
        flowCenter.setAlignment(1);
        flowRight.setAlignment(2);
        this.theDialog.setLayout(borderLayout);
        topPanel.setLayout(flowCenter);
        reliancePanel.setLayout(flowCenter);
        this.var1 = new JComboBox();
        this.var2 = new JComboBox();
        for (int i = 1; i <= 10; ++i) {
            this.var1.addItem("Variable " + i);
            this.var2.addItem("Variable " + i);
        }
        this.var1.setSelectedIndex(0);
        this.var2.setSelectedIndex(0);
        topPanel.add(this.var1);
        topPanel.add(new JLabel(" Must Be:"));
        signPanel.setLayout(gridLayout);
        this.conditionGroup = new ButtonGroup();
        JRadioButton b1 = new JRadioButton(">     ");
        JRadioButton b2 = new JRadioButton("<     ");
        JRadioButton b3 = new JRadioButton("==     ");
        JRadioButton b4 = new JRadioButton(">=     ");
        JRadioButton b5 = new JRadioButton("<=     ");
        JRadioButton b6 = new JRadioButton("!=     ");
        b3.setSelected(true);
        this.conditionGroup.add(b1);
        this.conditionGroup.add(b2);
        this.conditionGroup.add(b3);
        this.conditionGroup.add(b4);
        this.conditionGroup.add(b5);
        this.conditionGroup.add(b6);
        signPanel.setAlignmentX(0.5f);
        signPanel.add(b1);
        signPanel.add(b2);
        signPanel.add(b3);
        signPanel.add(b4);
        signPanel.add(b5);
        signPanel.add(b6);
        this.relianceGroup = new ButtonGroup();
        JRadioButton r1 = new JRadioButton("");
        JRadioButton r2 = new JRadioButton("");
        r2.setSelected(true);
        this.relianceGroup.add(r1);
        this.relianceGroup.add(r2);
        reliancePanel.add(r1);
        reliancePanel.add(this.var2);
        reliancePanel.add(r2);
        this.valueField = new JTextField("Value");
        this.valueField.setColumns(5);
        reliancePanel.add(this.valueField);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        bottomPanel.add(okButton);
        bottomPanel.add(cancelButton);
        middlePanel.add((Component)signPanel, "Center");
        middlePanel.add((Component)reliancePanel, "South");
        this.theDialog.add((Component)topPanel, "North");
        this.theDialog.add((Component)middlePanel, "Center");
        this.theDialog.add((Component)bottomPanel, "South");
    }

    public void closeDialogue() {
        this.theDialog.setVisible(false);
        this.theDialog.dispose();
    }

    public boolean validateInputs() {
        int selectedIndex = this.getSelectedButtonIndex(this.relianceGroup);
        if (selectedIndex == 1) {
            return NumberFunctions.validateInteger(this.valueField.getText());
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            if (this.validateInputs()) {
                try {
                    this.eventCondition = new EventCondition(this.getVar1Selection(), this.getVar2orVal(), this.getSelectedOperationCode(), this.getVar2orValBoolean());
                }
                catch (IllegalReferenceValueException irve) {
                    JOptionPane.showMessageDialog(this.theDialog, "Error: Incorrect variable reference");
                    irve.printStackTrace();
                    this.eventCondition = new EventCondition();
                }
                this.closeDialogue();
            } else {
                String error = "Please enter a value or select a variable.\nThe value must be an integer.";
                JOptionPane.showMessageDialog(this.theDialog, error);
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.eventCondition = new EventCondition();
            this.closeDialogue();
        } else {
            System.out.println("invalid action command");
        }
    }

    private int getVar1Selection() {
        return this.var1.getSelectedIndex();
    }

    private boolean getVar2orValBoolean() {
        int selectedIndex = this.getSelectedButtonIndex(this.relianceGroup);
        if (selectedIndex == 0) {
            return false;
        }
        return selectedIndex == 1;
    }

    private int getVar2orVal() {
        boolean varOrVal = this.getVar2orValBoolean();
        if (!varOrVal) {
            return this.var2.getSelectedIndex();
        }
        if (varOrVal) {
            try {
                return Integer.parseInt(this.valueField.getText());
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        System.err.println("Variable Condition Error");
        return 0;
    }

    private int getSelectedButtonIndex(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().isSelected()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getSelectedOperationCode() {
        int selected = this.getSelectedButtonIndex(this.conditionGroup);
        if (selected == 0) {
            return 0;
        }
        if (selected == 1) {
            return 1;
        }
        if (selected == 2) {
            return 2;
        }
        if (selected == 3) {
            return 3;
        }
        if (selected == 4) {
            return 4;
        }
        if (selected == 5) {
            return 5;
        }
        return 2;
    }

    public EventCondition getInput() throws IllegalReferenceValueException {
        this.theDialog.setVisible(true);
        this.theDialog.repaint();
        return this.eventCondition;
    }

    public static void main(String[] args) {
        VariableConditionInput vcm = new VariableConditionInput();
        try {
            vcm.getInput();
        }
        catch (IllegalReferenceValueException irve) {
            System.err.println(irve);
        }
    }
}

