/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.bcb.BreadcrumbBarModel;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbPathEvent;
import org.jvnet.flamingo.bcb.BreadcrumbPathListener;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbItemChoices;
import org.jvnet.flamingo.bcb.ui.BreadcrumbParticle;
import org.jvnet.flamingo.bcb.ui.ChoicesSelector;
import org.jvnet.flamingo.bcb.ui.ScrollablePopup;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.common.ui.ScrollablePanel;
import org.jvnet.flamingo.utils.DoubleArrowResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class BasicBreadcrumbBarUI
extends BreadcrumbBarUI
implements ScrollablePanel.ScrollableSupport {
    protected JBreadcrumbBar breadcrumbBar;
    protected JPanel mainPanel;
    protected ScrollablePanel<JPanel> scrollerPanel;
    protected ComponentListener componentListener;
    protected Stack stack;
    protected int popupInitiatorIndex;
    private JPopupMenu popup = null;
    private Map<Object, Component> comps = new HashMap<Object, Component>();
    protected BreadcrumbPathListener pathListener;
    private AtomicInteger atomicCounter;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBreadcrumbBarUI();
    }

    public void installUI(JComponent c) {
        this.breadcrumbBar = (JBreadcrumbBar)c;
        this.stack = new Stack();
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        c.setLayout(this.createLayoutManager());
        this.popupInitiatorIndex = -1;
        if (this.breadcrumbBar.getCallback() != null) {
            SwingWorker<List<StringValuePair>, Void> worker = new SwingWorker<List<StringValuePair>, Void>(){

                @Override
                protected List<StringValuePair> doInBackground() throws Exception {
                    return BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                }

                @Override
                protected void done() {
                    try {
                        BasicBreadcrumbBarUI.this.pushChoices(new BreadcrumbItemChoices(null, (List)this.get()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            worker.execute();
        }
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((JBreadcrumbBar)c);
        this.uninstallComponents((JBreadcrumbBar)c);
        this.uninstallDefaults((JBreadcrumbBar)c);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(JBreadcrumbBar bar) {
        Font currFont = bar.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            FontUIResource font = FlamingoUtilities.getFont(null, "BreadcrumbBar.font", "Button.font", "Panel.font");
            bar.setFont(font);
        }
    }

    protected void installComponents(JBreadcrumbBar bar) {
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new ScrollablePanel<JPanel>(this.mainPanel, this);
        bar.add(this.scrollerPanel, "Center");
    }

    protected void installListeners(JBreadcrumbBar bar) {
        this.atomicCounter = new AtomicInteger(0);
        this.componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        bar.addComponentListener(this.componentListener);
        this.pathListener = new BreadcrumbPathListener(){
            private SwingWorker<Void, Object> pathChangeWorker;

            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                final int indexOfFirstChange = event.getIndexOfFirstChange();
                if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                    this.pathChangeWorker.cancel(true);
                }
                this.pathChangeWorker = new SwingWorker<Void, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void doInBackground() throws Exception {
                        List items;
                        BasicBreadcrumbBarUI.this.atomicCounter.incrementAndGet();
                        Stack stack = BasicBreadcrumbBarUI.this.stack;
                        synchronized (stack) {
                            if (indexOfFirstChange == 0) {
                                BasicBreadcrumbBarUI.this.stack.clear();
                            } else {
                                int toLeave = indexOfFirstChange * 2 + 1;
                                while (BasicBreadcrumbBarUI.this.stack.size() > toLeave) {
                                    BasicBreadcrumbBarUI.this.stack.pop();
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BasicBreadcrumbBarUI.this.updateComponents();
                            }
                        });
                        if (indexOfFirstChange == 0) {
                            List rootChoices = BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                            BreadcrumbItemChoices bic = new BreadcrumbItemChoices(null, rootChoices);
                            if (!this.isCancelled()) {
                                this.publish(bic);
                            }
                        }
                        if ((items = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel().getItems()) != null) {
                            for (int itemIndex = indexOfFirstChange; itemIndex < items.size() && !this.isCancelled(); ++itemIndex) {
                                BreadcrumbItem item = items.get(itemIndex);
                                this.publish(item);
                                ArrayList subPath = new ArrayList();
                                for (int j = 0; j <= itemIndex; ++j) {
                                    subPath.add(items.get(j));
                                }
                                BreadcrumbItemChoices bic = new BreadcrumbItemChoices(item, BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(subPath));
                                if (bic.getChoices() == null || bic.getChoices().length <= 0) continue;
                                this.publish(bic);
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void process(List<Object> chunks) {
                        if (chunks != null) {
                            for (Object chunk : chunks) {
                                if (this.isCancelled() || BasicBreadcrumbBarUI.this.atomicCounter.get() > 1) break;
                                if (chunk instanceof BreadcrumbItemChoices) {
                                    BasicBreadcrumbBarUI.this.pushChoices((BreadcrumbItemChoices)chunk, false);
                                }
                                if (!(chunk instanceof BreadcrumbItem)) continue;
                                BasicBreadcrumbBarUI.this.pushChoice((BreadcrumbItem)chunk, false);
                            }
                        }
                        BasicBreadcrumbBarUI.this.updateComponents();
                    }

                    @Override
                    protected void done() {
                        BasicBreadcrumbBarUI.this.atomicCounter.decrementAndGet();
                    }
                };
                this.pathChangeWorker.execute();
            }
        };
        this.breadcrumbBar.getModel().addPathListener(this.pathListener);
    }

    protected void uninstallDefaults(JBreadcrumbBar bar) {
    }

    protected void uninstallComponents(JBreadcrumbBar bar) {
        this.mainPanel.removeAll();
        this.comps.clear();
        bar.remove(this.scrollerPanel);
    }

    protected void uninstallListeners(JBreadcrumbBar bar) {
        bar.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.breadcrumbBar.getModel().removePathListener(this.pathListener);
        this.pathListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new ScrollablePopup(15);
            this.popup.setFont(this.breadcrumbBar.getFont());
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
        }
        return this.popup;
    }

    public void hidePopup() {
        this.getPopup().setVisible(false);
    }

    protected synchronized void updateComponents() {
        if (!this.breadcrumbBar.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        this.comps.clear();
        this.scrollerPanel.removeScrollers();
        int width = 0;
        BreadcrumbParticle c = null;
        for (Object element : this.stack) {
            if (element instanceof BreadcrumbItemChoices) {
                BreadcrumbItemChoices bic = (BreadcrumbItemChoices)element;
                c = new ChoicesSelector(this.breadcrumbBar, bic);
                this.comps.put(bic, c);
            } else if (element instanceof BreadcrumbItem) {
                BreadcrumbItem bi = (BreadcrumbItem)element;
                c = new BreadcrumbParticle(this.breadcrumbBar, bi, this.breadcrumbBar.getFontMetrics(this.breadcrumbBar.getFont()).stringWidth(bi.getKey()));
                this.comps.put(bi, c);
            }
            width = (int)((double)width + c.getPreferredSize().getWidth());
            this.mainPanel.add(c);
        }
        this.scrollerPanel.validateScrolling(width, ScrollablePanel.ScrollTo.LAST);
        this.mainPanel.validate();
        this.mainPanel.repaint();
        if (c != null && this.stack.lastElement() instanceof BreadcrumbItem) {
            c.requestFocus();
        }
    }

    public boolean popup(int componentIndex) {
        if (componentIndex < 0 || componentIndex >= this.mainPanel.getComponentCount()) {
            return false;
        }
        Component c = this.mainPanel.getComponent(componentIndex);
        if (c != null && c instanceof ChoicesSelector) {
            ChoicesSelector selector = (ChoicesSelector)c;
            return this.showPopup(selector.getIndex(), selector.getBreadcrumbChoices());
        }
        return false;
    }

    public boolean showPopup(int selectorIndex, BreadcrumbItemChoices bic) {
        BreadcrumbItem c;
        JPopupMenu popup = this.getPopup();
        this.popupInitiatorIndex = selectorIndex;
        popup.removeAll();
        JLabel toSelect = null;
        for (int i = 0; i < bic.getChoices().length; ++i) {
            BreadcrumbItem bi = bic.getChoices()[i];
            PopupAction action = new PopupAction(bic.getAncestor(), bi);
            JMenuItem item = popup.add(action);
            if (item == null) continue;
            item.setFont(this.breadcrumbBar.getFont());
            popup.setBackground(item.getBackground());
            item.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (this.stack.size() > bic.getIndex() + 1 && (c = this.getItem(bic.getIndex() + 1)) != null) {
            toSelect = new JLabel(c.getKey());
        }
        if (bic.getChoices().length > 0) {
            popup.show(this.comps.get(bic), 0, this.comps.get(bic).getHeight());
            if (toSelect != null) {
                popup.setSelected(toSelect);
            }
            return true;
        }
        this.popupInitiatorIndex = -1;
        return false;
    }

    public BreadcrumbParticle getParticle(int selectorIndex) {
        if (selectorIndex == 0 || selectorIndex >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component c = this.mainPanel.getComponent(selectorIndex);
        if (c != null && c instanceof ChoicesSelector) {
            return (BreadcrumbParticle)this.mainPanel.getComponent(selectorIndex - 1);
        }
        return null;
    }

    public ChoicesSelector getSelector(int selectorIndex) {
        if (selectorIndex == 0 || selectorIndex >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component c = this.mainPanel.getComponent(selectorIndex);
        if (c != null && c instanceof ChoicesSelector) {
            return (ChoicesSelector)c;
        }
        return null;
    }

    public JCommandButton createLeftScroller() {
        JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 7));
        b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        b.setFocusable(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
        return b;
    }

    public JCommandButton createRightScroller() {
        JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 3));
        b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        b.setFocusable(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
        return b;
    }

    public int getPopupInitiatorIndex() {
        return this.popupInitiatorIndex;
    }

    protected Object pushChoices(BreadcrumbItemChoices bic) {
        return this.pushChoices(bic, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object pushChoices(BreadcrumbItemChoices bic, boolean toUpdateUI) {
        BreadcrumbItemChoices result;
        if (bic == null) {
            return null;
        }
        Stack stack = this.stack;
        synchronized (stack) {
            if (this.stack.size() % 2 == 1) {
                this.stack.pop();
            }
            bic.setIndex(this.stack.size());
            result = this.stack.push(bic);
        }
        if (toUpdateUI) {
            this.updateComponents();
        }
        return result;
    }

    protected Object pushChoice(BreadcrumbItem bi) {
        return this.pushChoice(bi, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object pushChoice(BreadcrumbItem bi, boolean toUpdateUI) {
        BreadcrumbItem result;
        assert (bi != null);
        Stack stack = this.stack;
        synchronized (stack) {
            if (!this.stack.isEmpty() && this.stack.size() % 2 == 0) {
                this.stack.pop();
            }
            bi.setIndex(this.stack.size());
            result = this.stack.push(bi);
        }
        return result;
    }

    protected BreadcrumbItem getItem(int index) {
        if (this.stack.isEmpty()) {
            return null;
        }
        if (index < 0 || index >= this.stack.size()) {
            return null;
        }
        Object last = this.stack.get(index);
        if (last instanceof BreadcrumbItem) {
            return (BreadcrumbItem)last;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopupAction<T>
    extends AbstractAction {
        BreadcrumbItem<T> ancestorItem;
        BreadcrumbItem<T> itemToSelect;

        public PopupAction(BreadcrumbItem<T> ancestorItem, BreadcrumbItem<T> itemToSelect) {
            super(itemToSelect.getKey(), itemToSelect.getIcon());
            this.ancestorItem = ancestorItem;
            this.itemToSelect = itemToSelect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int toLeave;
                    if (PopupAction.this.itemToSelect == null) {
                        return;
                    }
                    BreadcrumbBarModel barModel = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel();
                    barModel.setCumulative(true);
                    int itemIndex = barModel.indexOf(PopupAction.this.ancestorItem);
                    int n = toLeave = PopupAction.this.ancestorItem == null || itemIndex < 0 ? 0 : itemIndex + 1;
                    while (barModel.getItemCount() > toLeave) {
                        barModel.removeLast();
                    }
                    barModel.addLast(PopupAction.this.itemToSelect);
                    barModel.setCumulative(false);
                }
            });
        }
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(50, 21);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(0, 0, width, height);
        }
    }
}

