/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jvnet.flamingo.common.AsynchronousLoading;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class FilteredResizableIcon
implements ResizableIcon {
    protected Map<String, BufferedImage> cachedImages;
    protected ResizableIcon delegate;
    protected BufferedImageOp operation;

    public FilteredResizableIcon(ResizableIcon delegate, BufferedImageOp operation) {
        this.delegate = delegate;
        this.operation = operation;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        String key = this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(key)) {
            AsynchronousLoading asyncDelegate;
            if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)((Object)this.delegate)).isLoading()) {
                return;
            }
            BufferedImage offscreen = FlamingoUtilities.getBlankImage(this.getIconWidth(), this.getIconHeight());
            Graphics2D g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, g2d, 0, 0);
            g2d.dispose();
            BufferedImage filtered = this.operation.filter(offscreen, null);
            this.cachedImages.put(key, filtered);
        }
        g.drawImage(this.cachedImages.get(key), x, y, null);
    }
}

