/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.model.ActionButtonModel;
import org.jvnet.flamingo.common.model.PopupButtonModel;
import org.jvnet.flamingo.common.ui.CommandButtonUI;
import org.jvnet.flamingo.common.ui.ScrollablePanel;

public class BasicPopupButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener {
    public void focusLost(FocusEvent e) {
        AbstractCommandButton b = (AbstractCommandButton)e.getSource();
        b.getActionModel().setArmed(false);
        b.getActionModel().setPressed(false);
        if (b instanceof JCommandButton) {
            PopupButtonModel popupModel = ((JCommandButton)b).getPopupModel();
            popupModel.setPressed(false);
            popupModel.setArmed(false);
        }
    }

    public void focusGained(FocusEvent e) {
        AbstractCommandButton b = (AbstractCommandButton)e.getSource();
        b.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            AbstractCommandButton b = (AbstractCommandButton)e.getSource();
            ScrollablePanel scrollable = (ScrollablePanel)SwingUtilities.getAncestorOfClass(ScrollablePanel.class, b);
            if (scrollable != null) {
                Point loc = SwingUtilities.convertPoint(b.getParent(), b.getLocation(), scrollable.getView());
                ((JComponent)scrollable.getView()).scrollRectToVisible(new Rectangle(loc.x, loc.y, b.getWidth(), b.getHeight()));
            }
            if (b.contains(e.getX(), e.getY())) {
                PopupButtonModel popupModel;
                CommandButtonUI ui = b.getUI();
                Rectangle actionRect = ui.getActionClickArea();
                Rectangle popupRect = ui.getPopupClickArea();
                if (actionRect != null && actionRect.contains(e.getPoint())) {
                    ActionButtonModel actionModel = b.getActionModel();
                    if (actionModel.isEnabled()) {
                        actionModel.setArmed(true);
                        actionModel.setPressed(true);
                    }
                } else if (popupRect != null && popupRect.contains(e.getPoint()) && (popupModel = ((JCommandButton)b).getPopupModel()).isEnabled()) {
                    popupModel.setArmed(true);
                    popupModel.setPressed(true);
                }
                if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                    b.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            AbstractCommandButton b = (AbstractCommandButton)e.getSource();
            b.getActionModel().setPressed(false);
            if (b instanceof JCommandButton) {
                ((JCommandButton)b).getPopupModel().setPressed(false);
            }
            b.getActionModel().setArmed(false);
            if (b instanceof JCommandButton) {
                ((JCommandButton)b).getPopupModel().setArmed(false);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.syncMouseMovement(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.syncMouseMovement(e);
    }

    private void syncMouseMovement(MouseEvent e) {
        AbstractCommandButton b = (AbstractCommandButton)e.getSource();
        ActionButtonModel actionModel = b.getActionModel();
        PopupButtonModel popupModel = b instanceof JCommandButton ? ((JCommandButton)b).getPopupModel() : null;
        CommandButtonUI ui = b.getUI();
        Rectangle actionRect = ui.getActionClickArea();
        Rectangle popupRect = ui.getPopupClickArea();
        if (actionRect != null && actionRect.contains(e.getPoint())) {
            if (actionModel.isEnabled()) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    actionModel.setRollover(true);
                }
                if (actionModel.isPressed()) {
                    actionModel.setArmed(true);
                }
            }
            if (popupModel != null && !SwingUtilities.isLeftMouseButton(e)) {
                popupModel.setRollover(false);
            }
        } else if (popupRect != null && popupRect.contains(e.getPoint())) {
            if (popupModel != null && popupModel.isEnabled()) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    popupModel.setRollover(true);
                }
                if (popupModel.isPressed()) {
                    popupModel.setArmed(true);
                }
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                actionModel.setRollover(false);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        AbstractCommandButton b = (AbstractCommandButton)e.getSource();
        ActionButtonModel actionModel = b.getActionModel();
        PopupButtonModel popupModel = b instanceof JCommandButton ? ((JCommandButton)b).getPopupModel() : null;
        actionModel.setRollover(false);
        actionModel.setArmed(false);
        if (popupModel != null) {
            popupModel.setRollover(false);
            popupModel.setArmed(false);
        }
    }

    public void stateChanged(ChangeEvent e) {
        AbstractCommandButton b = (AbstractCommandButton)e.getSource();
        b.repaint();
    }

    public void installKeyboardActions(AbstractCommandButton button) {
        ActionMap map = new ActionMap();
        map.put("pressed", new PressAction(button));
        map.put("released", new ReleaseAction(button));
        SwingUtilities.replaceUIActionMap(button, map);
        InputMap km = LookAndFeel.makeInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"});
        SwingUtilities.replaceUIInputMap(button, 0, km);
    }

    public void uninstallKeyboardActions(AbstractCommandButton button) {
        SwingUtilities.replaceUIInputMap(button, 2, null);
        SwingUtilities.replaceUIInputMap(button, 0, null);
        SwingUtilities.replaceUIActionMap(button, null);
    }

    private static class ReleaseAction
    extends AbstractAction {
        private static final String RELEASE = "released";
        AbstractCommandButton button;

        ReleaseAction(AbstractCommandButton button) {
            super(RELEASE);
            this.button = button;
        }

        public void actionPerformed(ActionEvent e) {
            ActionButtonModel model = this.button.getActionModel();
            model.setPressed(false);
            model.setArmed(false);
        }

        public boolean isEnabled() {
            return this.button.getActionModel().isEnabled();
        }
    }

    private static class PressAction
    extends AbstractAction {
        private static final String PRESS = "pressed";
        AbstractCommandButton button;

        PressAction(AbstractCommandButton button) {
            super(PRESS);
            this.button = button;
        }

        public void actionPerformed(ActionEvent e) {
            ActionButtonModel model = this.button.getActionModel();
            model.setArmed(true);
            model.setPressed(true);
            if (!this.button.hasFocus()) {
                this.button.requestFocus();
            }
        }

        public boolean isEnabled() {
            return this.button.getActionModel().isEnabled();
        }
    }
}

