/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JSeparator;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonLayoutManager;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class CommandButtonLayoutManagerBig
implements CommandButtonLayoutManager {
    protected AbstractCommandButton commandButton;
    protected String titlePart1;
    protected String titlePart2;

    public CommandButtonLayoutManagerBig(AbstractCommandButton commandButton) {
        this.commandButton = commandButton;
        this.updateTitleStrings();
    }

    public int getPreferredIconSize() {
        return 32;
    }

    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton == null ? new Insets(0, 0, 0, 0) : commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        JSeparator jsep = new JSeparator(0);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        int title1Width = fm.stringWidth(this.titlePart1);
        int title2Width = fm.stringWidth(this.titlePart2);
        int width = Math.max(this.getPreferredIconSize(), Math.max(title1Width, title2Width + 4 * layoutHGap + jsep.getPreferredSize().height + (FlamingoUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 : 0)));
        int height = by + this.getPreferredIconSize() + layoutVGap + jsep.getPreferredSize().height;
        if (commandButton.getText() != null && commandButton.getText().length() > 0) {
            height += 2 * fm.getAscent() + fm.getDescent();
        }
        return new Dimension(bx + width, height);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName()) || "font".equals(evt.getPropertyName())) {
            this.updateTitleStrings();
        }
    }

    protected void updateTitleStrings() {
        String title;
        BufferedImage tempImage = new BufferedImage(30, 30, 2);
        Graphics2D g = (Graphics2D)tempImage.getGraphics();
        g.setFont(FlamingoUtilities.getFont(this.commandButton, "Ribbon.font", "Button.font", "Panel.font"));
        FontMetrics fm = g.getFontMetrics();
        String string = title = this.commandButton == null ? null : this.commandButton.getText();
        if (title != null) {
            StringTokenizer tokenizer = new StringTokenizer(title, " _-", true);
            if (tokenizer.countTokens() <= 1) {
                this.titlePart1 = title;
                this.titlePart2 = "";
            } else {
                int currMaxLength = (int)fm.getStringBounds(this.commandButton.getText(), g).getWidth();
                int actionIconWidth = FlamingoUtilities.hasPopupAction(this.commandButton) ? 0 : 2 * FlamingoUtilities.getHLayoutGap(this.commandButton) + (fm.getAscent() + fm.getDescent()) / 2;
                String currLeading = "";
                while (tokenizer.hasMoreTokens()) {
                    int len2;
                    String part1 = currLeading = currLeading + tokenizer.nextToken();
                    String part2 = title.substring(currLeading.length());
                    int len1 = (int)fm.getStringBounds(part1, g).getWidth();
                    int len = Math.max(len1, len2 = (int)fm.getStringBounds(part2, g).getWidth() + actionIconWidth);
                    if (currMaxLength <= len) continue;
                    currMaxLength = len;
                    this.titlePart1 = part1;
                    this.titlePart2 = part2;
                }
            }
        } else {
            this.titlePart1 = "";
            this.titlePart2 = "";
        }
    }

    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        return new Point(commandButton.getWidth() / 2, commandButton.getHeight());
    }

    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int x = ins.left;
        int y = ins.top;
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        result.isTextInActionArea = false;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
        }
        JSeparator jsep = new JSeparator(1);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        ResizableIcon buttonIcon = commandButton.getIcon();
        if (commandButton.getText() == null) {
            y = ins.top + (height - ins.top - ins.bottom - buttonIcon.getIconHeight()) / 2;
        }
        result.iconRect.x = (width - buttonIcon.getIconWidth()) / 2;
        result.iconRect.y = y;
        result.iconRect.width = buttonIcon.getIconWidth();
        result.iconRect.height = buttonIcon.getIconHeight();
        y += buttonIcon.getIconHeight();
        if (buttonKind.hasAction() && buttonKind.hasPopup()) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = y + layoutVGap;
            result.popupClickArea.x = 0;
            result.popupClickArea.y = y + layoutVGap;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height - y - layoutVGap;
        }
        y += jsep.getPreferredSize().width;
        int labelWidth = (int)fm.getStringBounds(this.titlePart1, g).getWidth();
        CommandButtonLayoutManager.TextLayoutInfo line1LayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        line1LayoutInfo.text = this.titlePart1;
        line1LayoutInfo.textRect = new Rectangle();
        line1LayoutInfo.textRect.x = ins.left + (width - labelWidth - ins.left - ins.right) / 2;
        line1LayoutInfo.textRect.y = y;
        line1LayoutInfo.textRect.width = labelWidth;
        line1LayoutInfo.textRect.height = labelHeight;
        y += labelHeight;
        labelWidth = (int)fm.getStringBounds(this.titlePart2, g).getWidth();
        int extraWidth = FlamingoUtilities.hasPopupAction(commandButton) ? 4 * layoutHGap + labelHeight / 2 : 0;
        x = ins.left + (width - labelWidth - extraWidth - ins.left - ins.right) / 2;
        CommandButtonLayoutManager.TextLayoutInfo line2LayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        line2LayoutInfo.text = this.titlePart2;
        line2LayoutInfo.textRect = new Rectangle();
        line2LayoutInfo.textRect.x = x;
        line2LayoutInfo.textRect.y = y;
        line2LayoutInfo.textRect.width = labelWidth;
        line2LayoutInfo.textRect.height = labelHeight;
        result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
        result.textLayoutInfoList.add(line1LayoutInfo);
        result.textLayoutInfoList.add(line2LayoutInfo);
        if (FlamingoUtilities.hasPopupAction(commandButton)) {
            x += 2 * layoutHGap;
            result.popupActionRect.x = x += labelWidth;
            result.popupActionRect.y = y - 1;
            result.popupActionRect.width = 1 + labelHeight / 2;
            result.popupActionRect.height = labelHeight + 2;
        }
        return result;
    }
}

