/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.RichTooltip;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonFrame;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenu;
import org.jvnet.flamingo.ribbon.RibbonContextualTaskGroup;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonUI;
import org.jvnet.flamingo.ribbon.ui.RibbonUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks = new ArrayList();
    private ArrayList<RibbonContextualTaskGroup> contextualTaskGroups = new ArrayList();
    private ArrayList<Component> taskbarComponents = new ArrayList();
    private ArrayList<AbstractRibbonBand> bands = new ArrayList();
    private RibbonTask currentlySelectedTask = null;
    private ResizableIcon helpIcon;
    private ActionListener helpActionListener;
    private Map<RibbonContextualTaskGroup, Boolean> groupVisibilityMap = new HashMap<RibbonContextualTaskGroup, Boolean>();
    private RibbonApplicationMenu applicationMenu;
    private RichTooltip applicationMenuRichTooltip;
    private String applicationMenuKeyTip;
    private boolean isMinimized;
    private JRibbonFrame ribbonFrame;
    public static final String uiClassID = "RibbonUI";

    public JRibbon() {
        this.updateUI();
    }

    JRibbon(JRibbonFrame ribbonFrame) {
        this();
        this.ribbonFrame = ribbonFrame;
    }

    public void addTaskbarComponent(Component comp) {
        if (comp instanceof AbstractCommandButton) {
            AbstractCommandButton button = (AbstractCommandButton)comp;
            button.setDisplayState(CommandButtonDisplayState.SMALL);
            button.setGapScaleFactor(0.5);
            button.setFocusable(false);
        }
        this.taskbarComponents.add(comp);
        this.fireStateChanged();
    }

    public void removeTaskbarComponent(Component comp) {
        this.taskbarComponents.remove(comp);
        this.fireStateChanged();
    }

    public void addTask(RibbonTask task) {
        task.setRibbon(this);
        this.tasks.add(task);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
        }
        this.fireStateChanged();
    }

    public void configureHelp(ResizableIcon helpIcon, ActionListener helpActionListener) {
        this.helpIcon = helpIcon;
        this.helpActionListener = helpActionListener;
        this.fireStateChanged();
    }

    public ResizableIcon getHelpIcon() {
        return this.helpIcon;
    }

    public ActionListener getHelpActionListener() {
        return this.helpActionListener;
    }

    public void addContextualTaskGroup(RibbonContextualTaskGroup group) {
        group.setRibbon(this);
        this.contextualTaskGroups.add(group);
        this.groupVisibilityMap.put(group, false);
        this.fireStateChanged();
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public int getContextualTaskGroupCount() {
        return this.contextualTaskGroups.size();
    }

    public RibbonContextualTaskGroup getContextualTaskGroup(int index) {
        return this.contextualTaskGroups.get(index);
    }

    public void setSelectedTask(RibbonTask task) {
        boolean valid = this.tasks.contains(task);
        if (!valid) {
            for (int i = 0; i < this.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup ribbonContextualTaskGroup = this.getContextualTaskGroup(i);
                if (!this.isVisible(ribbonContextualTaskGroup)) continue;
                for (int j = 0; j < ribbonContextualTaskGroup.getTaskCount(); ++j) {
                    if (ribbonContextualTaskGroup.getTask(j) != task) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
            }
        }
        if (!valid) {
            throw new IllegalArgumentException("The specified task to be selected is either not part of this ribbon or not marked as visible");
        }
        for (AbstractRibbonBand abstractRibbonBand : this.bands) {
            abstractRibbonBand.setVisible(false);
        }
        this.bands.clear();
        for (int i = 0; i < task.getBandCount(); ++i) {
            AbstractRibbonBand<?> abstractRibbonBand = task.getBand(i);
            abstractRibbonBand.setVisible(true);
            this.bands.add(abstractRibbonBand);
        }
        RibbonTask old = this.currentlySelectedTask;
        this.currentlySelectedTask = task;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("selectedTask", old, this.currentlySelectedTask);
    }

    public RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonUI());
        }
        for (Component comp : this.taskbarComponents) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public List<Component> getTaskbarComponents() {
        return Collections.unmodifiableList(this.taskbarComponents);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public void setVisible(RibbonContextualTaskGroup group, boolean isVisible) {
        this.groupVisibilityMap.put(group, isVisible);
        if (!isVisible) {
            boolean isSelectedBeingHidden = false;
            for (int i = 0; i < group.getTaskCount(); ++i) {
                if (this.getSelectedTask() != group.getTask(i)) continue;
                isSelectedBeingHidden = true;
                break;
            }
            if (isSelectedBeingHidden) {
                this.setSelectedTask(this.getTask(0));
            }
        }
        this.fireStateChanged();
        this.revalidate();
        SwingUtilities.getWindowAncestor(this).repaint();
    }

    public boolean isVisible(RibbonContextualTaskGroup group) {
        return this.groupVisibilityMap.get(group);
    }

    public void setApplicationMenu(RibbonApplicationMenu applicationMenu) {
        RibbonApplicationMenu old = this.applicationMenu;
        if (old != applicationMenu) {
            this.applicationMenu = applicationMenu;
            if (this.applicationMenu != null) {
                this.applicationMenu.setFrozen();
            }
            this.firePropertyChange("applicationMenu", old, this.applicationMenu);
        }
    }

    public RibbonApplicationMenu getApplicationMenu() {
        return this.applicationMenu;
    }

    public void setApplicationMenuRichTooltip(RichTooltip tooltip) {
        RichTooltip old = this.applicationMenuRichTooltip;
        this.applicationMenuRichTooltip = tooltip;
        this.firePropertyChange("applicationMenuRichTooltip", old, this.applicationMenuRichTooltip);
    }

    public RichTooltip getApplicationMenuRichTooltip() {
        return this.applicationMenuRichTooltip;
    }

    public void setApplicationMenuKeyTip(String keyTip) {
        String old = this.applicationMenuKeyTip;
        this.applicationMenuKeyTip = keyTip;
        this.firePropertyChange("applicationMenuKeyTip", old, this.applicationMenuKeyTip);
    }

    public String getApplicationMenuKeyTip() {
        return this.applicationMenuKeyTip;
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public void setMinimized(boolean isMinimized) {
        boolean old = this.isMinimized;
        if (old != isMinimized) {
            this.isMinimized = isMinimized;
            this.firePropertyChange("minimized", old, this.isMinimized);
        }
    }

    public JRibbonFrame getRibbonFrame() {
        return this.ribbonFrame;
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.getRibbonFrame() != null) {
            throw new IllegalArgumentException("Can't hide ribbon on JRibbonFrame");
        }
        super.setVisible(flag);
    }
}

