/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.resize;

import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.ribbon.JFlowRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonComponent;
import org.jvnet.flamingo.ribbon.RibbonElementPriority;
import org.jvnet.flamingo.ribbon.resize.BaseRibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.resize.IconRibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JFlowBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JRibbonGallery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRibbonResizePolicies {
    public static List<RibbonBandResizePolicy> getCorePoliciesPermissive(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new None((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new Low2Mid((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new Mid2Mid((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new Mirror((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new Mid2Low((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new High2Mid((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new High2Low((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)ribbonBand.getControlPanel()));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCorePoliciesRestrictive(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new Mirror((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new Mid2Low((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new High2Mid((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new High2Low((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)ribbonBand.getControlPanel()));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCorePoliciesNone(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new Mirror((JBandControlPanel)ribbonBand.getControlPanel()));
        result.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)ribbonBand.getControlPanel()));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCoreFlowPoliciesRestrictive(JFlowRibbonBand ribbonBand, int stepsToRepeat) {
        int i;
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        for (i = 0; i < stepsToRepeat; ++i) {
            result.add(new FlowTwoRows((JFlowBandControlPanel)ribbonBand.getControlPanel()));
        }
        for (i = 0; i < stepsToRepeat; ++i) {
            result.add(new FlowThreeRows((JFlowBandControlPanel)ribbonBand.getControlPanel()));
        }
        result.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)ribbonBand.getControlPanel()));
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlowThreeRows
    extends BaseRibbonBandResizePolicy<JFlowBandControlPanel> {
        public FlowThreeRows(JFlowBandControlPanel controlPanel) {
            super(controlPanel);
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            int compCount = ((JFlowBandControlPanel)this.controlPanel).getFlowComponents().size();
            int[] widths = new int[compCount];
            int index = 0;
            int currBestResult = 0;
            for (JComponent flowComp : ((JFlowBandControlPanel)this.controlPanel).getFlowComponents()) {
                int pref = flowComp.getPreferredSize().width;
                widths[index++] = pref;
                currBestResult += pref + gap;
            }
            for (int inflectionIndex1 = 0; inflectionIndex1 < compCount - 2; ++inflectionIndex1) {
                for (int inflectionIndex2 = inflectionIndex1 + 1; inflectionIndex2 < compCount - 1; ++inflectionIndex2) {
                    int w1 = 0;
                    for (int index1 = 0; index1 <= inflectionIndex1; ++index1) {
                        w1 += widths[index1] + gap;
                    }
                    int w2 = 0;
                    for (int index2 = inflectionIndex1 + 1; index2 <= inflectionIndex2; ++index2) {
                        w2 += widths[index2] + gap;
                    }
                    int w3 = 0;
                    for (int index3 = inflectionIndex2 + 1; index3 < compCount; ++index3) {
                        w3 += widths[index3] + gap;
                    }
                    int width = Math.max(Math.max(w1, w2), w3);
                    if (width >= currBestResult) continue;
                    currBestResult = width;
                }
            }
            return currBestResult;
        }

        @Override
        public void install(int availableHeight, int gap) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlowTwoRows
    extends BaseRibbonBandResizePolicy<JFlowBandControlPanel> {
        public FlowTwoRows(JFlowBandControlPanel controlPanel) {
            super(controlPanel);
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            int compCount = ((JFlowBandControlPanel)this.controlPanel).getFlowComponents().size();
            int[] widths = new int[compCount];
            int index = 0;
            int currBestResult = 0;
            for (JComponent flowComp : ((JFlowBandControlPanel)this.controlPanel).getFlowComponents()) {
                int pref = flowComp.getPreferredSize().width;
                widths[index++] = pref;
                currBestResult += pref + gap;
            }
            for (int inflectionIndex = 0; inflectionIndex < compCount - 1; ++inflectionIndex) {
                int w1 = 0;
                for (int index1 = 0; index1 <= inflectionIndex; ++index1) {
                    w1 += widths[index1] + gap;
                }
                int w2 = 0;
                for (int index2 = inflectionIndex + 1; index2 < compCount; ++index2) {
                    w2 += widths[index2] + gap;
                }
                int width = Math.max(w1, w2);
                if (width >= currBestResult) continue;
                currBestResult = width;
            }
            return currBestResult;
        }

        @Override
        public void install(int availableHeight, int gap) {
        }
    }

    public static final class High2Low
    extends BaseCoreRibbonBandResizePolicy {
        public High2Low(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    return RibbonElementPriority.LOW;
                }
            });
        }
    }

    public static final class High2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public High2Mid(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    switch (priority) {
                        case TOP: {
                            return RibbonElementPriority.MEDIUM;
                        }
                        case MEDIUM: {
                            return RibbonElementPriority.LOW;
                        }
                        case LOW: {
                            return RibbonElementPriority.LOW;
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static final class Mid2Low
    extends BaseCoreRibbonBandResizePolicy {
        public Mid2Low(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    switch (priority) {
                        case TOP: {
                            return RibbonElementPriority.TOP;
                        }
                        case MEDIUM: {
                            return RibbonElementPriority.LOW;
                        }
                        case LOW: {
                            return RibbonElementPriority.LOW;
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static final class Mirror
    extends BaseCoreRibbonBandResizePolicy {
        public Mirror(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    return priority;
                }
            });
        }
    }

    public static final class Mid2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public Mid2Mid(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    switch (priority) {
                        case TOP: {
                            return RibbonElementPriority.TOP;
                        }
                        case MEDIUM: {
                            return RibbonElementPriority.MEDIUM;
                        }
                        case LOW: {
                            return RibbonElementPriority.MEDIUM;
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static final class Low2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public Low2Mid(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    switch (priority) {
                        case TOP: {
                            return RibbonElementPriority.TOP;
                        }
                        case MEDIUM: {
                            return RibbonElementPriority.TOP;
                        }
                        case LOW: {
                            return RibbonElementPriority.MEDIUM;
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static final class None
    extends BaseCoreRibbonBandResizePolicy {
        public None(JBandControlPanel controlPanel) {
            super(controlPanel, new Mapping(){

                public RibbonElementPriority map(RibbonElementPriority priority) {
                    return RibbonElementPriority.TOP;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class BaseCoreRibbonBandResizePolicy
    extends BaseRibbonBandResizePolicy<JBandControlPanel> {
        protected Mapping mapping;

        protected BaseCoreRibbonBandResizePolicy(JBandControlPanel controlPanel, Mapping mapping) {
            super(controlPanel);
            this.mapping = mapping;
        }

        protected int getWidth(int gap, List<AbstractCommandButton> bigButtons, List<AbstractCommandButton> mediumButtons, List<AbstractCommandButton> smallButtons) {
            int result = 0;
            for (AbstractCommandButton top : bigButtons) {
                result += this.getPreferredWidth(top, RibbonElementPriority.TOP);
                result += gap;
            }
            int medSize = mediumButtons.size();
            if (medSize > 0) {
                while (mediumButtons.size() % 3 != 0 && smallButtons.size() > 0) {
                    AbstractCommandButton low = smallButtons.remove(0);
                    mediumButtons.add(low);
                }
            }
            int index3 = 0;
            int maxWidth3 = 0;
            for (AbstractCommandButton medium : mediumButtons) {
                int medWidth = this.getPreferredWidth(medium, RibbonElementPriority.MEDIUM);
                maxWidth3 = Math.max(maxWidth3, medWidth);
                if (++index3 != 3) continue;
                index3 = 0;
                result += maxWidth3;
                result += gap;
                maxWidth3 = 0;
            }
            result += maxWidth3;
            if (maxWidth3 > 0) {
                result += gap;
            }
            index3 = 0;
            maxWidth3 = 0;
            for (AbstractCommandButton low : smallButtons) {
                int lowWidth = this.getPreferredWidth(low, RibbonElementPriority.LOW);
                maxWidth3 = Math.max(maxWidth3, lowWidth);
                if (++index3 != 3) continue;
                index3 = 0;
                result += maxWidth3;
                result += gap;
                maxWidth3 = 0;
            }
            return result += maxWidth3;
        }

        private int getPreferredWidth(AbstractCommandButton button, RibbonElementPriority buttonDisplayPriority) {
            CommandButtonDisplayState displayState = null;
            switch (buttonDisplayPriority) {
                case TOP: {
                    displayState = CommandButtonDisplayState.BIG;
                    break;
                }
                case MEDIUM: {
                    displayState = CommandButtonDisplayState.MEDIUM;
                    break;
                }
                case LOW: {
                    displayState = CommandButtonDisplayState.SMALL;
                }
            }
            return displayState.createLayoutManager((AbstractCommandButton)button).getPreferredSize((AbstractCommandButton)button).width;
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            int result = 0;
            Insets ins = ((JBandControlPanel)this.controlPanel).getInsets();
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)this.controlPanel).getControlPanelGroups()) {
                boolean isCoreContent = controlPanelGroup.isCoreContent();
                if (isCoreContent) {
                    int startRowIndex;
                    List<JRibbonComponent> ribbonComps = controlPanelGroup.getRibbonComps();
                    Map<JRibbonComponent, Integer> ribbonCompRowSpans = controlPanelGroup.getRibbonCompsRowSpans();
                    int rowIndex = startRowIndex = controlPanelGroup.getGroupTitle() == null ? 0 : 1;
                    int maxWidthInCurrColumn = 0;
                    for (int i = 0; i < ribbonComps.size(); ++i) {
                        JRibbonComponent coreComp = ribbonComps.get(i);
                        int rowSpan = ribbonCompRowSpans.get(coreComp);
                        int nextRowIndex = rowIndex + rowSpan;
                        if (nextRowIndex > 3) {
                            result += maxWidthInCurrColumn;
                            result += gap;
                            maxWidthInCurrColumn = 0;
                            rowIndex = startRowIndex;
                        }
                        int prefWidth = coreComp.getPreferredSize().width;
                        maxWidthInCurrColumn = Math.max(maxWidthInCurrColumn, prefWidth);
                        rowIndex += rowSpan;
                    }
                    if (rowIndex > 0 && rowIndex <= 3) {
                        result += maxWidthInCurrColumn;
                        result += gap;
                    }
                } else {
                    int galleryAvailableHeight = availableHeight - ins.top - ins.bottom;
                    result += this.getPreferredGalleryWidth(controlPanelGroup, galleryAvailableHeight, gap);
                    result += this.getPreferredButtonWidth(controlPanelGroup, gap);
                }
                result += gap;
            }
            result -= gap;
            return result += ins.left + ins.right;
        }

        protected int getPreferredButtonWidth(JBandControlPanel.ControlPanelGroup controlPanelGroup, int gap) {
            HashMap mapped = new HashMap();
            for (RibbonElementPriority rep : RibbonElementPriority.values()) {
                mapped.put(rep, new ArrayList());
            }
            for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                RibbonElementPriority mappedPriority = this.mapping.map(elementPriority);
                for (AbstractCommandButton button : controlPanelGroup.getRibbonButtons(elementPriority)) {
                    ((List)mapped.get((Object)mappedPriority)).add(button);
                }
            }
            return this.getWidth(gap, (List)mapped.get((Object)RibbonElementPriority.TOP), (List)mapped.get((Object)RibbonElementPriority.MEDIUM), (List)mapped.get((Object)RibbonElementPriority.LOW));
        }

        private int getPreferredGalleryWidth(JBandControlPanel.ControlPanelGroup controlPanelGroup, int galleryAvailableHeight, int gap) {
            int result = 0;
            for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                RibbonElementPriority mappedPriority = this.mapping.map(elementPriority);
                for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                    result += gallery.getPreferredWidth(mappedPriority, galleryAvailableHeight) + gap;
                }
            }
            return result;
        }

        @Override
        public void install(int availableHeight, int gap) {
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)this.controlPanel).getControlPanelGroups()) {
                for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                    RibbonElementPriority mappedPriority = this.mapping.map(elementPriority);
                    for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                        gallery.setDisplayPriority(mappedPriority);
                    }
                }
                HashMap mapped = new HashMap();
                for (RibbonElementPriority rep : RibbonElementPriority.values()) {
                    mapped.put(rep, new ArrayList());
                }
                for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                    RibbonElementPriority mappedPriority = this.mapping.map(elementPriority);
                    for (AbstractCommandButton button : controlPanelGroup.getRibbonButtons(elementPriority)) {
                        ((List)mapped.get((Object)mappedPriority)).add(button);
                    }
                }
                for (AbstractCommandButton big : (List)mapped.get((Object)RibbonElementPriority.TOP)) {
                    big.setDisplayState(CommandButtonDisplayState.BIG);
                }
                if (((List)mapped.get((Object)RibbonElementPriority.MEDIUM)).size() > 0) {
                    while (((List)mapped.get((Object)RibbonElementPriority.MEDIUM)).size() % 3 != 0 && ((List)mapped.get((Object)RibbonElementPriority.LOW)).size() > 0) {
                        AbstractCommandButton low = (AbstractCommandButton)((List)mapped.get((Object)RibbonElementPriority.LOW)).get(0);
                        ((List)mapped.get((Object)RibbonElementPriority.LOW)).remove(low);
                        ((List)mapped.get((Object)RibbonElementPriority.MEDIUM)).add(low);
                    }
                }
                for (AbstractCommandButton medium : (List)mapped.get((Object)RibbonElementPriority.MEDIUM)) {
                    medium.setDisplayState(CommandButtonDisplayState.MEDIUM);
                }
                for (AbstractCommandButton low : (List)mapped.get((Object)RibbonElementPriority.LOW)) {
                    low.setDisplayState(CommandButtonDisplayState.SMALL);
                }
            }
        }
    }

    static interface Mapping {
        public RibbonElementPriority map(RibbonElementPriority var1);
    }
}

