/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.EventDispatcher;

abstract class SvgBatikIcon
extends UserAgentAdapter
implements Icon {
    protected Map<String, BufferedImage> cachedImages = new HashMap<String, BufferedImage>();
    protected int width;
    protected int height;
    protected byte[] svgBytes;
    protected List listeners;
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingCompleted((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingStarted((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingFailed((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingCancelled((GVTTreeRendererEvent)event);
        }
    };

    public SvgBatikIcon(InputStream inputStream, int w, int h) throws IOException {
        int count;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((count = inputStream.read(b)) >= 0) {
            baos.write(b, 0, count);
        }
        this.svgBytes = baos.toByteArray();
        this.width = w;
        this.height = h;
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.renderGVTTree(this.width, this.height);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        if (image != null) {
            int dx = (this.width - image.getWidth()) / 2;
            int dy = (this.height - image.getHeight()) / 2;
            g.drawImage(image, x + dx, y + dy, null);
        }
    }

    public Dimension2D getViewportSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized void setPreferredSize(Dimension dim) {
        if (this.width == dim.width && this.height == dim.height) {
            return;
        }
        this.width = dim.width;
        this.height = dim.height;
        this.renderGVTTree(this.width, this.height);
    }

    public byte[] getSvgBytes() {
        return this.svgBytes;
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, event, true);
    }

    protected boolean renderGVTTree(final int renderWidth, final int renderHeight) {
        String key = renderWidth + ":" + renderHeight;
        if (this.cachedImages.containsKey(key)) {
            return true;
        }
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(){

            @Override
            protected BufferedImage doInBackground() throws Exception {
                GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, null);
                try {
                    ev = new GVTTreeRendererEvent(this, null);
                    SvgBatikIcon.this.fireEvent(startedDispatcher, ev);
                    BufferedImageTranscoder t = new BufferedImageTranscoder();
                    if (renderWidth != 0 && renderHeight != 0) {
                        t.setDimensions(renderWidth, renderHeight);
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(SvgBatikIcon.this.svgBytes);
                    TranscoderInput ti = new TranscoderInput(is);
                    t.transcode(ti, null);
                    BufferedImage result = t.getBufferedImage();
                    return result;
                }
                catch (InterruptedBridgeException e) {
                    SvgBatikIcon.this.fireEvent(cancelledDispatcher, ev);
                }
                catch (ThreadDeath td) {
                    SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
                    throw td;
                }
                catch (Throwable t) {
                    SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block5: {
                    GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, null);
                    try {
                        BufferedImage bufferedImage = (BufferedImage)this.get();
                        if (bufferedImage == null) break block5;
                        SvgBatikIcon svgBatikIcon = SvgBatikIcon.this;
                        synchronized (svgBatikIcon) {
                            SvgBatikIcon.this.cachedImages.put(renderWidth + ":" + renderHeight, bufferedImage);
                        }
                        ev = new GVTTreeRendererEvent(this, bufferedImage);
                        SvgBatikIcon.this.fireEvent(completedDispatcher, ev);
                    }
                    catch (Throwable t) {
                        SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
                    }
                }
            }
        };
        worker.execute();
        return false;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.remove(l);
    }

    public static class BufferedImageTranscoder
    extends ImageTranscoder {
        protected BufferedImage bufferedImage;

        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            this.bufferedImage = img;
        }

        public BufferedImage getBufferedImage() {
            return this.bufferedImage;
        }

        public void setDimensions(int w, int h) {
            this.hints.put(KEY_WIDTH, new Float(w));
            this.hints.put(KEY_HEIGHT, new Float(h));
        }
    }
}

