/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.icon.ImageWrapperResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.common.popup.PopupPanelManager;
import org.jvnet.flamingo.ribbon.JRibbon;
import org.jvnet.flamingo.ribbon.JRibbonFrame;
import org.jvnet.flamingo.ribbon.ui.JRibbonTaskToggleButton;
import org.jvnet.flamingo.ribbon.ui.appmenu.JRibbonApplicationMenuButton;
import org.jvnet.flamingo.utils.ArrowResizableIcon;
import org.jvnet.flamingo.utils.DoubleArrowResizableIcon;

public class FlamingoUtilities {
    public static FontUIResource getFont(Component comp, String ... keys) {
        Font compFont;
        if (comp != null && (compFont = comp.getFont()) != null && !(compFont instanceof UIResource)) {
            return new FontUIResource(compFont);
        }
        for (String key : keys) {
            Font font = UIManager.getFont(key);
            if (font == null) continue;
            if (font instanceof UIResource) {
                return (FontUIResource)font;
            }
            return new FontUIResource(font);
        }
        return null;
    }

    public static Color getColor(Color defaultColor, String ... keys) {
        for (String key : keys) {
            Color color = UIManager.getColor(key);
            if (color == null) continue;
            return color;
        }
        return new ColorUIResource(defaultColor);
    }

    public static ResizableIcon getRibbonBandExpandIcon() {
        return new ArrowResizableIcon(9, 3);
    }

    public static ResizableIcon getCommandButtonPopupActionIcon(JCommandButton.CommandButtonPopupOrientationKind popupOrientationKind) {
        switch (popupOrientationKind) {
            case DOWNWARD: {
                return new DoubleArrowResizableIcon.CommandButtonPopupIcon(7, 5);
            }
            case SIDEWARD: {
                return new DoubleArrowResizableIcon.CommandButtonPopupIcon(7, 3);
            }
        }
        return null;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int requestedThumbWidth) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int width = image.getWidth();
        BufferedImage thumb = image;
        do {
            if ((width /= 2) < requestedThumbWidth) {
                width = requestedThumbWidth;
            }
            BufferedImage temp = new BufferedImage(width, (int)((float)width / ratio), 2);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != requestedThumbWidth);
        return thumb;
    }

    public static GeneralPath getRibbonBorderOutline(int startX, int endX, int startSelectedX, int endSelectedX, int topY, int bandTopY, int bottomY, float radius) {
        int height = bottomY - topY;
        GeneralPath result = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height, 0.5)));
        result.moveTo((float)startX + radius, bandTopY);
        result.lineTo((float)startSelectedX - radius, bandTopY);
        result.moveTo((float)endSelectedX + radius - 1.0f, bandTopY);
        result.lineTo((float)endX - radius - 1.0f, bandTopY);
        result.quadTo((float)endX - radius3 - 1.0f, (float)bandTopY + radius3, endX - 1, (float)bandTopY + radius);
        result.lineTo(endX - 1, (float)bottomY - radius - 1.0f);
        result.quadTo((float)endX - radius3 - 1.0f, (float)(bottomY - 1) - radius3, (float)endX - radius - 1.0f, bottomY - 1);
        result.lineTo((float)startX + radius, bottomY - 1);
        result.quadTo((float)startX + radius3, (float)(bottomY - 1) - radius3, startX, (float)bottomY - radius - 1.0f);
        result.lineTo(startX, (float)bandTopY + radius);
        result.quadTo((float)startX + radius3, (float)bandTopY + radius3, (float)startX + radius, bandTopY);
        return result;
    }

    public static GeneralPath getRibbonTaskToggleButtonOutline(int width, int height, float radius) {
        GeneralPath result = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height, 0.5)));
        result.moveTo(0.0f, height);
        result.lineTo(0.0f, radius);
        result.quadTo(radius3, radius3, radius, 0.0f);
        result.lineTo((float)width - radius - 1.0f, 0.0f);
        result.quadTo((float)width + radius3 - 1.0f, radius3, width - 1, radius);
        result.lineTo(width - 1, height);
        result.lineTo(0.0f, height);
        return result;
    }

    public static GeneralPath getRibbonGalleryOutline(int startX, int endX, int topY, int bottomY, float radius) {
        int height = bottomY - topY;
        GeneralPath result = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height, 0.5)));
        result.moveTo((float)startX + radius, topY);
        result.lineTo((float)endX - radius - 1.0f, topY);
        result.quadTo((float)endX - radius3 - 1.0f, (float)topY + radius3, endX - 1, (float)topY + radius);
        result.lineTo(endX - 1, (float)bottomY - radius - 1.0f);
        result.quadTo((float)endX - radius3 - 1.0f, (float)(bottomY - 1) - radius3, (float)endX - radius - 1.0f, bottomY - 1);
        result.lineTo((float)startX + radius, bottomY - 1);
        result.quadTo((float)startX + radius3, (float)(bottomY - 1) - radius3, startX, (float)bottomY - radius - 1.0f);
        result.lineTo(startX, (float)topY + radius);
        result.quadTo((float)startX + radius3, (float)topY + radius3, (float)startX + radius, topY);
        return result;
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        int w = fullText.length();
        String prevText = "";
        for (int i = 0; i < w; ++i) {
            String newStarter = starter + fullText.charAt(i);
            String newText = newStarter + ellipses;
            if (metrics.stringWidth(newText) > availableWidth) {
                return prevText;
            }
            starter = newStarter;
            prevText = newText;
        }
        return fullText;
    }

    public static BufferedImage getBlankImage(int width, int height) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(width, height, 3);
        return compatibleImage;
    }

    public static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static int getHLayoutGap(AbstractCommandButton commandButton) {
        Font font = commandButton.getFont();
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        return (int)Math.ceil(commandButton.getHGapScaleFactor() * (double)(font.getSize() - 4) / 4.0);
    }

    public static int getVLayoutGap(AbstractCommandButton commandButton) {
        Font font = commandButton.getFont();
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        return (int)Math.ceil(commandButton.getVGapScaleFactor() * (double)(font.getSize() - 4) / 4.0);
    }

    public static boolean hasPopupAction(AbstractCommandButton commandButton) {
        if (commandButton instanceof JCommandButton) {
            JCommandButton jcb = (JCommandButton)commandButton;
            return jcb.getCommandButtonKind().hasPopup();
        }
        return false;
    }

    public static void updateRibbonFrameIconImages(JRibbonFrame ribbonFrame) {
        List<Image> images = ribbonFrame.getIconImages();
        if (images == null || images.size() == 0) {
            return;
        }
        Image bestMatch = null;
        int bestMatchSize = 0;
        for (Image image : images) {
            int imageSize = Math.max(image.getWidth(null), image.getHeight(null));
            if (imageSize > 32 || imageSize <= bestMatchSize) continue;
            bestMatch = image;
            bestMatchSize = imageSize;
        }
        JRibbonApplicationMenuButton appMenuButton = FlamingoUtilities.getApplicationMenuButton(ribbonFrame);
        if (bestMatch != null && appMenuButton != null) {
            appMenuButton.setIcon(ImageWrapperResizableIcon.getIcon(bestMatch, new Dimension(bestMatch.getWidth(null), bestMatch.getHeight(null))));
        }
    }

    public static JRibbonApplicationMenuButton getApplicationMenuButton(Component comp) {
        if (comp instanceof JRibbonApplicationMenuButton) {
            return (JRibbonApplicationMenuButton)comp;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                JRibbonApplicationMenuButton result = FlamingoUtilities.getApplicationMenuButton(cont.getComponent(i));
                if (result == null || !result.isVisible()) continue;
                return result;
            }
        }
        return null;
    }

    public static void renderSurface(Graphics g, Container c, Rectangle rect, boolean toSimulateRollover, boolean hasTopBorder, boolean hasBottomBorder) {
        CellRendererPane buttonRendererPane = new CellRendererPane();
        JButton rendererButton = new JButton("");
        rendererButton.getModel().setRollover(toSimulateRollover);
        buttonRendererPane.setBounds(rect.x, rect.y, rect.width, rect.height);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.clipRect(rect.x, rect.y, rect.width, rect.height);
        buttonRendererPane.paintComponent(g2d, rendererButton, c, rect.x - rect.width / 2, rect.y - rect.height / 2, 2 * rect.width, 2 * rect.height, true);
        g2d.setColor(FlamingoUtilities.getBorderColor());
        if (hasTopBorder) {
            g2d.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
        }
        if (hasBottomBorder) {
            g2d.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        }
        g2d.dispose();
    }

    public static Color getLighterColor(Color color, double diff) {
        int r = color.getRed() + (int)(diff * (double)(255 - color.getRed()));
        int g = color.getGreen() + (int)(diff * (double)(255 - color.getGreen()));
        int b = color.getBlue() + (int)(diff * (double)(255 - color.getBlue()));
        return new Color(r, g, b);
    }

    public static Color getBorderColor() {
        return FlamingoUtilities.getColor(Color.gray, "TextField.inactiveForeground", "Button.disabledText", "ComboBox.disabledForeground");
    }

    public static boolean isShowingMinimizedRibbonInPopup(JRibbon ribbon) {
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() == 0) {
            return false;
        }
        for (PopupPanelManager.PopupInfo popup : popups) {
            JComponent originator = popup.getPopupOriginator();
            if (!(originator instanceof JRibbonTaskToggleButton)) continue;
            return ribbon == SwingUtilities.getAncestorOfClass(JRibbon.class, originator);
        }
        return false;
    }
}

