/*
 * Decompiled with CFR 0.152.
 */
package test.bcb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DisplayFile {
    public static void main(String[] args) {
        String url = "svn://anonsvn.kde.org/home/kde/trunk";
        String name = "anonymous";
        String password = "anonymous";
        String filePath = "KDE/kdebase/README";
        DisplayFile.setupLibrary();
        if (args != null) {
            url = args.length >= 1 ? args[0] : url;
            filePath = args.length >= 2 ? args[1] : filePath;
            name = args.length >= 3 ? args[2] : name;
            password = args.length >= 4 ? args[3] : password;
        }
        SVNRepository repository = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
        }
        catch (SVNException svne) {
            System.err.println("error while creating an SVNRepository for the location '" + url + "': " + svne.getMessage());
            svne.printStackTrace();
            System.exit(1);
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
        repository.setAuthenticationManager(authManager);
        HashMap fileProperties = new HashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SVNNodeKind nodeKind = repository.checkPath(filePath, -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                System.err.println("There is no entry at '" + url + "'.");
                System.exit(1);
            } else if (nodeKind == SVNNodeKind.DIR) {
                System.err.println("The entry at '" + url + "' is a directory while a file was expected.");
                System.exit(1);
            }
            repository.getFile(filePath, -1L, fileProperties, (OutputStream)baos);
        }
        catch (SVNException svne) {
            System.err.println("error while fetching the file contents and properties: " + svne.getMessage());
            svne.printStackTrace();
            System.exit(1);
        }
        String mimeType = (String)fileProperties.get("svn:mime-type");
        boolean isTextType = SVNProperty.isTextMimeType((String)mimeType);
        for (String propertyName : fileProperties.keySet()) {
            String propertyValue = (String)fileProperties.get(propertyName);
            System.out.println("File property: " + propertyName + "=" + propertyValue);
        }
        if (isTextType) {
            System.out.println("File contents:");
            System.out.println();
            try {
                baos.writeTo(System.out);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            System.out.println("File contents can not be displayed in the console since the mime-type property says that it's not a kind of a text file.");
        }
        long latestRevision = -1L;
        try {
            latestRevision = repository.getLatestRevision();
        }
        catch (SVNException svne) {
            System.err.println("error while fetching the latest repository revision: " + svne.getMessage());
            System.exit(1);
        }
        System.out.println("");
        System.out.println("---------------------------------------------");
        System.out.println("Repository latest revision: " + latestRevision);
        System.exit(0);
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }
}

