/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ButtonOutsets
extends JFrame {
    public ButtonOutsets() {
        JPanel controlPanel = new JPanel(new FlowLayout());
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        final JComboBox<UIManager.LookAndFeelInfo> jcb = new JComboBox<UIManager.LookAndFeelInfo>(lafs);
        for (UIManager.LookAndFeelInfo lafi : lafs) {
            if (!UIManager.getLookAndFeel().getName().equals(lafi.getName())) continue;
            jcb.setSelectedItem(lafi);
            break;
        }
        jcb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ButtonOutsets frame = ButtonOutsets.this;
                        try {
                            UIManager.LookAndFeelInfo selected = (UIManager.LookAndFeelInfo)jcb.getSelectedItem();
                            UIManager.setLookAndFeel(selected.getClassName());
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                });
            }
        });
        jcb.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((UIManager.LookAndFeelInfo)value).getName(), index, isSelected, cellHasFocus);
            }
        });
        controlPanel.add(jcb);
        this.add((Component)controlPanel, "South");
        this.add((Component)new MeasurePanel(), "Center");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new ButtonOutsets().setVisible(true);
            }
        });
    }

    private class MeasurePanel
    extends JPanel {
        Insets outsets;

        public MeasurePanel() {
            this.setLayout(null);
            JButton testButton = new JButton("");
            testButton.setOpaque(false);
            testButton.putClientProperty("JButton.buttonStyle", "square");
            testButton.setFocusable(false);
            this.add(testButton);
            testButton.setBounds(100, 50, 100, 30);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        MeasurePanel.this.syncOutsets();
                    }
                }
            });
            this.syncOutsets();
        }

        private void syncOutsets() {
            JPanel panel = new JPanel(null);
            JButton button = new JButton("");
            button.setOpaque(false);
            button.putClientProperty("JButton.buttonStyle", "square");
            button.setFocusable(false);
            panel.add(button);
            button.setBounds(0, 0, 100, 50);
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice d = e.getDefaultScreenDevice();
            GraphicsConfiguration c = d.getDefaultConfiguration();
            BufferedImage compatibleImage = c.createCompatibleImage(100, 50, 3);
            button.paint(compatibleImage.getGraphics());
            int top = -1;
            for (int i = 0; i < 25; ++i) {
                int rgba = compatibleImage.getRGB(50, i);
                int alpha = rgba >>> 24 & 0xFF;
                if (alpha != 255) continue;
                top = i;
                break;
            }
            int bottom = -1;
            for (int i = 49; i > 25; --i) {
                int rgba = compatibleImage.getRGB(50, i);
                int alpha = rgba >>> 24 & 0xFF;
                if (alpha != 255) continue;
                bottom = 49 - i;
                break;
            }
            int left = -1;
            for (int i = 0; i < 50; ++i) {
                int rgba = compatibleImage.getRGB(i, 25);
                int alpha = rgba >>> 24 & 0xFF;
                if (alpha != 255) continue;
                left = i;
                break;
            }
            int right = -1;
            for (int i = 99; i > 50; --i) {
                int rgba = compatibleImage.getRGB(i, 25);
                int alpha = rgba >>> 24 & 0xFF;
                if (alpha != 255) continue;
                right = 99 - i;
                break;
            }
            this.outsets = new Insets(top, left, bottom, right);
        }

        protected void paintComponent(Graphics g) {
            int i;
            g.setColor(new Color(255, 240, 190));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.gray);
            for (i = 95; i <= 205; i += 5) {
                g.drawLine(i, 40, i, 90);
            }
            for (i = 45; i <= 85; i += 5) {
                g.drawLine(90, i, 210, i);
            }
            g.setColor(Color.blue);
            g.drawLine(90, 50, 210, 50);
            g.drawLine(90, 80, 210, 80);
            g.drawLine(100, 40, 100, 90);
            g.drawLine(200, 40, 200, 90);
            g.setColor(Color.black);
            JButton c = (JButton)this.getComponent(0);
            Insets ins = c.getBorder().getBorderInsets(c);
            g.drawString("Content insets : " + ins.toString(), 50, 120);
            g.drawString("Outsets : " + this.outsets.toString(), 50, 150);
        }
    }
}

