/*
 * Decompiled with CFR 0.152.
 */
package test.svg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.RichTooltip;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.common.icon.EmptyResizableIcon;
import org.jvnet.flamingo.svg.SvgBatikResizableIcon;
import org.jvnet.flamingo.svg.SvgStreamTranscoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgFileViewPanel
extends JPanel {
    protected ArrayList<JCommandButton> allButtons;
    protected int currDimension;
    protected BreadcrumbBarCallBack<File> callback;
    private SwingWorker<Void, StringValuePair<InputStream>> mainWorker;

    public SvgFileViewPanel(BreadcrumbBarCallBack<File> callback, int startingDimension) {
        this.callback = callback;
        this.currDimension = startingDimension;
        this.allButtons = new ArrayList();
        this.setLayout(new SvgFileViewPanelLayout());
    }

    public void setFolder(final List<StringValuePair<File>> leafs) {
        for (JCommandButton rb : this.allButtons) {
            this.remove(rb);
        }
        this.allButtons.clear();
        final HashMap<String, JCommandButton> newButtons = new HashMap<String, JCommandButton>();
        for (StringValuePair<File> leaf : leafs) {
            String name = (String)leaf.getKey();
            if (!name.endsWith(".svg") && !name.endsWith(".svgz")) continue;
            JCommandButton svgButton = new JCommandButton(name.replace('-', ' '), new EmptyResizableIcon(this.currDimension));
            RichTooltip richTooltip = new RichTooltip("Transcode", "Click to generate Java2D class");
            svgButton.setActionRichTooltip(richTooltip);
            svgButton.updateCustomDimension(this.currDimension);
            this.allButtons.add(svgButton);
            this.add(svgButton);
            newButtons.put(name, svgButton);
        }
        this.doLayout();
        this.repaint();
        this.mainWorker = new SwingWorker<Void, StringValuePair<InputStream>>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (StringValuePair leafPair : leafs) {
                    if (this.isCancelled()) break;
                    String name = (String)leafPair.getKey();
                    if (!name.endsWith(".svg") && !name.endsWith(".svgz")) continue;
                    InputStream stream = SvgFileViewPanel.this.callback.getLeafContent((File)leafPair.getValue());
                    StringValuePair<InputStream> pair = new StringValuePair<InputStream>(name, stream);
                    this.publish(pair);
                }
                return null;
            }

            @Override
            protected void process(List<StringValuePair<InputStream>> pairs) {
                for (StringValuePair<InputStream> pair : pairs) {
                    final String name = (String)pair.getKey();
                    InputStream svgStream = (InputStream)pair.getValue();
                    Dimension svgDim = new Dimension(SvgFileViewPanel.this.currDimension, SvgFileViewPanel.this.currDimension);
                    final SvgBatikResizableIcon svgIcon = name.endsWith(".svg") ? SvgBatikResizableIcon.getSvgIcon(svgStream, svgDim) : SvgBatikResizableIcon.getSvgzIcon(svgStream, svgDim);
                    JCommandButton svgButton = (JCommandButton)newButtons.get(name);
                    svgButton.setIcon(svgIcon);
                    RichTooltip richTooltip = new RichTooltip("Transcode", "Click to generate Java2D class");
                    svgButton.setActionRichTooltip(richTooltip);
                    svgButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                System.out.println(name);
                                String svgClassName = name.substring(0, name.lastIndexOf(46));
                                svgClassName = svgClassName.replace('-', '_');
                                svgClassName = svgClassName.replace(' ', '_');
                                String javaClassFilename = "C:/temp" + File.separator + svgClassName + ".java";
                                PrintWriter pw = new PrintWriter(javaClassFilename);
                                SvgStreamTranscoder transcoder = new SvgStreamTranscoder(new ByteArrayInputStream(svgIcon.getSvgBytes()), svgClassName);
                                transcoder.setPrintWriter(pw);
                                transcoder.transcode();
                                System.out.println("Finished with '" + javaClassFilename + "'");
                            }
                            catch (Throwable exc) {
                                exc.printStackTrace();
                            }
                        }
                    });
                    svgButton.updateCustomDimension(SvgFileViewPanel.this.currDimension);
                }
            }
        };
        this.mainWorker.execute();
    }

    public void setIconDimension(int dimension) {
        for (JCommandButton rb : this.allButtons) {
            rb.updateCustomDimension(dimension);
            rb.revalidate();
            rb.doLayout();
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
        this.currDimension = dimension;
    }

    public void cancelMainWorker() {
        if (this.mainWorker == null) {
            return;
        }
        if (this.mainWorker.isDone() || this.mainWorker.isCancelled()) {
            return;
        }
        this.mainWorker.cancel(false);
    }

    protected class SvgFileViewPanelLayout
    implements LayoutManager {
        public static final int STRUT = 2;

        protected SvgFileViewPanelLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            int top;
            Insets bInsets = SvgFileViewPanel.this.getInsets();
            int left = bInsets.left + 2;
            int right = bInsets.right + 2;
            int y = top = bInsets.top + 2;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            for (JCommandButton gb : SvgFileViewPanel.this.allButtons) {
                maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                maxButtonHeight = Math.max(maxButtonHeight, gb.getPreferredSize().height);
            }
            int currX = left;
            int maxWidth = parent.getWidth() - left - right;
            for (JCommandButton gb : SvgFileViewPanel.this.allButtons) {
                int endX = currX + maxButtonWidth;
                if (endX > maxWidth - right) {
                    currX = left;
                    y += maxButtonHeight + 2;
                }
                gb.setBounds(currX, y, maxButtonWidth, maxButtonHeight);
                currX += maxButtonWidth;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            if (SvgFileViewPanel.this.allButtons.size() == 0) {
                return new Dimension(0, 0);
            }
            Insets bInsets = SvgFileViewPanel.this.getInsets();
            int left = bInsets.left + 2;
            int right = bInsets.right + 2;
            int top = bInsets.top + 2;
            int bottom = bInsets.bottom + 2;
            int height = top + bottom;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            for (JCommandButton gb : SvgFileViewPanel.this.allButtons) {
                maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                maxButtonHeight = Math.max(maxButtonHeight, gb.getPreferredSize().height);
            }
            int maxWidth = parent.getWidth() - left - right;
            int buttonsInRow = maxWidth / maxButtonWidth;
            int iconRows = (int)Math.ceil((double)SvgFileViewPanel.this.allButtons.size() / (double)buttonsInRow);
            return new Dimension(maxWidth, height += iconRows * (maxButtonHeight + 2));
        }
    }
}

