/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.crypto.PEMDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNGanymedSession {
    private static final int MAX_SESSIONS_PER_CONNECTION = 8;
    private static final long DEFAULT_CONNECTION_TIMEOUT = 600000L;
    private static Map ourConnectionsPool = new Hashtable();
    private static boolean ourIsUsePersistentConnection;
    private static Object ourRequestor;
    private static long ourTimeout;
    private static int ourLockLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSHConnectionInfo getConnection(SVNURL location, SVNSSHAuthentication credentials) throws SVNException {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            int port;
            if ("".equals(credentials.getUserName()) || credentials.getUserName() == null) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "User name is required to establish SSH connection");
                SVNErrorManager.error(error);
            }
            int n = port = location.hasPort() ? location.getPort() : credentials.getPortNumber();
            if (port < 0) {
                port = 22;
            }
            if (!SVNGanymedSession.isUsePersistentConnection()) {
                Connection connection = SVNGanymedSession.openConnection(location, credentials, port);
                SSHConnectionInfo sSHConnectionInfo = new SSHConnectionInfo(null, "unpersistent", connection, false);
                return sSHConnectionInfo;
            }
            String key = credentials.getUserName() + ":" + location.getHost() + ":" + port;
            String id = credentials.getUserName() + ":" + location.getHost() + ":" + port;
            if (credentials.getPrivateKeyFile() != null) {
                key = key + ":" + credentials.getPrivateKeyFile().getAbsolutePath();
            }
            if (credentials.getPassphrase() != null) {
                key = key + ":" + credentials.getPassphrase();
            }
            if (credentials.getPassword() != null) {
                key = key + ":" + credentials.getPassword();
            }
            SSHConnectionInfo connectionInfo = null;
            LinkedList<SSHConnectionInfo> connectionsList = (LinkedList<SSHConnectionInfo>)ourConnectionsPool.get(key);
            if (connectionsList == null) {
                connectionsList = new LinkedList<SSHConnectionInfo>();
                ourConnectionsPool.put(key, connectionsList);
            }
            SVNDebugLog.getDefaultLog().info(ourRequestor + ": EXISTING CONNECTIONS COUNT: " + connectionsList.size());
            Iterator infos = connectionsList.iterator();
            while (infos.hasNext()) {
                SSHConnectionInfo info = (SSHConnectionInfo)infos.next();
                if (info.getSessionCount() >= 8) continue;
                info.resetTimeout();
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": REUSING ONE WITH " + info.getSessionCount() + " SESSIONS");
                SSHConnectionInfo sSHConnectionInfo = info;
                return sSHConnectionInfo;
            }
            SVNDebugLog.getDefaultLog().info(ourRequestor + ": OPENING NEW CONNECTION");
            Connection connection = SVNGanymedSession.openConnection(location, credentials, port);
            connectionInfo = new SSHConnectionInfo(key, id, connection, true);
            connectionsList.add(connectionInfo);
            SVNDebugLog.getDefaultLog().info(ourRequestor + ": NEW CONNECTION OPENED, TOTAL: " + connectionsList.size());
            SSHConnectionInfo sSHConnectionInfo = connectionInfo;
            return sSHConnectionInfo;
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeConnection(SSHConnectionInfo connectionInfo) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            if (!connectionInfo.isPersistent()) {
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": CLOSED, NOT PERSISTENT: " + connectionInfo);
                connectionInfo.dispose();
                return;
            }
            LinkedList connectionsList = (LinkedList)ourConnectionsPool.get(connectionInfo.getKey());
            if (connectionsList.size() <= 1) {
                connectionInfo.startTimeout();
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": NOT CLOSED, SINGLE PERSISTENT: " + connectionInfo);
                return;
            }
            int usable = 0;
            Iterator infos = connectionsList.iterator();
            while (infos.hasNext()) {
                SSHConnectionInfo info = (SSHConnectionInfo)infos.next();
                if (info == connectionInfo || info.getSessionCount() >= 8) continue;
                ++usable;
            }
            if (usable > 0) {
                connectionInfo.dispose();
                connectionsList.remove(connectionInfo);
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": CONNECTION CLOSED: " + connectionInfo);
            } else {
                connectionInfo.startTimeout();
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": CONNECTION NOT CLOSED: " + connectionInfo + ", usable left: " + usable + ", total " + connectionsList.size());
            }
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            Iterator lists = ourConnectionsPool.values().iterator();
            while (lists.hasNext()) {
                LinkedList list = (LinkedList)lists.next();
                Iterator infos = list.iterator();
                while (infos.hasNext()) {
                    SSHConnectionInfo info = (SSHConnectionInfo)infos.next();
                    info.dispose();
                }
            }
            ourConnectionsPool.clear();
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConnectionsCount() {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            int count = 0;
            Iterator keys = ourConnectionsPool.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                LinkedList list = (LinkedList)ourConnectionsPool.get(key);
                count += list.size();
            }
            int n = count;
            return n;
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    private static Connection openConnection(SVNURL location, SVNSSHAuthentication credentials, int port) throws SVNException {
        SVNErrorMessage error;
        File privateKeyFile = credentials.getPrivateKeyFile();
        char[] privateKey = credentials.getPrivateKey();
        if (privateKey == null && privateKeyFile != null) {
            privateKey = SVNGanymedSession.readPrivateKey(privateKeyFile);
        }
        String passphrase = credentials.getPassphrase();
        String password = credentials.getPassword();
        String userName = credentials.getUserName();
        password = "".equals(password) && privateKey != null ? null : password;
        String string = passphrase = "".equals(passphrase) ? null : passphrase;
        if (privateKey != null && !SVNGanymedSession.isValidPrivateKey(privateKey, passphrase)) {
            if (password == null) {
                error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "File ''{0}'' is not valid OpenSSH DSA or RSA private key file", privateKeyFile);
                SVNErrorManager.error(error);
            }
            privateKey = null;
        }
        if (privateKey == null && password == null) {
            error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Either password or private key should be provided to establish SSH connection");
            SVNErrorManager.error(error);
        }
        Connection connection = new Connection(location.getHost(), port);
        try {
            SVNErrorMessage error2;
            connection.connect();
            boolean authenticated = false;
            if (privateKey != null) {
                authenticated = connection.authenticateWithPublicKey(userName, privateKey, passphrase);
            } else if (password != null) {
                String[] methods = connection.getRemainingAuthMethods(userName);
                authenticated = false;
                for (int i = 0; i < methods.length; ++i) {
                    if ("password".equals(methods[i])) {
                        authenticated = connection.authenticateWithPassword(userName, password);
                    } else if ("keyboard-interactive".equals(methods[i])) {
                        final String p = password;
                        authenticated = connection.authenticateWithKeyboardInteractive(userName, new InteractiveCallback(){

                            public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                                String[] reply = new String[numPrompts];
                                for (int i = 0; i < reply.length; ++i) {
                                    reply[i] = p;
                                }
                                return reply;
                            }
                        });
                    }
                    if (!authenticated) {
                        continue;
                    }
                    break;
                }
            } else {
                error2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Either password or private key should be provided to establish SSH connection");
                SVNErrorManager.error(error2);
            }
            if (!authenticated) {
                error2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSH server rejects provided credentials");
                SVNErrorManager.error(error2);
            }
            return connection;
        }
        catch (IOException e) {
            if (connection != null) {
                connection.close();
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", new Object[]{location.setPath("", false), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] readPrivateKey(File privateKey) {
        if (!(privateKey != null && privateKey.exists() && privateKey.isFile() && privateKey.canRead())) {
            return null;
        }
        BufferedReader reader = null;
        StringWriter buffer = new StringWriter();
        try {
            int ch;
            reader = new BufferedReader(new FileReader(privateKey));
            while ((ch = ((Reader)reader).read()) >= 0) {
                buffer.write(ch);
            }
            SVNFileUtil.closeFile(reader);
        }
        catch (IOException e) {
            char[] cArray = null;
            return cArray;
        }
        finally {
            SVNFileUtil.closeFile(reader);
        }
        return buffer.toString().toCharArray();
    }

    private static boolean isValidPrivateKey(char[] privateKey, String passphrase) {
        try {
            PEMDecoder.decode((char[])privateKey, (String)passphrase);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lock(Object requestor) {
        Map map = ourConnectionsPool;
        synchronized (map) {
            if (ourRequestor == requestor) {
                ++ourLockLevel;
                return;
            }
            while (ourRequestor != null) {
                try {
                    ourConnectionsPool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++ourLockLevel;
            ourRequestor = requestor;
            SVNDebugLog.getDefaultLog().info(ourRequestor + ": LOCKED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlock() {
        Map map = ourConnectionsPool;
        synchronized (map) {
            if (--ourLockLevel <= 0) {
                Object requestor = ourRequestor;
                ourLockLevel = 0;
                ourRequestor = null;
                ourConnectionsPool.notify();
                SVNDebugLog.getDefaultLog().info(requestor + ": UNLOCKED");
            }
        }
    }

    static long getTimeout() {
        return ourTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsePersistentConnection() {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            boolean bl = ourIsUsePersistentConnection;
            return bl;
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsePersistentConnection(boolean usePersistent) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            ourIsUsePersistentConnection = usePersistent;
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    static {
        String persistent = System.getProperty("svnkit.ssh2.persistent", System.getProperty("javasvn.ssh2.persistent", Boolean.TRUE.toString()));
        ourIsUsePersistentConnection = Boolean.TRUE.toString().equals(persistent);
        String timeout = System.getProperty("svnkit.ssh2.persistent.timeout", System.getProperty("javasvn.ssh2.persistent.timeout"));
        long value = 600000L;
        if (timeout != null) {
            try {
                value = Long.parseLong(timeout);
                value *= 1000L;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ourTimeout = value;
    }

    public static class SSHConnectionInfo {
        private Connection myConnection;
        private int mySessionCount;
        private boolean myIsPersistent;
        private String myKey;
        private Timer myTimer;
        private String myID;

        public SSHConnectionInfo(String key, String id, Connection connection, boolean persistent) {
            this.myConnection = connection;
            this.myIsPersistent = persistent;
            this.myKey = key;
            this.myID = id;
            SVNDebugLog.getDefaultLog().info(ourRequestor + ": CONNECTION CREATED: " + this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": DISPOSING: " + this);
                if (this.myTimer != null) {
                    this.myTimer.cancel();
                    SVNDebugLog.getDefaultLog().info(ourRequestor + ": TIMER CANCELLED: " + this);
                    this.myTimer = null;
                }
                if (this.myConnection != null) {
                    SVNDebugLog.getDefaultLog().info(ourRequestor + ": CONNECTION CLOSED: " + this);
                    this.myConnection.close();
                    this.myConnection = null;
                }
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPersistent() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                boolean bl = this.myIsPersistent;
                return bl;
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getKey() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                String string = this.myKey;
                return string;
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSessionCount() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                int n = this.mySessionCount;
                return n;
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session openSession() throws IOException {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                Session session = this.myConnection.openSession();
                if (session != null) {
                    ++this.mySessionCount;
                }
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": SESSION OPENED: " + this + "." + this.mySessionCount);
                Session session2 = session;
                return session2;
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimeout() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                if (ourTimeout <= 0L) {
                    return;
                }
                if (this.mySessionCount <= 0) {
                    this.mySessionCount = 0;
                    if (this.isPersistent()) {
                        if (this.myTimer != null) {
                            SVNDebugLog.getDefaultLog().info(ourRequestor + ": TIMER CANCELLED: " + this);
                            this.myTimer.cancel();
                        }
                        this.myTimer = new Timer(true);
                        SVNDebugLog.getDefaultLog().info(ourRequestor + ": TIMEOUT TASK SCHEDULED: " + this);
                        this.myTimer.schedule(new TimerTask(this){
                            private final /* synthetic */ SSHConnectionInfo this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void run() {
                                this.this$0.runTimeout();
                            }
                        }, ourTimeout);
                    }
                }
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetTimeout() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                if (this.myTimer != null) {
                    this.myTimer.cancel();
                    this.myTimer = null;
                }
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean closeSession(Session session) {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                if (session == null) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    session.close();
                    session.waitForCondition(2, 0L);
                    Object var4_4 = null;
                    --this.mySessionCount;
                    SVNDebugLog.getDefaultLog().info(ourRequestor + ": SESSION CLOSED: " + this + "." + this.mySessionCount);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    --this.mySessionCount;
                    SVNDebugLog.getDefaultLog().info(ourRequestor + ": SESSION CLOSED: " + this + "." + this.mySessionCount);
                    throw throwable;
                }
                if (this.mySessionCount <= 0) {
                    this.mySessionCount = 0;
                }
                boolean bl = this.mySessionCount <= 0;
                return bl;
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTimeout() {
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                if (this.mySessionCount > 0) {
                    return;
                }
                SVNDebugLog.getDefaultLog().info(ourRequestor + ": CLOSING BY TIMEOUT: " + this);
                LinkedList list = (LinkedList)ourConnectionsPool.get(this.myKey);
                if (list != null && list.contains(this)) {
                    list.remove(this);
                }
                if (list.isEmpty()) {
                    ourConnectionsPool.remove(this.myKey);
                }
                this.dispose();
            }
            finally {
                SVNGanymedSession.unlock();
            }
        }

        public String toString() {
            return this.myID + " [" + this.hashCode() + "]";
        }
    }
}

