/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNSSLManager;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.util.SVNDebugLog;

public class DefaultSVNSSLManager
implements ISVNSSLManager {
    private SVNURL myURL;
    private File myClientCertFile;
    private String myClientCertPassword;
    private DefaultSVNAuthenticationManager myAuthManager;
    private KeyManager[] myKeyManagers;
    private X509Certificate[] myTrustedCerts;
    private boolean myIsKeyManagerCreated;
    private String myRealm;
    private File myAuthDirectory;
    private boolean myIsUseKeyStore;
    private File[] myServerCertFiles;
    private boolean myIsPromptForClientCert;
    private SVNSSLAuthentication myClientAuthentication;
    private Throwable myClientCertError;

    public DefaultSVNSSLManager(File authDir, SVNURL url, File[] serverCertFiles, boolean useKeyStore, File clientFile, String clientPassword, boolean promptForClientCert, DefaultSVNAuthenticationManager authManager) {
        this.myURL = url;
        this.myAuthDirectory = authDir;
        this.myClientCertFile = clientFile;
        this.myClientCertPassword = clientPassword;
        this.myIsPromptForClientCert = promptForClientCert;
        this.myRealm = "https://" + url.getHost() + ":" + url.getPort();
        this.myAuthManager = authManager;
        this.myIsUseKeyStore = useKeyStore;
        this.myServerCertFiles = serverCertFiles;
        if (this.myClientCertFile != null) {
            this.getKeyManagers();
        }
    }

    public Throwable getClientCertLoadingError() {
        return this.myClientCertError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        ArrayList<X509Certificate> trustedCerts;
        block18: {
            if (this.myTrustedCerts != null) {
                return;
            }
            trustedCerts = new ArrayList<X509Certificate>();
            for (int i = 0; i < this.myServerCertFiles.length; ++i) {
                X509Certificate cert = DefaultSVNSSLManager.loadCertificate(this.myServerCertFiles[i]);
                if (cert == null) continue;
                trustedCerts.add(cert);
            }
            if (this.myIsUseKeyStore) {
                try {
                    KeyStore keyStore;
                    block19: {
                        keyStore = KeyStore.getInstance("JKS");
                        if (keyStore == null) break block18;
                        String path = System.getProperty("java.home") + "/lib/security/cacerts";
                        path = path.replace('/', File.separatorChar);
                        File file = new File(path);
                        InputStream is = null;
                        try {
                            if (file.isFile() && file.canRead()) {
                                is = SVNFileUtil.openFileForReading(file);
                            }
                            keyStore.load(is, null);
                        }
                        catch (NoSuchAlgorithmException e) {
                            SVNFileUtil.closeFile(is);
                            break block19;
                            catch (CertificateException e2) {
                                SVNFileUtil.closeFile(is);
                                break block19;
                                catch (IOException e3) {
                                    SVNFileUtil.closeFile(is);
                                    break block19;
                                    catch (SVNException e4) {
                                        SVNFileUtil.closeFile(is);
                                        break block19;
                                        catch (Throwable throwable) {
                                            SVNFileUtil.closeFile(is);
                                            throw throwable;
                                        }
                                    }
                                }
                            }
                        }
                        SVNFileUtil.closeFile(is);
                    }
                    PKIXParameters params = new PKIXParameters(keyStore);
                    Iterator<TrustAnchor> anchors = params.getTrustAnchors().iterator();
                    while (anchors.hasNext()) {
                        TrustAnchor ta = anchors.next();
                        X509Certificate cert = ta.getTrustedCert();
                        if (cert == null) continue;
                        trustedCerts.add(cert);
                    }
                }
                catch (KeyStoreException e) {
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
        }
        this.myTrustedCerts = trustedCerts.toArray(new X509Certificate[trustedCerts.size()]);
    }

    public SSLContext getSSLContext() throws IOException {
        try {
            SSLContext context = SSLContext.getInstance("SSLv3");
            context.init(this.getKeyManagers(), new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    DefaultSVNSSLManager.this.init();
                    return DefaultSVNSSLManager.this.myTrustedCerts;
                }

                public void checkClientTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] certs, String algorithm) throws CertificateException {
                    if (certs != null && certs.length > 0 && certs[0] != null) {
                        String stored;
                        String data = SVNBase64.byteArrayToBase64(certs[0].getEncoded());
                        if (data.equals(stored = (String)DefaultSVNSSLManager.this.myAuthManager.getRuntimeAuthStorage().getData("svn.ssl.server", DefaultSVNSSLManager.this.myRealm))) {
                            return;
                        }
                        stored = DefaultSVNSSLManager.this.getStoredServerCertificate(DefaultSVNSSLManager.this.myRealm);
                        if (data.equals(stored)) {
                            return;
                        }
                        ISVNAuthenticationProvider authProvider = DefaultSVNSSLManager.this.myAuthManager.getAuthenticationProvider();
                        int failures = DefaultSVNSSLManager.this.getServerCertificateFailures(certs[0]);
                        if (authProvider != null) {
                            boolean store = DefaultSVNSSLManager.this.myAuthManager.isAuthStorageEnabled();
                            int result = authProvider.acceptServerAuthentication(DefaultSVNSSLManager.this.myURL, DefaultSVNSSLManager.this.myRealm, certs[0], store);
                            if (result == 2 && store) {
                                try {
                                    DefaultSVNSSLManager.this.storeServerCertificate(DefaultSVNSSLManager.this.myRealm, data, failures);
                                }
                                catch (SVNException e) {
                                    throw new CertificateException("svn: Server SSL ceritificate for '" + DefaultSVNSSLManager.this.myRealm + "' cannot be saved");
                                }
                            }
                            if (result != 0) {
                                DefaultSVNSSLManager.this.myAuthManager.getRuntimeAuthStorage().putData("svn.ssl.server", DefaultSVNSSLManager.this.myRealm, data);
                                return;
                            }
                            throw new CertificateException("svn: Server SSL ceritificate for '" + DefaultSVNSSLManager.this.myRealm + "' rejected");
                        }
                        return;
                    }
                }
            }}, null);
            return context;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void acknowledgeSSLContext(boolean accepted, SVNErrorMessage errorMessage) {
        if (!accepted) {
            this.myIsKeyManagerCreated = false;
            this.myClientCertError = null;
            this.myKeyManagers = null;
            this.myTrustedCerts = null;
        }
    }

    private int getServerCertificateFailures(X509Certificate cert) {
        String realHostName;
        String hostName;
        int index;
        int mask = 8;
        Date time = new Date(System.currentTimeMillis());
        if (time.before(cert.getNotBefore())) {
            mask |= 1;
        }
        if (time.after(cert.getNotAfter())) {
            mask |= 2;
        }
        if ((index = (hostName = cert.getSubjectDN().getName()).indexOf("CN=") + 3) >= 0) {
            if ((hostName = hostName.substring(index)).indexOf(32) >= 0) {
                hostName = hostName.substring(0, hostName.indexOf(32));
            }
            if (hostName.indexOf(44) >= 0) {
                hostName = hostName.substring(0, hostName.indexOf(44));
            }
        }
        if (!(realHostName = this.myURL.getHost()).equals(hostName)) {
            mask |= 4;
        }
        return mask;
    }

    private String getStoredServerCertificate(String realm) {
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        if (!file.isFile()) {
            return null;
        }
        SVNProperties props = new SVNProperties(file, "");
        try {
            String storedRealm = props.getPropertyValue("svn:realmstring");
            if (!realm.equals(storedRealm)) {
                return null;
            }
            return props.getPropertyValue("ascii_cert");
        }
        catch (SVNException e) {
            return null;
        }
    }

    private void storeServerCertificate(String realm, String data, int failures) throws SVNException {
        this.myAuthDirectory.mkdirs();
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        SVNProperties props = new SVNProperties(file, "");
        props.delete();
        try {
            props.setPropertyValue("ascii_cert", data);
            props.setPropertyValue("svn:realmstring", realm);
            props.setPropertyValue("failures", Integer.toString(failures));
            SVNFileUtil.setReadonly(props.getFile(), false);
        }
        catch (SVNException e) {
            props.delete();
        }
    }

    private KeyManager[] getKeyManagers() {
        if (this.myIsKeyManagerCreated) {
            return this.myKeyManagers;
        }
        this.myIsKeyManagerCreated = true;
        if (this.myClientCertFile == null) {
            return null;
        }
        this.myKeyManagers = this.loadClientCertificate();
        return this.myKeyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] loadClientCertificate() {
        InputStream is;
        char[] passphrase = null;
        if (this.myClientCertPassword != null) {
            passphrase = this.myClientCertPassword.toCharArray();
        }
        KeyStore keyStore = null;
        try {
            is = SVNFileUtil.openFileForReading(this.myClientCertFile);
        }
        catch (SVNException e1) {
            this.myClientCertError = e1;
            return null;
        }
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                keyStore.load(is, passphrase);
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
            this.myClientCertError = th;
            KeyManager[] keyManagerArray = null;
            return keyManagerArray;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        KeyManagerFactory kmf = null;
        KeyManager[] result = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, passphrase);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable e) {
                this.myClientCertError = e;
                SVNDebugLog.getDefaultLog().info(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate loadCertificate(File pemFile) {
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(pemFile);
        }
        catch (SVNException e) {
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(is);
            return x509Certificate;
        }
        catch (CertificateException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }

    public boolean isClientCertPromptRequired() {
        return this.myIsPromptForClientCert;
    }

    public void setClientAuthentication(SVNSSLAuthentication sslAuthentication) {
        if (sslAuthentication != null) {
            this.myClientCertFile = sslAuthentication.getCertificateFile();
            this.myClientCertPassword = sslAuthentication.getPassword();
        } else {
            this.myClientCertFile = null;
            this.myClientCertPassword = null;
        }
        this.myClientAuthentication = sslAuthentication;
        this.myKeyManagers = this.loadClientCertificate();
        this.myIsKeyManagerCreated = true;
    }

    public SVNSSLAuthentication getClientAuthentication() {
        return this.myClientAuthentication;
    }
}

