/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNStatusClient
extends SVNBasicClient {
    public SVNStatusClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNStatusClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, recursive, remote, reportAll, includeIgnored, false, handler);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.HEAD, recursive, remote, reportAll, includeIgnored, collectParentExternals, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doStatus(File path, SVNRevision revision, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, final ISVNStatusHandler handler) throws SVNException {
        SVNStatusEditor editor;
        block22: {
            if (handler == null) {
                return -1L;
            }
            SVNWCAccess wcAccess = this.createWCAccess();
            editor = null;
            final boolean[] deletedInRepository = new boolean[]{false};
            ISVNStatusHandler realHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    if (deletedInRepository[0] && status.getEntry() != null) {
                        status.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
                    }
                    handler.handleStatus(status);
                }
            };
            try {
                SVNAdminAreaInfo info = wcAccess.openAnchor(path, false, recursive ? -1 : 1);
                Map externals = null;
                if (collectParentExternals) {
                    externals = this.collectParentExternals(path, info.getAnchor().getRoot());
                }
                if (remote) {
                    SVNErrorMessage error;
                    SVNEntry entry = wcAccess.getEntry(info.getAnchor().getRoot(), false);
                    if (entry == null) {
                        error = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                        SVNErrorManager.error(error);
                    }
                    if (entry.getURL() == null) {
                        error = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", info.getAnchor().getRoot());
                        SVNErrorManager.error(error);
                    }
                    SVNURL url = entry.getSVNURL();
                    SVNRepository repository = this.createRepository(url, true);
                    long rev = revision == SVNRevision.HEAD ? -1L : this.getRevisionNumber(revision, repository, path);
                    SVNNodeKind kind = repository.checkPath("", rev);
                    this.checkCancelled();
                    if (kind == SVNNodeKind.NONE) {
                        if (!entry.isScheduledForAddition()) {
                            deletedInRepository[0] = true;
                        }
                        editor = new SVNStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, recursive, realHandler);
                        editor.setExternals(externals);
                        this.checkCancelled();
                        editor.closeEdit();
                    } else {
                        editor = new SVNRemoteStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, recursive, realHandler);
                        editor.setExternals(externals);
                        SVNRepository locksRepos = this.createRepository(url, false);
                        this.checkCancelled();
                        SVNReporter reporter = new SVNReporter(info, path, false, recursive, this.getDebugLog());
                        SVNStatusReporter statusReporter = new SVNStatusReporter(locksRepos, reporter, editor);
                        String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
                        repository.status(rev, target, recursive, statusReporter, SVNCancellableEditor.newInstance((ISVNEditor)((Object)editor), this.getEventDispatcher(), this.getDebugLog()));
                    }
                    if (this.getEventDispatcher() != null) {
                        SVNEvent event = SVNEventFactory.createStatusCompletedEvent(info, editor.getTargetRevision());
                        this.getEventDispatcher().handleEvent(event, -1.0);
                    }
                } else {
                    editor = new SVNStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, recursive, handler);
                    editor.setExternals(externals);
                    editor.closeEdit();
                }
                if (this.isIgnoreExternals() || !recursive) break block22;
                externals = editor.getExternals();
                Iterator paths = externals.keySet().iterator();
                while (paths.hasNext()) {
                    String externalPath = (String)paths.next();
                    File externalFile = info.getAnchor().getFile(externalPath);
                    if (SVNFileType.getType(externalFile) != SVNFileType.DIRECTORY) continue;
                    try {
                        int format = SVNAdminAreaFactory.checkWC(externalFile, true);
                        if (format == 0) {
                        }
                    }
                    catch (SVNException e) {}
                    continue;
                    this.handleEvent(SVNEventFactory.createStatusExternalEvent(info, externalPath), -1.0);
                    this.setEventPathPrefix(externalPath);
                    try {
                        this.doStatus(externalFile, recursive, remote, reportAll, includeIgnored, false, handler);
                    }
                    catch (SVNException e) {
                        if (!(e instanceof SVNCancelException)) continue;
                        throw e;
                    }
                    finally {
                        this.setEventPathPrefix(null);
                    }
                }
            }
            finally {
                wcAccess.close();
            }
        }
        return editor.getTargetRevision();
    }

    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.doStatus(path, remote, false);
    }

    public SVNStatus doStatus(File path, boolean remote, boolean collectParentExternals) throws SVNException {
        final SVNStatus[] result = new SVNStatus[]{null};
        final File absPath = path.getAbsoluteFile();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (absPath.equals(status.getFile())) {
                    if (result[0] != null && result[0].getContentsStatus() == SVNStatusType.STATUS_EXTERNAL && absPath.isDirectory()) {
                        result[0] = status;
                        result[0].markExternal();
                    } else if (result[0] == null) {
                        result[0] = status;
                    }
                }
            }
        };
        this.doStatus(absPath, false, remote, true, true, collectParentExternals, handler);
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map collectParentExternals(File path, File root) throws SVNException {
        HashMap<String, SVNExternalInfo> externals = new HashMap<String, SVNExternalInfo>();
        SVNFileType type = SVNFileType.getType(path);
        if (type != SVNFileType.DIRECTORY) {
            return externals;
        }
        File target = path;
        SVNWCAccess wcAccess = this.createWCAccess();
        while ((path = path.getParentFile()) != null) {
            SVNAdminArea area = null;
            try {
                area = wcAccess.open(path, false, 0);
            }
            catch (SVNException e) {
                break;
            }
            try {
                SVNVersionedProperties properties = area.getProperties("");
                String external = properties.getPropertyValue("svn:externals");
                if (externals == null) continue;
                SVNExternalInfo[] infos = SVNWCAccess.parseExternals("", external);
                for (int i = 0; i < infos.length; ++i) {
                    File ext = new File(path, infos[i].getPath());
                    if (!SVNPathUtil.isChildOf(target, ext)) continue;
                    String extPath = ext.getAbsolutePath().replace(File.separatorChar, '/');
                    String rootPath = root.getAbsolutePath().replace(File.separatorChar, '/');
                    String relativePath = extPath.substring(rootPath.length() + 1);
                    externals.put(relativePath, infos[i]);
                }
            }
            finally {
                wcAccess.closeAdminArea(path);
            }
        }
        return externals;
    }
}

