/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import org.basex.core.BaseXException;
import org.basex.data.ExprInfo;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPMethod;
import org.basex.http.restxq.RestXqError;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqParam;
import org.basex.http.restxq.RestXqPath;
import org.basex.http.restxq.RestXqText;
import org.basex.io.MimeTypes;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class RestXqFunction
implements Comparable<RestXqFunction> {
    private static final Pattern TEMPLATE = Pattern.compile("\\s*\\{\\s*\\$(.+?)\\s*\\}\\s*");
    private static final Pattern EQNAME = Pattern.compile("^Q\\{(.*?)\\}(.*)$");
    final Set<String> methods = new HashSet<String>();
    final SerializerOptions output;
    final StaticFunc function;
    private final RestXqModule module;
    RestXqPath path;
    RestXqError error;
    private final ArrayList<RestXqParam> errorParams = new ArrayList();
    final ArrayList<RestXqParam> queryParams = new ArrayList();
    final ArrayList<RestXqParam> formParams = new ArrayList();
    final ArrayList<RestXqParam> headerParams = new ArrayList();
    private final ArrayList<RestXqParam> cookieParams = new ArrayList();
    private final QueryContext context;
    private final StringList consumes = new StringList();
    private final StringList produces = new StringList();
    private QNm requestBody;

    RestXqFunction(StaticFunc uf, QueryContext qc, RestXqModule m) {
        this.function = uf;
        this.context = qc;
        this.module = m;
        this.output = qc.serParams();
    }

    void process(HTTPContext http, QueryException exc) throws Exception {
        try {
            this.module.process(http, this, exc);
        }
        catch (QueryException ex) {
            if (ex.file() == null) {
                ex.info(this.function.info);
            }
            throw ex;
        }
    }

    boolean parse() throws QueryException {
        boolean[] declared = new boolean[this.function.args.length];
        boolean found = false;
        int as = this.function.ann.size();
        for (int a = 0; a < as; ++a) {
            QNm name = this.function.ann.names[a];
            Value value = this.function.ann.values[a];
            InputInfo info = this.function.ann.infos[a];
            byte[] local = name.local();
            byte[] uri = name.uri();
            boolean rexq = Token.eq((byte[])uri, (byte[])QueryText.RESTURI);
            if (rexq) {
                if (Token.eq((byte[])RestXqText.PATH, (byte[])local)) {
                    if (this.path != null) {
                        throw RestXqFunction.error(info, "Annotation %% is specified more than once.", "%", name.string());
                    }
                    try {
                        this.path = new RestXqPath(this.toString(value, name));
                    }
                    catch (IllegalArgumentException ex) {
                        throw RestXqFunction.error(info, ex.getMessage(), new Object[0]);
                    }
                    for (int s = 0; s < this.path.size; ++s) {
                        if (!this.path.isTemplate(s)) continue;
                        this.checkVariable(this.path.segment[s], (Type)AtomType.AAT, declared);
                    }
                } else if (Token.eq((byte[])RestXqText.ERROR, (byte[])local)) {
                    this.error(value, name);
                } else if (Token.eq((byte[])RestXqText.CONSUMES, (byte[])local)) {
                    this.strings(value, name, this.consumes);
                } else if (Token.eq((byte[])RestXqText.PRODUCES, (byte[])local)) {
                    this.strings(value, name, this.produces);
                } else if (Token.eq((byte[])RestXqText.QUERY_PARAM, (byte[])local)) {
                    this.queryParams.add(this.param(value, name, declared));
                } else if (Token.eq((byte[])RestXqText.FORM_PARAM, (byte[])local)) {
                    this.formParams.add(this.param(value, name, declared));
                } else if (Token.eq((byte[])RestXqText.HEADER_PARAM, (byte[])local)) {
                    this.headerParams.add(this.param(value, name, declared));
                } else if (Token.eq((byte[])RestXqText.COOKIE_PARAM, (byte[])local)) {
                    this.cookieParams.add(this.param(value, name, declared));
                } else if (Token.eq((byte[])RestXqText.ERROR_PARAM, (byte[])local)) {
                    this.errorParams.add(this.param(value, name, declared));
                } else if (Token.eq((byte[])RestXqText.METHOD, (byte[])local)) {
                    if (value.size() < 1L) {
                        throw RestXqFunction.error(this.function.info, "Annotation %% requires at least % parameter(s).", "%", name.string(), 1);
                    }
                    String mth = this.toString((Value)value.itemAt(0L), name).toUpperCase(Locale.ENGLISH);
                    Item body = value.size() > 1L ? value.itemAt(1L) : null;
                    this.addMethod(mth, (Value)body, name, declared, info);
                } else {
                    String mth = Token.string((byte[])local);
                    if (HTTPMethod.get(mth) == null) {
                        throw RestXqFunction.error(info, "Annotation %% is invalid or not supported.", "%", name.string());
                    }
                    this.addMethod(mth, value, name, declared, info);
                }
            } else if (Token.eq((byte[])uri, (byte[])QueryText.OUTPUTURI)) {
                try {
                    this.output.assign(Token.string((byte[])local), this.toString(value, name));
                }
                catch (BaseXException ex) {
                    throw RestXqFunction.error(info, "Unknown serialization parameter \"%\".", new Object[]{local});
                }
            }
            found |= rexq;
        }
        if (found) {
            if (this.path == null && this.error == null) {
                throw RestXqFunction.error(this.function.info, "Annotation %% or %% missing.", Character.valueOf('%'), RestXqText.PATH, Character.valueOf('%'), RestXqText.ERROR);
            }
            for (int i = 0; i < declared.length; ++i) {
                if (declared[i]) continue;
                throw RestXqFunction.error(this.function.info, "Variable $% is not assigned by the annotations.", new Object[]{this.function.args[i].name.string()});
            }
        }
        return found;
    }

    private void addMethod(String method, Value body, QNm ann, boolean[] declared, InputInfo info) throws QueryException {
        if (body != null && !body.isEmpty()) {
            HTTPMethod m = HTTPMethod.get(method);
            if (m != null && !m.body) {
                throw RestXqFunction.error(info, "Method % does not allow values.", new Object[]{m});
            }
            if (this.requestBody != null) {
                throw RestXqFunction.error(info, "More than one body request variable specified.", new Object[0]);
            }
            this.requestBody = this.checkVariable(this.toString(body, ann), declared);
        }
        if (this.methods.contains(method)) {
            throw RestXqFunction.error(info, "Annotation %% is specified more than once.", "%", ann.string());
        }
        this.methods.add(method);
    }

    boolean matches(HTTPContext http, QNm err) {
        return (this.methods.isEmpty() || this.methods.contains(http.method)) && this.consumes(http) && this.produces(http) && (err == null ? this.path != null && this.path.matches(http) : this.error != null && this.error.matches(err));
    }

    void bind(HTTPContext http, Expr[] arg, QueryException err) throws QueryException, IOException {
        if (this.path != null) {
            for (int s = 0; s < this.path.size; ++s) {
                Matcher m = TEMPLATE.matcher(this.path.segment[s]);
                if (!m.find()) continue;
                QNm qnm = new QNm(Token.token((String)m.group(1)), this.function.sc);
                if (this.function.sc.elemNS != null && Token.eq((byte[])qnm.uri(), (byte[])this.function.sc.elemNS)) {
                    qnm.uri(Token.EMPTY);
                }
                this.bind(qnm, arg, (Value)new Atm(http.segment(s)));
            }
        }
        if (this.requestBody != null) {
            try {
                this.bind(this.requestBody, arg, http.params.content());
            }
            catch (IOException ex) {
                throw this.error("Input could not be converted: %", ex);
            }
        }
        for (RestXqParam rxp : this.queryParams) {
            this.bind(rxp, arg, http.params.query().get(rxp.key));
        }
        for (RestXqParam rxp : this.formParams) {
            this.bind(rxp, arg, http.params.form().get(rxp.key));
        }
        for (RestXqParam rxp : this.headerParams) {
            TokenList tl = new TokenList();
            Enumeration en = http.req.getHeaders(rxp.key);
            while (en.hasMoreElements()) {
                for (String string : en.nextElement().toString().split(", *")) {
                    tl.add(string);
                }
            }
            this.bind(rxp, arg, StrSeq.get((TokenList)tl));
        }
        Cookie[] ck = http.req.getCookies();
        for (RestXqParam rxp : this.cookieParams) {
            Empty val = Empty.SEQ;
            if (ck != null) {
                for (Cookie cookie : ck) {
                    if (!rxp.key.equals(cookie.getName())) continue;
                    val = Str.get((String)cookie.getValue());
                }
            }
            this.bind(rxp, arg, (Value)val);
        }
        HashMap<String, Value> errs = new HashMap<String, Value>();
        if (err != null) {
            Value[] values = Catch.values((QueryException)err);
            for (int v = 0; v < Catch.NAMES.length; ++v) {
                errs.put(Token.string((byte[])Catch.NAMES[v].local()), values[v]);
            }
        }
        for (RestXqParam rxp : this.errorParams) {
            this.bind(rxp, arg, (Value)errs.get(rxp.key));
        }
    }

    QueryException error(String msg, Object ... ext) {
        return RestXqFunction.error(this.function.info, msg, ext);
    }

    private static QueryException error(InputInfo info, String msg, Object ... ext) {
        return new QueryException(info, Err.BASX_RESTXQ, new Object[]{Util.info((Object)msg, (Object[])ext)});
    }

    @Override
    public int compareTo(RestXqFunction rxf) {
        return this.path == null ? this.error.compareTo(rxf.error) : this.path.compareTo(rxf.path);
    }

    private QNm checkVariable(String tmp, boolean ... declared) throws QueryException {
        return this.checkVariable(tmp, (Type)AtomType.ITEM, declared);
    }

    private QNm checkVariable(String tmp, Type type, boolean ... declared) throws QueryException {
        Var[] args = this.function.args;
        Matcher m = TEMPLATE.matcher(tmp);
        if (!m.find()) {
            throw this.error("Invalid path template: \"%\".", tmp);
        }
        byte[] vn = Token.token((String)m.group(1));
        if (!XMLToken.isQName((byte[])vn)) {
            throw this.error("Invalid variable name: $%.", new Object[]{vn});
        }
        QNm name = new QNm(vn);
        if (name.hasPrefix()) {
            name.uri(this.function.sc.ns.uri(name.prefix()));
        }
        int r = -1;
        while (++r < args.length && !args[r].name.eq(name)) {
        }
        if (r == args.length) {
            throw this.error("Variable $% is not specified as argument.", new Object[]{vn});
        }
        if (declared[r]) {
            throw this.error("Variable $% is specified more than once.", new Object[]{vn});
        }
        SeqType st = args[r].declaredType();
        if (args[r].checksType() && !st.type.instanceOf(type)) {
            throw this.error("Variable $% must inherit from %.", vn, type);
        }
        declared[r] = true;
        return name;
    }

    private boolean consumes(HTTPContext http) {
        if (this.consumes.isEmpty()) {
            return true;
        }
        String ct = http.contentType();
        if (ct == null) {
            return true;
        }
        for (String c : this.consumes) {
            if (!MimeTypes.matches((String)c, (String)ct)) continue;
            return true;
        }
        return false;
    }

    private boolean produces(HTTPContext http) {
        if (this.produces.isEmpty()) {
            return true;
        }
        for (String pr : http.produces()) {
            for (String p : this.produces) {
                if (!MimeTypes.matches((String)p, (String)pr)) continue;
                return true;
            }
        }
        return false;
    }

    private void bind(RestXqParam rxp, Expr[] args, Value value) throws QueryException {
        this.bind(rxp.name, args, value == null || value.isEmpty() ? rxp.value : value);
    }

    private void bind(QNm name, Expr[] args, Value value) throws QueryException {
        if (value == null) {
            return;
        }
        for (int i = 0; i < this.function.args.length; ++i) {
            Var var = this.function.args[i];
            if (!var.name.eq(name)) continue;
            SeqType decl = var.declaredType();
            Value val = value.type().instanceOf(decl) ? value : decl.cast(value, this.context, this.function.sc, null, (ExprInfo)var);
            args[i] = var.checkType(val, this.context, null, false);
            break;
        }
    }

    private String toString(Value value, QNm name) throws QueryException {
        if (value instanceof Str) {
            return ((Str)value).toJava();
        }
        throw RestXqFunction.error(this.function.info, "Single string expected for %%, found: %.", "%", name.string(), value);
    }

    private void strings(Value value, QNm name, StringList list) throws QueryException {
        long vs = value.size();
        int v = 0;
        while ((long)v < vs) {
            list.add(this.toString((Value)value.itemAt((long)v), name));
            ++v;
        }
    }

    private RestXqParam param(Value value, QNm name, boolean ... declared) throws QueryException {
        long vs = value.size();
        if (vs < 2L) {
            throw RestXqFunction.error(this.function.info, "Annotation %% requires at least % parameter(s).", "%", name.string(), 2);
        }
        String key = this.toString((Value)value.itemAt(0L), name);
        QNm qnm = this.checkVariable(this.toString((Value)value.itemAt(1L), name), declared);
        ValueBuilder vb = new ValueBuilder();
        int v = 2;
        while ((long)v < vs) {
            vb.add(value.itemAt((long)v));
            ++v;
        }
        return new RestXqParam(qnm, key, vb.value());
    }

    private void error(Value value, QNm name) throws QueryException {
        if (value.isEmpty()) {
            throw RestXqFunction.error(this.function.info, "Annotation %% requires at least % parameter(s).", "%", name.string(), 1);
        }
        if (this.error == null) {
            this.error = new RestXqError();
        }
        int s = (int)value.size();
        NameTest last = this.error.get(0);
        for (int i = 0; i < s; ++i) {
            Test.Kind kind;
            String err = this.toString((Value)value.itemAt((long)i), name);
            QNm qnm = null;
            if (err.equals("*")) {
                kind = Test.Kind.WILDCARD;
            } else if (err.startsWith("*:")) {
                byte[] local = Token.token((String)err.substring(2));
                if (!XMLToken.isNCName((byte[])local)) {
                    throw this.error("Invalid error code: '%'.", err);
                }
                qnm = new QNm(local);
                kind = Test.Kind.NAME;
            } else if (err.endsWith(":*")) {
                byte[] prefix = Token.token((String)err.substring(0, err.length() - 2));
                if (!XMLToken.isNCName((byte[])prefix)) {
                    throw this.error("Invalid error code: '%'.", err);
                }
                qnm = new QNm(Token.concat((byte[])prefix, (byte[])Token.COLON), this.function.sc);
                kind = Test.Kind.URI;
            } else {
                Matcher m = EQNAME.matcher(err);
                if (m.matches()) {
                    byte[] uri = Token.token((String)m.group(1));
                    byte[] local = Token.token((String)m.group(2));
                    if (local.length == 1 && local[0] == 42) {
                        qnm = new QNm(Token.COLON, uri);
                        kind = Test.Kind.URI;
                    } else {
                        if (!XMLToken.isNCName((byte[])local) || !Uri.uri((byte[])uri).isValid()) {
                            throw this.error("Invalid error code: '%'.", err);
                        }
                        qnm = new QNm(local, uri);
                        kind = Test.Kind.URI_NAME;
                    }
                } else {
                    byte[] nm = Token.token((String)err);
                    if (!XMLToken.isQName((byte[])nm)) {
                        throw this.error("Invalid error code: '%'.", err);
                    }
                    qnm = new QNm(nm, this.function.sc);
                    kind = Test.Kind.URI_NAME;
                }
            }
            if (qnm != null && qnm.hasPrefix() && !qnm.hasURI()) {
                throw this.error("No namespace declared for '%'.", qnm);
            }
            NameTest test = new NameTest(qnm, kind, false, null);
            if (last != null && last.kind != kind) {
                throw this.error("Errors must be of the same priority (\"%\" vs \"%\").", last, test);
            }
            if (!this.error.add(test)) {
                throw this.error("The same error has been specified twice: \"%\".", last);
            }
            last = test;
        }
    }
}

