/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.OutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.basex.core.Proc;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPMethod;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqRespBuilder;
import org.basex.http.restxq.RestXqText;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.MainModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.VarScope;
import org.basex.util.Token;

final class RestXqResponse {
    private final RestXqFunction function;
    private final QueryContext query;
    private final HTTPContext http;
    private final QueryException error;

    RestXqResponse(RestXqFunction rxf, QueryContext ctx, HTTPContext hc, QueryException err) {
        this.function = rxf;
        this.query = ctx;
        this.http = hc;
        this.error = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create() throws Exception {
        Item item;
        Iter iter;
        RestXqRespBuilder resp;
        String forward;
        String redirect;
        block39: {
            ANode node;
            block41: {
                block40: {
                    StaticFunc uf = this.function.function;
                    Expr[] args = new Expr[uf.args.length];
                    this.function.bind(this.http, args, this.error);
                    StaticFuncCall sfc = new StaticFuncCall(uf.name, args, uf.sc, uf.info).init(uf);
                    MainModule mm = new MainModule((Expr)sfc, new VarScope(uf.sc), null, uf.sc);
                    this.query.mainModule(mm);
                    this.query.http((Object)this.http);
                    this.query.context.register((Proc)this.query);
                    redirect = null;
                    forward = null;
                    resp = null;
                    this.query.compile();
                    iter = this.query.iter();
                    item = iter.next();
                    if (item == null || !item.type.isNode()) break block39;
                    node = (ANode)item;
                    if (!RestXqText.REST_REDIRECT.eq(node)) break block40;
                    ANode ch = node.children().next();
                    if (ch == null || ch.type != NodeType.TXT) {
                        throw this.function.error("'%' element has no string value.", new Object[]{node.name()});
                    }
                    redirect = Token.string((byte[])ch.string()).trim();
                    this.query.close();
                    this.query.context.unregister((Proc)this.query);
                    if (redirect != null) {
                        this.http.res.sendRedirect(redirect);
                    } else if (forward != null) {
                        this.http.req.getRequestDispatcher(forward).forward((ServletRequest)this.http.req, (ServletResponse)this.http.res);
                    } else if (resp != null) {
                        if (resp.status != 0) {
                            this.http.status(resp.status, resp.message, resp.error);
                        }
                        this.http.res.getOutputStream().write(resp.cache.toArray());
                    }
                    return;
                }
                if (!RestXqText.REST_FORWARD.eq(node)) break block41;
                ANode ch = node.children().next();
                if (ch == null || ch.type != NodeType.TXT) {
                    throw this.function.error("'%' element has no string value.", new Object[]{node.name()});
                }
                forward = Token.string((byte[])ch.string()).trim();
                this.query.close();
                this.query.context.unregister((Proc)this.query);
                if (redirect != null) {
                    this.http.res.sendRedirect(redirect);
                } else if (forward != null) {
                    this.http.req.getRequestDispatcher(forward).forward((ServletRequest)this.http.req, (ServletResponse)this.http.res);
                } else if (resp != null) {
                    if (resp.status != 0) {
                        this.http.status(resp.status, resp.message, resp.error);
                    }
                    this.http.res.getOutputStream().write(resp.cache.toArray());
                }
                return;
            }
            if (!RestXqText.REST_RESPONSE.eq(node)) break block39;
            resp = new RestXqRespBuilder();
            resp.build(node, this.function, iter, this.http);
            this.query.close();
            this.query.context.unregister((Proc)this.query);
            if (redirect != null) {
                this.http.res.sendRedirect(redirect);
            } else if (forward != null) {
                this.http.req.getRequestDispatcher(forward).forward((ServletRequest)this.http.req, (ServletResponse)this.http.res);
            } else if (resp != null) {
                if (resp.status != 0) {
                    this.http.status(resp.status, resp.message, resp.error);
                }
                this.http.res.getOutputStream().write(resp.cache.toArray());
            }
            return;
        }
        try {
            if (this.function.methods.size() == 1 && this.function.methods.contains(HTTPMethod.HEAD.name())) {
                throw this.function.error("HEAD method must return a single 'restxq:response' element.", new Object[0]);
            }
            SerializerOptions sp = this.function.output;
            this.http.sopts(sp);
            this.http.initResponse();
            Serializer ser = Serializer.get((OutputStream)this.http.res.getOutputStream(), (SerializerOptions)sp);
            while (item != null) {
                ser.serialize(item);
                item = iter.next();
            }
            ser.close();
        }
        catch (Throwable throwable) {
            this.query.close();
            this.query.context.unregister((Proc)this.query);
            if (redirect != null) {
                this.http.res.sendRedirect(redirect);
            } else if (forward != null) {
                this.http.req.getRequestDispatcher(forward).forward((ServletRequest)this.http.req, (ServletResponse)this.http.res);
            } else if (resp != null) {
                if (resp.status != 0) {
                    this.http.status(resp.status, resp.message, resp.error);
                }
                this.http.res.getOutputStream().write(resp.cache.toArray());
            }
            throw throwable;
        }
        this.query.close();
        this.query.context.unregister((Proc)this.query);
        if (redirect != null) {
            this.http.res.sendRedirect(redirect);
        } else if (forward != null) {
            this.http.req.getRequestDispatcher(forward).forward((ServletRequest)this.http.req, (ServletResponse)this.http.res);
        } else if (resp != null) {
            if (resp.status != 0) {
                this.http.status(resp.status, resp.message, resp.error);
            }
            this.http.res.getOutputStream().write(resp.cache.toArray());
        }
    }
}

