/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.AbstractRequest;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.Cookie;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.basex.http.webdav.BXServletCookie;
import org.basex.http.webdav.FileItemWrapper;

final class BXServletRequest
extends AbstractRequest {
    private final HttpServletRequest req;
    private final Request.Method method;
    private final String url;
    private Auth auth;
    private static final Map<Response.ContentType, String> CONTENT_TYPES = new EnumMap<Response.ContentType, String>(Response.ContentType.class);
    private static final Map<String, Response.ContentType> TYPE_CONTENTS = new HashMap<String, Response.ContentType>();
    private static final ThreadLocal<HttpServletRequest> REQUEST;

    public static HttpServletRequest getRequest() {
        return REQUEST.get();
    }

    BXServletRequest(HttpServletRequest r) {
        this.req = r;
        this.method = Request.Method.valueOf((String)r.getMethod());
        this.url = r.getRequestURL().toString();
        REQUEST.set(r);
    }

    public String getFromAddress() {
        return this.req.getRemoteHost();
    }

    public String getRequestHeader(Request.Header header) {
        return this.req.getHeader(header.code);
    }

    public Request.Method getMethod() {
        return this.method;
    }

    public String getAbsoluteUrl() {
        return this.url;
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null || enc.isEmpty()) {
            return null;
        }
        this.auth = new Auth(enc);
        return this.auth;
    }

    public void setAuthorization(Auth a) {
        this.auth = a;
    }

    public InputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration en = this.req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String val = this.req.getHeader(name);
            map.put(name, val);
        }
        return map;
    }

    public Cookie getCookie(String name) {
        for (javax.servlet.http.Cookie c : this.req.getCookies()) {
            if (!c.getName().equals(name)) continue;
            return new BXServletCookie(c);
        }
        return null;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        for (javax.servlet.http.Cookie c : this.req.getCookies()) {
            list.add(new BXServletCookie(c));
        }
        return list;
    }

    public void parseRequestParameters(Map<String, String> params, Map<String, com.bradmcevoy.http.FileItem> files) throws RequestParseException {
        try {
            if (this.isMultiPart()) {
                BXServletRequest.parseQueryString(params, this.req.getQueryString());
                List items = new ServletFileUpload().parseRequest(this.req);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        params.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    files.put(item.getFieldName(), new FileItemWrapper(item));
                }
            } else {
                Enumeration en = this.req.getParameterNames();
                while (en.hasMoreElements()) {
                    String nm = (String)en.nextElement();
                    String val = this.req.getParameter(nm);
                    params.put(nm, val);
                }
            }
        }
        catch (FileUploadException ex) {
            throw new RequestParseException("FileUploadException", (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new RequestParseException(ex.getMessage(), ex);
        }
    }

    private static void parseQueryString(Map<String, String> map, String qs) {
        if (qs == null) {
            return;
        }
        for (String nv : qs.split("&")) {
            String[] parts = nv.split("=");
            String key = parts[0];
            String val = null;
            if (parts.length > 1 && (val = parts[1]) != null) {
                try {
                    val = URLDecoder.decode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            map.put(key, val);
        }
    }

    private Response.ContentType getRequestContentType() {
        String s = this.req.getContentType();
        if (s == null) {
            return null;
        }
        if (s.contains("multipart/form-data")) {
            return Response.ContentType.MULTIPART;
        }
        return TYPE_CONTENTS.get(s);
    }

    private boolean isMultiPart() {
        return this.getRequestContentType() == Response.ContentType.MULTIPART;
    }

    static {
        CONTENT_TYPES.put(Response.ContentType.HTTP, "text/html");
        CONTENT_TYPES.put(Response.ContentType.MULTIPART, "multipart/form-data");
        CONTENT_TYPES.put(Response.ContentType.XML, "text/xml; charset=UTF-8");
        for (Map.Entry<Response.ContentType, String> entry : CONTENT_TYPES.entrySet()) {
            TYPE_CONTENTS.put(entry.getValue(), entry.getKey());
        }
        REQUEST = new ThreadLocal();
    }
}

