/*
 * Decompiled with CFR 0.152.
 */
package org.basex.modules;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.basex.data.Data;
import org.basex.http.HTTPContext;
import org.basex.modules.SessionErrors;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class Session
extends QueryModule {
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str id() throws QueryException {
        return Str.get((String)this.session().getId());
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dtm created() throws QueryException {
        return new Dtm(this.session().getCreationTime(), null);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dtm accessed() throws QueryException {
        return new Dtm(this.session().getLastAccessedTime(), null);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value names() throws QueryException {
        TokenList tl = new TokenList();
        Enumeration en = this.session().getAttributeNames();
        while (en.hasMoreElements()) {
            tl.add((String)en.nextElement());
        }
        return StrSeq.get((TokenList)tl);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Item get(Str key) throws QueryException {
        return this.get(key, null);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    private Item get(Str key, Item def) throws QueryException {
        Object o = this.session().getAttribute(key.toJava());
        if (o == null) {
            return def;
        }
        if (o instanceof Item) {
            return (Item)o;
        }
        throw SessionErrors.noAttribute(Util.className((Object)o));
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public void set(Str key, Item item) throws QueryException {
        Item it = item;
        Data d = it.data();
        if (d != null && !d.inMemory()) {
            it = ((ANode)it).dbCopy(this.queryContext.context.options);
        } else if (it instanceof FItem) {
            throw SessionErrors.functionItem();
        }
        this.session().setAttribute(key.toJava(), (Object)it);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public void delete(Str key) throws QueryException {
        this.session().removeAttribute(key.toJava());
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public void close() throws QueryException {
        this.session().invalidate();
    }

    private HttpSession session() throws QueryException {
        if (this.queryContext.http == null) {
            throw SessionErrors.noContext();
        }
        return ((HTTPContext)this.queryContext.http).req.getSession();
    }
}

