/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.ettrema.event.NewFolderEvent;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkColHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(MkColHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private CollectionResourceCreator collectionResourceCreator = new DefaultCollectionResourceCreator();

    public MkColHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.MKCOL.code};
    }

    @Override
    public boolean isCompatible(Resource r) {
        return r instanceof MakeCollectionableResource;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        try {
            this.process(manager, request, response, this.collectionResourceCreator);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void process(HttpManager manager, Request request, Response response, CollectionResourceCreator creator) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String finalurl = HttpManager.decodeUrl(request.getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug("process request: host: " + host + " url: " + finalurl);
        }
        Path finalpath = Path.path(finalurl);
        String name = finalpath.getName();
        Path parent = finalpath.getParent();
        String parenturl = parent.toString();
        Resource parentcol = manager.getResourceFactory().getResource(host, parenturl);
        if (parentcol != null) {
            log.debug("process: resource: " + parentcol.getClass().getName());
            if (this.handlerHelper.isLockedOut(request, parentcol)) {
                log.warn("isLockedOut");
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            Resource dest = manager.getResourceFactory().getResource(host, finalpath.toString());
            if (dest != null && this.handlerHelper.isLockedOut(request, dest)) {
                this.responseHandler.respondLocked(request, response, dest);
                return;
            }
            if (this.handlerHelper.missingLock(request, parentcol)) {
                response.setStatus(Response.Status.SC_PRECONDITION_FAILED);
                return;
            }
            if (parentcol instanceof CollectionResource) {
                CollectionResource col = (CollectionResource)parentcol;
                this.processMakeCol(manager, request, response, col, name, creator);
            } else {
                log.warn("parent collection is no a CollectionResource: " + parentcol.getName());
                this.responseHandler.respondConflict(parentcol, response, request, "not a collection");
            }
        } else {
            log.warn("parent does not exist: " + parenturl);
            manager.getResponseHandler().respondConflict(parentcol, response, request, name);
        }
    }

    private void processMakeCol(HttpManager manager, Request request, Response response, CollectionResource resource, String newName, CollectionResourceCreator creator) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
        MakeCollectionableResource existingCol;
        block8: {
            if (!this.handlerHelper.checkAuthorisation(manager, resource, request)) {
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            this.handlerHelper.checkExpects(this.responseHandler, request, response);
            existingCol = (MakeCollectionableResource)resource;
            try {
                if (request.getInputStream().read() > -1) {
                    response.setStatus(Response.Status.SC_UNSUPPORTED_MEDIA_TYPE);
                    return;
                }
            }
            catch (Exception ex) {
                if (request.getContentLengthHeader() <= 0L) break block8;
                response.setStatus(Response.Status.SC_UNSUPPORTED_MEDIA_TYPE);
                return;
            }
        }
        if (!this.isCompatible(existingCol)) {
            this.responseHandler.respondMethodNotImplemented(existingCol, response, request);
            return;
        }
        Resource existingChild = existingCol.child(newName);
        if (existingChild != null) {
            log.warn("item already exists: " + existingChild.getName());
            this.responseHandler.respondMethodNotAllowed(existingChild, response, request);
            return;
        }
        CollectionResource made = creator.createResource(existingCol, newName, request);
        if (made == null) {
            log.warn("createCollection returned null. In resource class: " + existingCol.getClass());
            response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
        } else {
            manager.getEventManager().fireEvent(new NewFolderEvent(resource));
            response.setStatus(Response.Status.SC_CREATED);
        }
    }

    private class DefaultCollectionResourceCreator
    implements CollectionResourceCreator {
        private DefaultCollectionResourceCreator() {
        }

        @Override
        public CollectionResource createResource(MakeCollectionableResource existingCol, String newName, Request request) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
            CollectionResource made = existingCol.createCollection(newName);
            return made;
        }
    }

    public static interface CollectionResourceCreator {
        public CollectionResource createResource(MakeCollectionableResource var1, String var2, Request var3) throws ConflictException, NotAuthorizedException, BadRequestException, IOException;
    }
}

