/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.event;

import com.ettrema.event.Event;
import com.ettrema.event.EventListener;
import com.ettrema.event.EventManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerImpl
implements EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManagerImpl.class);
    private final Map<Class, List<EventListener>> listenersMap = new HashMap<Class, List<EventListener>>();

    @Override
    public void fireEvent(Event e) {
        List<EventListener> list;
        if (log.isTraceEnabled()) {
            log.trace("fireEvent: " + e.getClass().getCanonicalName());
        }
        if ((list = this.listenersMap.get(e.getClass())) == null) {
            return;
        }
        for (EventListener l : Collections.unmodifiableCollection(list)) {
            if (log.isTraceEnabled()) {
                log.trace("  firing on: " + l.getClass());
            }
            l.onEvent(e);
        }
    }

    @Override
    public synchronized <T extends Event> void registerEventListener(EventListener l, Class<T> c) {
        log.info("registerEventListener: " + l.getClass().getCanonicalName() + " - " + c.getCanonicalName());
        List<EventListener> list = this.listenersMap.get(c);
        if (list == null) {
            list = new ArrayList<EventListener>();
            this.listenersMap.put(c, list);
        }
        list.add(l);
    }
}

