/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.list.StringList;

abstract class AUser
extends Command {
    AUser(Perm p, String ... a) {
        super(p, a);
    }

    AUser(String ... a) {
        this(Perm.ADMIN, a);
    }

    boolean run(int off, boolean opt) {
        String d;
        String u = this.args[off];
        String string = d = off + 1 < this.args.length ? this.args[off + 1] : null;
        if (!Databases.validName(u, true)) {
            return this.error(Text.NAME_INVALID_X, u);
        }
        if (d != null && !Databases.validName(d, true)) {
            return this.error(Text.NAME_INVALID_X, d);
        }
        String[] users = this.users(u);
        if (users.length == 0) {
            return this.info(Text.UNKNOWN_USER_X, u) && opt;
        }
        StringList dbs = null;
        if (d != null && (dbs = this.context.databases.listDBs(d)).isEmpty()) {
            return this.info(Text.DB_NOT_FOUND_X, d) && opt;
        }
        boolean ok = true;
        for (String user : users) {
            if (dbs == null) {
                ok &= this.run(user, null);
                continue;
            }
            for (String db : dbs) {
                ok &= this.run(user, db);
            }
        }
        return ok;
    }

    boolean run(String user, String db) {
        return true;
    }

    static boolean isMD5(String md5) {
        return md5 != null && md5.matches("[0-9a-fA-F]{32}");
    }

    private String[] users(String name) {
        String pat = name.matches(".*[*?,].*") ? IOFile.regex(name) : name.replaceAll("([" + Databases.REGEXCHARS + "])", "\\\\$1");
        return this.context.users.find(Pattern.compile(pat, Prop.CASE ? 0 : 2));
    }

    @Override
    public void databases(LockResult lr) {
        lr.write.add("%ADMIN");
    }
}

