/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.atomic.AtomicUpdateCache;
import org.basex.io.IOFile;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Delete
extends ACreate {
    public Delete(String target) {
        super(Perm.WRITE, true, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String target = this.args[0];
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        IntList docs = data.resources.docs(target);
        AtomicUpdateCache atomics = new AtomicUpdateCache(data);
        int ds = docs.size();
        for (int d = 0; d < ds; ++d) {
            atomics.addDelete(docs.get(d));
        }
        atomics.execute(false);
        this.context.update();
        TokenList bins = data.resources.binaries(target);
        Delete.delete(data, target);
        data.finishUpdate();
        return this.info(Text.RES_DELETED_X_X, docs.size() + bins.size(), this.perf);
    }

    public static void delete(Data data, String res) {
        if (data.inMemory()) {
            return;
        }
        IOFile file = data.meta.binary(res);
        if (file != null) {
            file.delete();
        }
    }
}

